/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.userinput.field;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.data.ConfigurationOption;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.exception.IzPackException;
import com.izforge.izpack.panels.userinput.field.Config;
import com.izforge.izpack.panels.userinput.processor.Processor;
import com.izforge.izpack.panels.userinput.processorclient.ValuesProcessingClient;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FieldProcessor {
    private final IXMLElement processorElement;
    private final Config config;
    private final String className;
    private final String originalValueVariable;
    private final String toVariable;
    private String originalValue;
    private Processor processor;
    private InstallData installData;
    private static final Logger logger = Logger.getLogger(FieldProcessor.class.getName());

    public FieldProcessor(IXMLElement processorElement, Config config) {
        this.className = config.getAttribute(processorElement, "class");
        this.originalValueVariable = config.getAttribute(processorElement, "backupVariable", true);
        this.toVariable = config.getAttribute(processorElement, "toVariable", true);
        this.processorElement = processorElement;
        this.config = config;
    }

    public void setInstallData(InstallData installData) {
        this.installData = installData;
    }

    public String process(String ... values) {
        String result;
        try {
            if (this.processor == null) {
                this.processor = (Processor)this.config.getFactory().create(this.className, Processor.class, new Object[0]);
            }
            ValuesProcessingClient client = new ValuesProcessingClient(values);
            client.readParameters(this.processorElement);
            Set names = client.getNames();
            if (names != null) {
                for (String key : names) {
                    ConfigurationOption option = client.getConfigurationOption(key);
                    if (this.installData != null) {
                        String value = option.getValue(this.installData.getRules());
                        String newValue = this.installData.getVariables().replace(value);
                        if (value != null && !value.equals(newValue)) {
                            option = new ConfigurationOption(newValue);
                        }
                    }
                    client.addConfigurationOption(key, option);
                }
            }
            this.originalValue = client.getText();
            result = this.processor.process(client);
        }
        catch (Throwable exception) {
            logger.log(Level.WARNING, "Processing using " + this.className + " failed: " + exception.getMessage(), exception);
            if (exception instanceof IzPackException) {
                throw (IzPackException)exception;
            }
            throw new IzPackException("Processing using " + this.className + " failed: " + exception.getMessage(), exception);
        }
        return result;
    }

    public String getBackupVariable() {
        return this.originalValueVariable;
    }

    public String getOriginalValue() {
        return this.originalValue;
    }

    public String getToVariable() {
        return this.toVariable;
    }
}

