/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.datacheck;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.Pack;
import com.izforge.izpack.api.rules.Condition;
import com.izforge.izpack.api.rules.RulesEngine;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;

public class DataCheckCommon {
    public static final String SUB_LABEL = "Debugging InstallData: InstallData variables, packs (selected packs are marked) and conditions.";

    public static String getMainLabelWithDashes(int instanceNumber, String panelId) {
        return "------------------------" + DataCheckCommon.getMainLabel(instanceNumber, panelId) + "------------------------";
    }

    public static String getMainLabel(int instanceNumber, String panelId) {
        return "Data Check Panel, instance: " + instanceNumber + ", panel ID: " + panelId;
    }

    public static String getInstallDataVariables(InstallData installData) {
        Properties properties = installData.getVariables().getProperties();
        ArrayList<String> list = Collections.list(installData.getVariables().getProperties().propertyNames());
        list.sort(String.CASE_INSENSITIVE_ORDER);
        StringBuilder output = new StringBuilder("InstallData Variables:\n");
        for (String varName : list) {
            output.append("\tName: ").append(varName).append(", Value: ").append(properties.getProperty(varName)).append('\n');
        }
        return output.toString();
    }

    public static String getPackNames(InstallData installData) {
        StringBuilder output = new StringBuilder("Available Packs:\n");
        int index = 0;
        List allPacks = installData.getAllPacks();
        if (allPacks == null) {
            return null;
        }
        for (Pack pack : allPacks) {
            String status = installData.getSelectedPacks().contains(pack) ? "Selected" : "Unselected";
            output.append('\t').append(index++).append(": ").append(pack.getName()).append(" (").append(status).append(")\n");
        }
        return output.toString();
    }

    public static String getConditions(InstallData installData) {
        StringBuilder output = new StringBuilder("Conditions:\n");
        RulesEngine rules = installData.getRules();
        ArrayList conditionIds = new ArrayList(rules.getKnownConditionIds());
        conditionIds.sort(String.CASE_INSENSITIVE_ORDER);
        int index = 0;
        for (String conditionId : conditionIds) {
            Condition condition = rules.getCondition(conditionId);
            output.append('\t').append(index++).append(": ").append(condition.getId()).append(" is ").append(condition.isTrue()).append('\n');
        }
        return output.toString();
    }
}

