/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.datacheck;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.gui.InstallerFrame;
import com.izforge.izpack.installer.gui.IzPanel;
import com.izforge.izpack.panels.datacheck.DataCheckCommon;
import java.awt.Container;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JScrollPane;

public class DataCheckPanel
extends IzPanel {
    private static final long serialVersionUID = 3257848774955905587L;
    private static final Logger logger = Logger.getLogger(DataCheckPanel.class.getName());
    protected static int instanceCount = 0;
    protected String panelId;
    protected int instanceNumber;
    protected final JEditorPane panelBody;

    public DataCheckPanel(Panel panel, InstallerFrame parent, GUIInstallData installData, Resources resources) {
        super(panel, parent, installData, resources);
        this.panelId = panel.getPanelId();
        this.instanceNumber = instanceCount++;
        BoxLayout bLayout = new BoxLayout((Container)((Object)this), 1);
        this.setLayout(bLayout);
        JLabel mainLabel = new JLabel(DataCheckCommon.getMainLabel(this.instanceNumber, this.panelId));
        this.add(mainLabel);
        JLabel subLabel = new JLabel("Debugging InstallData: InstallData variables, packs (selected packs are marked) and conditions.");
        this.add(subLabel);
        this.panelBody = new JEditorPane();
        this.panelBody.setEditable(false);
        JScrollPane scrollText = new JScrollPane(this.panelBody);
        this.add(scrollText);
    }

    public void panelActivate() {
        String packNames = DataCheckCommon.getPackNames((InstallData)this.installData);
        String panelBodyText = DataCheckCommon.getInstallDataVariables((InstallData)this.installData) + "\n" + (packNames == null ? "" : packNames + "\n") + DataCheckCommon.getConditions((InstallData)this.installData);
        String infoToLog = DataCheckCommon.getMainLabelWithDashes(this.instanceNumber, this.panelId) + "\n" + "Debugging InstallData: InstallData variables, packs (selected packs are marked) and conditions." + "\n" + panelBodyText;
        logger.fine(infoToLog);
        this.panelBody.setText(panelBodyText);
        this.panelBody.setCaretPosition(0);
    }
}

