/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.installationgroup;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.Pack;
import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.gui.InstallerFrame;
import com.izforge.izpack.installer.gui.IzPanel;
import com.izforge.izpack.panels.installationgroup.GroupData;
import com.izforge.izpack.panels.installationgroup.InstallationGroupPanelAutomationHelper;
import com.izforge.izpack.util.PlatformModelMatcher;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.ListSelectionModel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class InstallationGroupPanel
extends IzPanel
implements ListSelectionListener {
    private static final long serialVersionUID = -8080249125208860785L;
    private static final transient Logger logger = Logger.getLogger(InstallationGroupPanel.class.getName());
    private final PlatformModelMatcher matcher;
    private HashMap<String, Pack> packsByName;
    private TableModel groupTableModel;
    private JTextPane descriptionField;
    private JScrollPane groupScrollPane;
    private JTable groupsTable;
    private GroupData[] rows;
    private int selectedGroup = -1;

    public InstallationGroupPanel(Panel panel, InstallerFrame parent, GUIInstallData installData, Resources resources, PlatformModelMatcher matcher) {
        super(panel, parent, installData, resources);
        this.matcher = matcher;
        this.buildLayout();
    }

    public void panelActivate() {
        this.installData.setAvailablePacks(new ArrayList());
        for (Pack pack : this.installData.getAllPacks()) {
            if (!this.matcher.matchesCurrentPlatform(pack.getOsConstraints())) continue;
            this.installData.getAvailablePacks().add(pack);
        }
        logger.fine("selectedGroup=" + this.selectedGroup);
        HashMap<String, GroupData> installGroups = this.getInstallGroups(this.installData);
        if (installGroups.size() == 0) {
            super.askQuestion("Skip InstallGroup selection", "Skip InstallGroup selection", 37);
            this.parent.skipPanel();
            return;
        }
        this.groupTableModel = this.getModel(installGroups);
        this.groupsTable.setModel(this.groupTableModel);
        TableColumnModel columnModel = this.groupsTable.getColumnModel();
        TableCellRenderer radioButtonRenderer = new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JRadioButton selectedButton;
                if (value == null) {
                    return null;
                }
                int selectedRow = table.getSelectedRow();
                if (selectedRow != -1 && !(selectedButton = (JRadioButton)table.getValueAt(selectedRow, 0)).isSelected()) {
                    selectedButton.doClick();
                }
                JRadioButton button = (JRadioButton)value;
                button.setForeground(isSelected ? table.getSelectionForeground() : table.getForeground());
                button.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
                return button;
            }
        };
        columnModel.getColumn(0).setCellRenderer(radioButtonRenderer);
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setHorizontalAlignment(4);
        columnModel.getColumn(1).setCellRenderer(renderer);
        this.groupsTable.setSelectionMode(0);
        this.groupsTable.getSelectionModel().addListSelectionListener(this);
        this.groupsTable.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.groupsTable.setIntercellSpacing(new Dimension(0, 0));
        this.groupsTable.setShowGrid(false);
        if (this.selectedGroup >= 0) {
            this.groupsTable.getSelectionModel().setSelectionInterval(this.selectedGroup, this.selectedGroup);
            this.descriptionField.setText(this.rows[this.selectedGroup].description);
        } else {
            this.descriptionField.setText(this.rows[0].description);
        }
    }

    public void panelDeactivate() {
        logger.fine("selectedGroup=" + this.selectedGroup);
        if (this.selectedGroup >= 0) {
            this.removeUnusedPacks();
            GroupData group = this.rows[this.selectedGroup];
            this.installData.setVariable("INSTALL_GROUP", group.name);
            logger.fine("Added variable INSTALL_GROUP=" + group.name);
        }
    }

    public boolean isValidated() {
        logger.fine("selectedGroup=" + this.selectedGroup);
        return this.selectedGroup >= 0;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        logger.fine("Event: " + e);
        if (!e.getValueIsAdjusting()) {
            ListSelectionModel listSelectionModel = (ListSelectionModel)e.getSource();
            if (listSelectionModel.isSelectionEmpty()) {
                this.descriptionField.setText("");
            } else {
                this.selectedGroup = listSelectionModel.getMinSelectionIndex();
                if (this.selectedGroup >= 0) {
                    GroupData data = this.rows[this.selectedGroup];
                    this.descriptionField.setText(data.description);
                    ((JRadioButton)this.groupTableModel.getValueAt(this.selectedGroup, 0)).setSelected(true);
                }
                logger.fine("selectedGroup set to: " + this.selectedGroup);
            }
        }
    }

    public void createInstallationRecord(IXMLElement panelRoot) {
        InstallationGroupPanelAutomationHelper helper = new InstallationGroupPanelAutomationHelper();
        this.installData.setAttribute("GroupData", (Object)this.rows);
        helper.createInstallationRecord((InstallData)this.installData, panelRoot);
    }

    public String getSummaryBody() {
        return this.rows[this.selectedGroup].name;
    }

    protected void buildLayout() {
        this.descriptionField = new JTextPane();
        this.groupScrollPane = new JScrollPane();
        this.groupsTable = new JTable();
        this.setLayout(new GridBagLayout());
        this.descriptionField.setMargin(new Insets(2, 2, 2, 2));
        this.descriptionField.setAlignmentX(0.0f);
        this.descriptionField.setCaretPosition(0);
        this.descriptionField.setEditable(false);
        this.descriptionField.setOpaque(false);
        this.descriptionField.setText("<b>Install group description text</b>");
        this.descriptionField.setContentType("text/html");
        this.descriptionField.setBorder(new TitledBorder(this.getString("PacksPanel.description")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.3;
        this.add(this.descriptionField, gridBagConstraints);
        this.groupScrollPane.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.groupScrollPane.setViewportView(this.groupsTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add(this.groupScrollPane, gridBagConstraints);
    }

    protected void removeUnusedPacks() {
        GroupData data = this.rows[this.selectedGroup];
        logger.fine("data=" + data.name);
        Iterator iter = this.installData.getAvailablePacks().iterator();
        while (iter.hasNext()) {
            Pack pack = (Pack)iter.next();
            pack.setDependants(null);
            if (data.packNames.contains(pack.getName())) continue;
            iter.remove();
            logger.fine("Removed available pack: " + pack.getName());
        }
        this.installData.getSelectedPacks().clear();
        if (!"no".equals(this.installData.getVariable("InstallationGroupPanel.selectPacks"))) {
            this.installData.getSelectedPacks().addAll(this.installData.getAvailablePacks());
        } else {
            for (Pack availablePack : this.installData.getAvailablePacks()) {
                if (!availablePack.isPreselected()) continue;
                this.installData.getSelectedPacks().add(availablePack);
            }
        }
    }

    protected void addDependents(Pack p, HashMap<String, Pack> packsByName, GroupData data) {
        data.packNames.add(p.getName());
        data.size += p.getSize();
        logger.fine("Added pack: " + p.getName());
        if (p.getDependencies() == null || p.getDependencies().size() == 0) {
            return;
        }
        logger.fine(p.getName() + ", dependencies: " + p.getDependencies());
        for (String dependent : p.getDependencies()) {
            if (data.packNames.contains(dependent)) continue;
            logger.fine("Need dependent: " + dependent);
            Pack dependentPack = packsByName.get(dependent);
            this.addDependents(dependentPack, packsByName, data);
        }
    }

    protected HashMap<String, GroupData> getInstallGroups(GUIInstallData idata) {
        this.packsByName = new HashMap();
        HashMap<String, GroupData> installGroups = new HashMap<String, GroupData>();
        for (Pack pack : idata.getAvailablePacks()) {
            this.packsByName.put(pack.getName(), pack);
            Set groups = pack.getInstallGroups();
            logger.fine("Pack: " + pack.getName() + ", installGroups: " + groups);
            for (String group : groups) {
                GroupData data = installGroups.get(group);
                if (data != null) continue;
                String description = this.getGroupDescription(group);
                String sortKey = this.getGroupSortKey(group);
                data = new GroupData(group, description, sortKey);
                installGroups.put(group, data);
            }
        }
        logger.fine("Found installGroups: " + installGroups.keySet());
        for (GroupData data : installGroups.values()) {
            logger.fine("Adding dependents for: " + data.name);
            for (Pack pack : idata.getAvailablePacks()) {
                Set groups = pack.getInstallGroups();
                if (groups.size() != 0 && !groups.contains(data.name) || data.packNames.contains(pack.getName())) continue;
                this.addDependents(pack, this.packsByName, data);
            }
            logger.fine("Completed dependents for: " + data);
        }
        return installGroups;
    }

    protected String getGroupDescription(String group) {
        String html;
        String description = null;
        String key = "InstallationGroupPanel.description." + group;
        String htmlKey = key + ".html";
        description = htmlKey.equalsIgnoreCase(html = this.getString(htmlKey)) ? this.getString(key) : html;
        if (description == null || key.equalsIgnoreCase(description)) {
            description = this.installData.getVariable(key);
        }
        if (description == null) {
            description = group + " installation";
        }
        try {
            description = URLDecoder.decode(description, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            this.emitWarning("Failed to convert description", e.getMessage());
        }
        return description;
    }

    protected String getGroupSortKey(String group) {
        String key = "InstallationGroupPanel.sortKey." + group;
        String sortKey = this.installData.getVariable(key);
        if (sortKey == null) {
            sortKey = group;
        }
        try {
            sortKey = URLDecoder.decode(sortKey, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            this.emitWarning("Failed to convert sortKey", e.getMessage());
        }
        return sortKey;
    }

    protected String getLocalizedGroupName(String group) {
        String html;
        String gname = null;
        String key = "InstallationGroupPanel.group." + group;
        String htmlKey = key + ".html";
        gname = htmlKey.equalsIgnoreCase(html = this.getString(htmlKey)) ? this.getString(key) : html;
        if (gname == null || key.equalsIgnoreCase(gname)) {
            gname = this.installData.getVariable(key);
        }
        if (gname == null) {
            gname = group;
        }
        try {
            gname = URLDecoder.decode(gname, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            this.emitWarning("Failed to convert localized group name", e.getMessage());
        }
        return gname;
    }

    protected TableModel getModel(Map<String, GroupData> groupData) {
        String c1 = this.getString("InstallationGroupPanel.colNameSelected");
        String c3 = this.getString("InstallationGroupPanel.colNameSize");
        Object[] columns = new String[]{c1, c3};
        DefaultTableModel model = new DefaultTableModel(columns, 0){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.rows = new GroupData[groupData.size()];
        String defaultGroup = this.installData.getVariable("InstallationGroupPanel.defaultGroup");
        logger.fine("InstallationGroupPanel.defaultGroup=" + defaultGroup + ", selectedGroup=" + this.selectedGroup);
        ArrayList<GroupData> values = new ArrayList<GroupData>(groupData.values());
        Collections.sort(values, new Comparator<GroupData>(){

            @Override
            public int compare(GroupData g1, GroupData g2) {
                if (g1.sortKey == null || g2.sortKey == null) {
                    return 0;
                }
                return g1.sortKey.compareTo(g2.sortKey);
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        boolean madeSelection = false;
        int count = 0;
        Iterator iterator = values.iterator();
        while (iterator.hasNext()) {
            GroupData gd;
            this.rows[count] = gd = (GroupData)iterator.next();
            logger.fine("Creating button #" + count + ", group=" + gd.name);
            JRadioButton button = new JRadioButton(this.getLocalizedGroupName(gd.name));
            if (this.selectedGroup == count) {
                button.setSelected(true);
                logger.fine("Selected button #" + count);
            } else if (this.selectedGroup < 0 && !madeSelection) {
                if (defaultGroup != null) {
                    if (defaultGroup.equals(gd.name)) {
                        madeSelection = true;
                    }
                } else if (count == 0) {
                    madeSelection = true;
                }
                if (madeSelection) {
                    button.setSelected(true);
                    logger.fine("Selected button #" + count);
                    this.selectedGroup = count;
                }
            } else {
                button.setSelected(false);
            }
            buttonGroup.add(button);
            String sizeText = gd.getSizeString();
            Object[] data = new Object[]{button, sizeText};
            model.addRow(data);
            ++count;
        }
        return model;
    }
}

