/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.installationtype;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.config.Options;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.resource.Messages;
import com.izforge.izpack.installer.console.AbstractConsolePanel;
import com.izforge.izpack.installer.console.ConsolePanel;
import com.izforge.izpack.installer.panel.PanelView;
import com.izforge.izpack.panels.installationtype.InstallationTypePanelAutomation;
import com.izforge.izpack.util.Console;
import java.util.Collections;
import java.util.Properties;

public class InstallationTypeConsolePanel
extends AbstractConsolePanel {
    private final InstallData installData;

    public InstallationTypeConsolePanel(PanelView<ConsolePanel> panel, InstallData installData) {
        super(panel);
        this.installData = installData;
    }

    public boolean run(InstallData installData, Properties properties) {
        String modifyInstall = properties.getProperty("modify.izpack.install");
        if (modifyInstall != null) {
            installData.setVariable("modify.izpack.install", modifyInstall);
        }
        return true;
    }

    public boolean run(InstallData installData, Console console) {
        Messages messages = installData.getMessages();
        this.printHeadLine(installData, console);
        boolean modifyInstallation = Boolean.parseBoolean(installData.getVariable("modify.izpack.install"));
        console.println("0 [" + (modifyInstallation ? " " : "x") + "] " + messages.get("InstallationTypePanel.normal", new Object[0]));
        console.println("1 [" + (modifyInstallation ? "x" : " ") + "] " + messages.get("InstallationTypePanel.modify", new Object[0]));
        int defaultSelection = modifyInstallation ? 1 : 0;
        int selectedInstallation = console.prompt(installData.getMessages().get("ConsoleInstaller.inputSelection", new Object[0]), 0, 1, defaultSelection, defaultSelection);
        installData.setVariable("modify.izpack.install", selectedInstallation == 1 ? "true" : "false");
        return true;
    }

    public boolean generateOptions(InstallData installData, Options options) {
        String name = "modify.izpack.install";
        options.add((Object)"modify.izpack.install", (Object)installData.getVariable("modify.izpack.install"));
        options.addEmptyLine((Object)"modify.izpack.install");
        options.putComment((Object)"modify.izpack.install", Collections.singletonList(this.getPanel().getPanelId()));
        return true;
    }

    public void createInstallationRecord(IXMLElement rootElement) {
        new InstallationTypePanelAutomation().createInstallationRecord(this.installData, rootElement);
    }
}

