/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.installationtype;

import com.izforge.izpack.api.GuiId;
import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.gui.IzPanelLayout;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.gui.log.Log;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.gui.InstallerFrame;
import com.izforge.izpack.installer.gui.IzPanel;
import com.izforge.izpack.panels.installationtype.InstallationTypePanelAutomation;
import java.awt.LayoutManager2;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JRadioButton;

public class InstallationTypePanel
extends IzPanel
implements ActionListener {
    private static final long serialVersionUID = -8178770882900584122L;
    private static final Logger logger = Logger.getLogger(InstallationTypePanel.class.getName());
    private JRadioButton normalInstall;
    private JRadioButton modifyInstall;

    public InstallationTypePanel(Panel panel, InstallerFrame parent, GUIInstallData installData, Resources resources, Log log) {
        super(panel, parent, installData, (LayoutManager2)new IzPanelLayout(log), resources);
        this.buildGUI();
    }

    private void buildGUI() {
        this.add(LabelFactory.create((String)this.getString("InstallationTypePanel.info"), (Icon)((Icon)this.parent.getIcons().get((Object)"history")), (int)10), "nextLine");
        ButtonGroup group = new ButtonGroup();
        boolean modifyInstallation = Boolean.parseBoolean(this.installData.getVariable("modify.izpack.install"));
        this.normalInstall = new JRadioButton(this.getString("InstallationTypePanel.normal"), !modifyInstallation);
        this.normalInstall.setName(GuiId.INSTALLATION_TYPE_NORMAL.id);
        this.normalInstall.addActionListener(this);
        group.add(this.normalInstall);
        this.add(this.normalInstall, "nextLine");
        this.modifyInstall = new JRadioButton(this.getString("InstallationTypePanel.modify"), modifyInstallation);
        this.modifyInstall.setName(GuiId.INSTALLATION_TYPE_MODIFY.id);
        this.modifyInstall.addActionListener(this);
        group.add(this.modifyInstall);
        this.add(this.modifyInstall, "nextLine");
        this.setInitialFocus(this.normalInstall);
        this.getLayoutHelper().completeLayout();
    }

    public void panelActivate() {
        boolean modifyInstallation = Boolean.parseBoolean(this.installData.getVariable("modify.izpack.install"));
        if (modifyInstallation) {
            this.modifyInstall.setSelected(true);
        } else {
            this.normalInstall.setSelected(true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.normalInstall) {
            logger.fine("Installation type: Normal installation");
            this.installData.setVariable("modify.izpack.install", "false");
        } else {
            logger.fine("Installation type: Modification installation");
            this.installData.setVariable("modify.izpack.install", "true");
        }
    }

    public void createInstallationRecord(IXMLElement rootElement) {
        new InstallationTypePanelAutomation().createInstallationRecord((InstallData)this.installData, rootElement);
    }

    public String getSummaryBody() {
        boolean modifyInstallation = Boolean.parseBoolean(this.installData.getVariable("modify.izpack.install"));
        return modifyInstallation ? this.getString("InstallationTypePanel.modify") : this.getString("InstallationTypePanel.normal");
    }
}

