/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.jdkpath;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.config.Options;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.resource.Messages;
import com.izforge.izpack.api.substitutor.VariableSubstitutor;
import com.izforge.izpack.core.os.RegistryDefaultHandler;
import com.izforge.izpack.installer.console.AbstractConsolePanel;
import com.izforge.izpack.installer.console.ConsolePanel;
import com.izforge.izpack.installer.panel.PanelView;
import com.izforge.izpack.panels.jdkpath.JDKPathPanelAutomationHelper;
import com.izforge.izpack.panels.jdkpath.JDKPathPanelHelper;
import com.izforge.izpack.panels.path.PathInputBase;
import com.izforge.izpack.util.Console;
import java.util.Arrays;
import java.util.Properties;

public class JDKPathConsolePanel
extends AbstractConsolePanel {
    private InstallData installData;
    private final VariableSubstitutor variableSubstitutor;
    private final RegistryDefaultHandler handler;

    public JDKPathConsolePanel(VariableSubstitutor variableSubstitutor, RegistryDefaultHandler handler, PanelView<ConsolePanel> panel, InstallData installData) {
        super(panel);
        this.handler = handler;
        this.installData = installData;
        this.variableSubstitutor = variableSubstitutor;
        JDKPathPanelHelper.initialize(installData);
    }

    public boolean run(InstallData installData, Properties properties) {
        String strJDKPath = properties.getProperty("jdkPath");
        if (strJDKPath == null || "".equals(strJDKPath.trim())) {
            System.err.println("Missing mandatory JDK path!");
            return false;
        }
        try {
            strJDKPath = this.variableSubstitutor.substitute(strJDKPath);
        }
        catch (Exception exception) {
            // empty catch block
        }
        installData.setVariable("jdkPath", strJDKPath);
        return true;
    }

    public boolean run(InstallData installData, Console console) {
        this.printHeadLine(installData, console);
        String introText = this.getI18nStringForClass("intro", "JDKPathPanel", installData);
        if (introText != null) {
            console.println(introText);
            console.println();
        }
        String detectedJavaVersion = "";
        String defaultValue = JDKPathPanelHelper.getDefaultJavaPath(installData, this.handler);
        if (JDKPathPanelHelper.skipPanel(installData, defaultValue)) {
            return true;
        }
        boolean bKeepAsking = true;
        while (bKeepAsking) {
            Messages messages = installData.getMessages();
            String strPath = console.promptLocation(messages.get("JDKPathPanel.info", new Object[0]) + " [" + defaultValue + "] ", defaultValue);
            if (strPath == null) {
                return false;
            }
            strPath = strPath.trim();
            String errorMessage = JDKPathPanelHelper.validate(strPath = PathInputBase.normalizePath(strPath), detectedJavaVersion = JDKPathPanelHelper.getCurrentJavaVersion(strPath, installData.getPlatform()), messages);
            if (!errorMessage.isEmpty()) {
                if (errorMessage.endsWith("?")) {
                    String strIn = console.prompt(errorMessage = errorMessage + "\n" + messages.get("JDKPathPanel.badVersion4", new Object[0]), (String)null);
                    if (strIn == null) {
                        return false;
                    }
                    if (strIn != null && (strIn.equalsIgnoreCase("y") || strIn.equalsIgnoreCase("yes"))) {
                        bKeepAsking = false;
                    }
                } else {
                    console.println(messages.get("JDKPathPanel.notValid", new Object[0]));
                }
            } else {
                bKeepAsking = false;
            }
            installData.setVariable("jdkPath", strPath);
        }
        return this.promptEndPanel(installData, console);
    }

    public boolean generateOptions(InstallData installData, Options options) {
        String name = "jdkPath";
        options.add((Object)"jdkPath", (Object)installData.getVariable("jdkPath"));
        options.addEmptyLine((Object)"jdkPath");
        options.putComment((Object)"jdkPath", Arrays.asList(this.getPanel().getPanelId()));
        return true;
    }

    public void createInstallationRecord(IXMLElement panelRoot) {
        new JDKPathPanelAutomationHelper().createInstallationRecord(this.installData, panelRoot);
    }
}

