/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.jdkpath;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.api.substitutor.VariableSubstitutor;
import com.izforge.izpack.core.os.RegistryDefaultHandler;
import com.izforge.izpack.gui.IzPanelLayout;
import com.izforge.izpack.gui.log.Log;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.gui.InstallerFrame;
import com.izforge.izpack.panels.jdkpath.JDKPathPanelAutomationHelper;
import com.izforge.izpack.panels.jdkpath.JDKPathPanelHelper;
import com.izforge.izpack.panels.path.PathInputPanel;
import com.izforge.izpack.util.Platform;
import java.awt.Desktop;
import java.io.File;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class JDKPathPanel
extends PathInputPanel
implements HyperlinkListener {
    private static final long serialVersionUID = 3257006553327810104L;
    private static final Logger logger = Logger.getLogger(JDKPathPanel.class.getName());
    public static final String PANEL_NAME = "JDKPathPanel";
    private final RegistryDefaultHandler handler;

    public JDKPathPanel(Panel panel, InstallerFrame parent, GUIInstallData installData, Resources resources, RegistryDefaultHandler handler, VariableSubstitutor replacer, Log log) {
        super(panel, PANEL_NAME, parent, installData, resources, log);
        this.handler = handler;
        String msg = this.getString("JDKPathPanel.jdkDownload");
        if (msg != null && !msg.isEmpty()) {
            this.add(IzPanelLayout.createParagraphGap());
            JEditorPane textArea = new JEditorPane("text/html; charset=utf-8", replacer.substitute(msg, null));
            textArea.setCaretPosition(0);
            textArea.setEditable(false);
            textArea.addHyperlinkListener(this);
            textArea.setBackground(this.getBackground());
            JScrollPane scroller = new JScrollPane(textArea);
            scroller.setAlignmentX(0.0f);
            this.add(scroller, "nextLine");
        }
        JDKPathPanelHelper.initialize((InstallData)installData);
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        try {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                String urls = e.getURL().toExternalForm();
                if (Desktop.isDesktopSupported()) {
                    Desktop desktop = Desktop.getDesktop();
                    desktop.browse(new URI(urls));
                }
            }
        }
        catch (Exception err) {
            logger.log(Level.WARNING, err.getMessage());
        }
    }

    @Override
    public boolean isValidated() {
        if (super.isValidated()) {
            String detectedJavaVersion;
            String strPath = this.pathSelectionPanel.getPath();
            String errorMessage = JDKPathPanelHelper.validate(strPath, detectedJavaVersion = JDKPathPanelHelper.getCurrentJavaVersion(strPath, this.installData.getPlatform()), this.installData.getMessages());
            if (!errorMessage.isEmpty()) {
                if (errorMessage.endsWith("?") && this.askQuestion(this.warn, errorMessage, 37, 49) == 47) {
                    this.installData.setVariable("jdkPath", this.pathSelectionPanel.getPath());
                    return true;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void panelActivate() {
        super.panelActivate();
        this.setMustExist(true);
        if (!this.installData.getPlatform().isA(Platform.Name.MAC_OSX)) {
            this.setExistFiles(JDKPathPanelHelper.testFiles);
        }
        String defaultValue = JDKPathPanelHelper.getDefaultJavaPath((InstallData)this.installData, this.handler);
        this.pathSelectionPanel.setPath(defaultValue);
        if (JDKPathPanelHelper.skipPanel((InstallData)this.installData, defaultValue)) {
            this.parent.skipPanel();
        }
    }

    public String getSummaryBody() {
        return this.installData.getVariable("jdkPath");
    }

    public void createInstallationRecord(IXMLElement panelRoot) {
        new JDKPathPanelAutomationHelper().createInstallationRecord((InstallData)this.installData, panelRoot);
    }

    public void saveData() {
        this.installData.setVariable("jdkPath", this.pathSelectionPanel.getPath());
    }

    @Override
    protected boolean checkInstallationInformation(File path) {
        return true;
    }
}

