/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.jdkpath;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.exception.NativeLibException;
import com.izforge.izpack.api.resource.Messages;
import com.izforge.izpack.core.os.RegistryDefaultHandler;
import com.izforge.izpack.core.os.RegistryHandler;
import com.izforge.izpack.panels.path.PathInputBase;
import com.izforge.izpack.util.FileExecutor;
import com.izforge.izpack.util.OsVersion;
import com.izforge.izpack.util.Platform;
import java.io.File;
import java.util.Arrays;
import java.util.StringTokenizer;

public class JDKPathPanelHelper {
    public static final String[] testFiles = new String[]{"lib" + File.separator + "tools.jar", "bin" + File.separator + "javac" + (OsVersion.IS_WINDOWS ? ".exe" : "")};
    public static final String JDK_VALUE_NAME = "JavaHome";
    public static final String JDK_ROOT_KEY = "Software\\JavaSoft\\Java Development Kit";
    public static final String OSX_JDK_HOME = "/System/Library/Frameworks/JavaVM.framework/Versions/CurrentJDK/Home/";
    public static final String JDK_PATH = "jdkPath";
    public static final String JDK_VAR_NAME = "jdkVarName";
    private static String minVersion = null;
    private static String maxVersion = null;

    public static void initialize(InstallData installData) {
        minVersion = installData.getVariable("JDKPathPanel.minVersion");
        maxVersion = installData.getVariable("JDKPathPanel.maxVersion");
        installData.setVariable(JDK_VAR_NAME, JDK_PATH);
    }

    public static String getDefaultJavaPath(InstallData installData, RegistryDefaultHandler handler) {
        String detectedJavaVersion = "";
        String defaultValue = installData.getVariable(JDK_PATH);
        if (defaultValue != null) {
            return defaultValue;
        }
        defaultValue = OsVersion.IS_OSX ? OSX_JDK_HOME : new File(installData.getVariable("JAVA_HOME")).getParent();
        Platform platform = installData.getPlatform();
        detectedJavaVersion = JDKPathPanelHelper.getCurrentJavaVersion(defaultValue, platform);
        if (!JDKPathPanelHelper.pathIsValid(defaultValue) || !JDKPathPanelHelper.verifyVersion(detectedJavaVersion)) {
            defaultValue = JDKPathPanelHelper.getJavaHomeFromRegistry(handler);
            detectedJavaVersion = JDKPathPanelHelper.getCurrentJavaVersion(defaultValue, platform);
            if (!JDKPathPanelHelper.pathIsValid(defaultValue) || !JDKPathPanelHelper.verifyVersion(detectedJavaVersion)) {
                defaultValue = "";
            }
        }
        return PathInputBase.normalizePath(defaultValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getJavaHomeFromRegistry(RegistryDefaultHandler handler) {
        String javaHome = "";
        int oldVal = 0;
        RegistryHandler registryHandler = null;
        try {
            registryHandler = handler.getInstance();
            if (registryHandler == null) {
                String string = javaHome;
                return string;
            }
            oldVal = registryHandler.getRoot();
            registryHandler.setRoot(-2147483646);
            Object[] keys = registryHandler.getSubkeys(JDK_ROOT_KEY);
            if (keys == null || keys.length == 0) {
                String e = javaHome;
                return e;
            }
            Arrays.sort(keys);
            for (int i = keys.length - 1; i > 0; --i) {
                String cv;
                String path;
                String javaVersion = JDKPathPanelHelper.extractJavaVersion((String)keys[i]);
                if (maxVersion != null && !JDKPathPanelHelper.compareVersions(javaVersion, maxVersion, false) || minVersion != null && !JDKPathPanelHelper.compareVersions(javaVersion, minVersion, true) || !JDKPathPanelHelper.pathIsValid(path = registryHandler.getValue(cv = "Software\\JavaSoft\\Java Development Kit\\" + (String)keys[i], JDK_VALUE_NAME).getStringData())) continue;
                javaHome = path;
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (registryHandler != null && oldVal != 0) {
                try {
                    registryHandler.setRoot(-2147483646);
                }
                catch (NativeLibException e) {
                    e.printStackTrace();
                }
            }
        }
        return javaHome;
    }

    private static boolean pathIsValid(String strPath) {
        for (String existFile : testFiles) {
            File path = new File(strPath, existFile).getAbsoluteFile();
            if (!path.exists()) continue;
            return true;
        }
        return false;
    }

    private static boolean verifyVersion(String javaVersion) {
        boolean valid = true;
        if (minVersion == null && maxVersion == null) {
            return true;
        }
        if (minVersion != null && !JDKPathPanelHelper.compareVersions(javaVersion, minVersion, true)) {
            valid = false;
        }
        if (maxVersion != null && !JDKPathPanelHelper.compareVersions(javaVersion, maxVersion, false)) {
            valid = false;
        }
        return valid;
    }

    public static String getCurrentJavaVersion(String path, Platform platform) {
        String[] params = platform.isA(Platform.Name.WINDOWS) ? new String[]{"cmd", "/c", path + File.separator + "bin" + File.separator + "java", "-version"} : new String[]{path + File.separator + "bin" + File.separator + "java", "-version"};
        String[] output = new String[2];
        FileExecutor fe = new FileExecutor();
        fe.executeCommand(params, output);
        String versionInformation = output[0].length() > 0 ? output[0] : output[1];
        return JDKPathPanelHelper.extractJavaVersion(versionInformation);
    }

    public static String extractJavaVersion(String javaVersion) {
        int i;
        int assumedPlace = 4;
        int halfRange = 4;
        String useNotIdentifier = "__NO_NOT_IDENTIFIER_";
        StringTokenizer tokenizer = new StringTokenizer(javaVersion, " \t\n\r\f\"");
        int currentRange = 0;
        String[] interestedEntries = new String[halfRange + halfRange];
        for (i = 0; i < assumedPlace - halfRange; ++i) {
            if (!tokenizer.hasMoreTokens()) continue;
            tokenizer.nextToken();
        }
        for (i = 0; i < halfRange + halfRange; ++i) {
            if (!tokenizer.hasMoreTokens()) continue;
            interestedEntries[i] = tokenizer.nextToken();
            ++currentRange;
        }
        for (i = 0; i < currentRange && (useNotIdentifier != null && interestedEntries[i].contains(useNotIdentifier) || Character.getType(interestedEntries[i].charAt(0)) != 9); ++i) {
        }
        if (i == currentRange) {
            return "<not found>";
        }
        return interestedEntries[i];
    }

    private static boolean compareVersions(String currentVersion, String template, boolean isMin) {
        StringTokenizer currentTokenizer = new StringTokenizer(currentVersion, "._-");
        StringTokenizer neededTokenizer = new StringTokenizer(template, "._-");
        while (neededTokenizer.hasMoreTokens()) {
            int neededValue;
            int currentValue;
            if (!currentTokenizer.hasMoreTokens()) {
                return false;
            }
            String current = currentTokenizer.nextToken();
            String needed = neededTokenizer.nextToken();
            try {
                currentValue = Integer.parseInt(current);
                neededValue = Integer.parseInt(needed);
            }
            catch (NumberFormatException nfe) {
                return false;
            }
            if (currentValue < neededValue) {
                return !isMin;
            }
            if (currentValue <= neededValue) continue;
            return isMin;
        }
        return true;
    }

    public static String validate(String javaHome, String javaVersion, Messages messages) {
        StringBuilder message = new StringBuilder();
        if (!JDKPathPanelHelper.pathIsValid(javaHome)) {
            message.append(messages.get("JDKPathPanel.notValid", new Object[0]));
        } else if (!JDKPathPanelHelper.verifyVersion(javaVersion)) {
            message.append(messages.get("JDKPathPanel.badVersion1", new Object[0])).append(javaVersion).append(messages.get("JDKPathPanel.badVersion2", new Object[0]));
            if (minVersion != null && maxVersion != null) {
                message.append(minVersion).append(" - ").append(maxVersion);
            } else if (minVersion != null) {
                message.append(" >= ").append(minVersion);
            } else if (maxVersion != null) {
                message.append(" <= ").append(maxVersion);
            }
            message.append(messages.get("JDKPathPanel.badVersion3", new Object[0]));
        }
        return message.toString();
    }

    public static boolean skipPanel(InstallData installData, String path) {
        String skipIfValid = installData.getVariable("JDKPathPanel.skipIfValid");
        if (JDKPathPanelHelper.pathIsValid(path) && skipIfValid != null && ("yes".equalsIgnoreCase(skipIfValid) || "true".equalsIgnoreCase(skipIfValid))) {
            installData.setVariable(JDK_PATH, path);
            return true;
        }
        return false;
    }
}

