/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.packs;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.adaptator.impl.XMLElementImpl;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.Overrides;
import com.izforge.izpack.api.data.Pack;
import com.izforge.izpack.api.rules.RulesEngine;
import com.izforge.izpack.installer.automation.PanelAutomation;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class PacksPanelAutomationHelper
implements PanelAutomation {
    private static final Logger logger = Logger.getLogger(PacksPanelAutomationHelper.class.getName());

    public void createInstallationRecord(InstallData installData, IXMLElement panelRoot) {
        for (int i = 0; i < installData.getAvailablePacks().size(); ++i) {
            Pack pack = (Pack)installData.getAvailablePacks().get(i);
            XMLElementImpl packElement = new XMLElementImpl("pack", panelRoot);
            packElement.setAttribute("index", Integer.toString(i));
            packElement.setAttribute("name", pack.getName());
            Boolean selected = installData.getSelectedPacks().contains(pack);
            packElement.setAttribute("selected", selected.toString());
            panelRoot.addChild((IXMLElement)packElement);
        }
    }

    public void runAutomated(InstallData idata, IXMLElement panelRoot) {
        final class PInfo {
            private boolean _selected;
            private int _index;
            private String _name = "";

            PInfo(boolean selected, String index, String name) {
                this._selected = selected;
                try {
                    this._index = Integer.valueOf(index);
                }
                catch (NumberFormatException e) {
                    this._index = -100;
                }
                if (name != null) {
                    this._name = name;
                }
            }

            public boolean isSelected() {
                return this._selected;
            }

            public boolean equals(int index) {
                return this._index == index && this._name.equals("");
            }

            public boolean equals(String name) {
                return this._name.equals(name);
            }

            public String toString() {
                String retVal = "";
                if (!this._name.equals("")) {
                    retVal = "Name: " + this._name + " and ";
                }
                retVal = retVal + "Index: " + String.valueOf(this._index);
                return retVal;
            }
        }
        ArrayList<PInfo> autoinstallPackInfoList = new ArrayList<PInfo>();
        List packList = panelRoot.getChildrenNamed("pack");
        logger.fine("Read pack list from xml definition.");
        for (Object pack : packList) {
            String index = pack.getAttribute("index");
            String name = pack.getAttribute("name");
            String selectedString = pack.getAttribute("selected");
            boolean selected = selectedString.equalsIgnoreCase("true") || selectedString.equalsIgnoreCase("on");
            PInfo packInfo = new PInfo(selected, index, name);
            autoinstallPackInfoList.add(packInfo);
            logger.fine("Try to " + (selected ? "add to" : "remove from") + " selection [" + packInfo.toString() + "]");
        }
        logger.fine("Modify pack selection");
        RulesEngine rules = idata.getRules();
        block1: for (Pack pack : idata.getAvailablePacks()) {
            int indexOfAvailablePack = idata.getAvailablePacks().indexOf(pack);
            for (PInfo packInfo : autoinstallPackInfoList) {
                if (!packInfo.equals(pack.getName()) && !packInfo.equals(indexOfAvailablePack)) continue;
                if (pack.isRequired()) {
                    if (!packInfo.isSelected() && rules.canInstallPack(pack.getName(), idata.getVariables())) {
                        logger.warning("Pack [" + packInfo.toString() + "] must be installed because it is required");
                        continue block1;
                    }
                    if (rules.canInstallPack(pack.getName(), idata.getVariables())) continue block1;
                    idata.getSelectedPacks().remove(pack);
                    logger.fine("Pack [" + packInfo.toString() + "] removed from selection.");
                    continue block1;
                }
                if (packInfo.isSelected()) {
                    if (idata.getSelectedPacks().indexOf(pack) >= 0 || !rules.canInstallPack(pack.getName(), idata.getVariables())) continue block1;
                    idata.getSelectedPacks().add(pack);
                    logger.fine("Pack [" + packInfo.toString() + "] added to selection.");
                    continue block1;
                }
                idata.getSelectedPacks().remove(pack);
                logger.fine("Pack [" + packInfo.toString() + "] removed from selection.");
                continue block1;
            }
        }
        for (int counter = panelRoot.getChildrenCount(); counter > 0; --counter) {
            panelRoot.removeChild(panelRoot.getChildAtIndex(0));
        }
        this.createInstallationRecord(idata, panelRoot);
    }

    public void processOptions(InstallData installData, Overrides overrides) {
    }
}

