/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.pdflicence;

import com.izforge.izpack.api.GuiId;
import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.gui.IzPanelLayout;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.gui.log.Log;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.gui.InstallerFrame;
import com.izforge.izpack.panels.licence.AbstractLicencePanel;
import java.awt.FlowLayout;
import java.awt.LayoutManager2;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.KeyStroke;
import org.icepdf.ri.common.ComponentKeyBinding;
import org.icepdf.ri.common.SwingController;
import org.icepdf.ri.common.SwingViewBuilder;
import org.icepdf.ri.util.PropertiesManager;

public class PDFLicencePanel
extends AbstractLicencePanel
implements ActionListener {
    private static final long serialVersionUID = 1907880984181722205L;
    private final JRadioButton yesRadio;
    private final JRadioButton noRadio;

    public PDFLicencePanel(Panel panel, final InstallerFrame parent, GUIInstallData installData, Resources resources, Log log) {
        super(panel, parent, installData, (LayoutManager2)new IzPanelLayout(log), resources);
        this.add(LabelFactory.create((String)this.getString(this.titleMessageKey), (Icon)((Icon)parent.getIcons().get((Object)"history")), (int)10), "nextLine");
        SwingController controller = new SwingController();
        SwingViewBuilder builder = new SwingViewBuilder(controller, this.createProperties());
        JPanel viewerComponentPanel = builder.buildViewerPanel();
        ComponentKeyBinding.install((SwingController)controller, (JComponent)viewerComponentPanel);
        ActionListener fireDefault = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JButton defaultButton = parent.getRootPane().getDefaultButton();
                if (defaultButton != null && defaultButton.isEnabled()) {
                    defaultButton.doClick();
                }
            }
        };
        viewerComponentPanel.registerKeyboardAction(fireDefault, null, KeyStroke.getKeyStroke(10, 0), 0);
        JPanel toolbar = new JPanel();
        toolbar.setLayout(new FlowLayout(1));
        toolbar.add(builder.buildFitToolBar());
        toolbar.add(builder.buildPageNavigationToolBar());
        toolbar.add(builder.buildZoomToolBar());
        this.add(toolbar, "nextLine");
        this.add(controller.getDocumentViewController().getViewContainer(), "nextLine");
        ButtonGroup group = new ButtonGroup();
        this.yesRadio = new JRadioButton(this.getString("LicencePanel.agree"), false);
        this.yesRadio.setName(GuiId.LICENCE_YES_RADIO.id);
        group.add(this.yesRadio);
        this.add(this.yesRadio, "nextLine");
        this.yesRadio.addActionListener(this);
        this.noRadio = new JRadioButton(this.getString("LicencePanel.notagree"), true);
        this.noRadio.setName(GuiId.LICENCE_NO_RADIO.id);
        group.add(this.noRadio);
        this.add(this.noRadio, "nextLine");
        this.noRadio.addActionListener(this);
        this.setInitialFocus(viewerComponentPanel);
        this.getLayoutHelper().completeLayout();
        controller.openDocument(this.loadLicence());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.yesRadio.isSelected()) {
            this.parent.unlockNextButton();
        } else {
            this.parent.lockNextButton();
        }
    }

    public boolean isValidated() {
        if (this.noRadio.isSelected()) {
            this.parent.exit();
            return false;
        }
        return this.yesRadio.isSelected();
    }

    public void panelActivate() {
        if (!this.yesRadio.isSelected()) {
            this.parent.lockNextButton();
        }
    }

    private PropertiesManager createProperties() {
        Properties result = new Properties();
        result.setProperty("document.pagefitMode", Integer.toString(4));
        result.setProperty("application.viewerpreferences.hidemenubar", "false");
        result.setProperty("application.viewerpreferences.hidetoolbar", "false");
        result.setProperty("application.viewerpreferences.form.highlight", "false");
        result.setProperty("application.viewerpreferences.fitwindow", "true");
        result.setProperty("application.menuitem.show.keyboard.shortcuts", "false");
        result.setProperty("application.alwaysShowImageSplashWindow", "no");
        result.setProperty("application.chromeOnStartup", "no");
        result.setProperty("application.showLocalStorageDialogs", "no");
        result.setProperty("application.toolbar.show.pagenav", "false");
        result.setProperty("application.toolbar.show.fit", "false");
        result.setProperty("application.toolbar.show.zoom", "false");
        result.setProperty("application.toolbar.show.rotate", "false");
        result.setProperty("application.toolbar.show.tool", "false");
        result.setProperty("application.toolbar.show.annotation", "false");
        result.setProperty("application.toolbar.show.forms", "false");
        result.setProperty("application.zoom.factor.default", "1.3");
        result.setProperty("application.toolbar.show.utility", "false");
        result.setProperty("application.toolbar.show.utility.save", "false");
        result.setProperty("application.toolbar.show.utility.open", "false");
        result.setProperty("application.toolbar.show.utility.search", "false");
        result.setProperty("application.toolbar.show.utility.upane", "false");
        result.setProperty("application.toolbar.show.utility.print", "false");
        result.setProperty("application.utilitypane.hide", "true");
        result.setProperty("application.utilitypane.show.bookmarks", "false");
        result.setProperty("application.utilitypane.show.search", "false");
        result.setProperty("application.utilitypane.show.annotation", "false");
        result.setProperty("application.utilitypane.show.thumbs", "false");
        result.setProperty("application.utilitypane.show.layers", "false");
        result.setProperty("application.utilitypane.show.annotation.flags", "false");
        result.setProperty("application.statusbar", "false");
        result.setProperty("application.statusbar.show.statuslabel", "false");
        result.setProperty("application.statusbar.show.viewmode", "false");
        return new PropertiesManager(System.getProperties(), result, ResourceBundle.getBundle("org.icepdf.ri.resources.MessageBundle"));
    }
}

