/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.selectprinter;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.config.Options;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.resource.Messages;
import com.izforge.izpack.installer.console.AbstractConsolePanel;
import com.izforge.izpack.installer.console.ConsolePanel;
import com.izforge.izpack.installer.panel.PanelView;
import com.izforge.izpack.panels.selectprinter.SelectPrinterPanelAutomation;
import com.izforge.izpack.util.Console;
import java.util.Collections;
import java.util.Properties;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;

public class SelectPrinterConsolePanel
extends AbstractConsolePanel {
    private final InstallData installData;

    public SelectPrinterConsolePanel(PanelView<ConsolePanel> panel, InstallData installData) {
        super(panel);
        this.installData = installData;
    }

    public boolean run(InstallData installData, Properties properties) {
        return true;
    }

    public boolean run(InstallData installData, Console console) {
        this.printHeadLine(installData, console);
        Messages messages = installData.getMessages();
        PrintService[] printServices = PrintServiceLookup.lookupPrintServices(null, null);
        if (printServices.length == 0) {
            console.println(messages.get("SelectPrinterPanel.no_printer", new Object[0]));
            return this.promptEndPanel(installData, console);
        }
        console.println(messages.get("SelectPrinterPanel.select_printer", new Object[0]));
        for (int i = 0; i < printServices.length; ++i) {
            console.println(i + "  [" + (i == 0 ? "x" : " ") + "] " + printServices[i].getName());
        }
        int selectedPrinter = console.prompt(installData.getMessages().get("ConsoleInstaller.inputSelection", new Object[0]), 0, printServices.length, 0, 0);
        installData.setVariable("SELECTED_PRINTER", printServices[selectedPrinter].getName());
        return true;
    }

    public boolean generateOptions(InstallData installData, Options options) {
        String name = "SELECTED_PRINTER";
        options.add((Object)"SELECTED_PRINTER", (Object)installData.getVariable("SELECTED_PRINTER"));
        options.addEmptyLine((Object)"SELECTED_PRINTER");
        options.putComment((Object)"SELECTED_PRINTER", Collections.singletonList(this.getPanel().getPanelId()));
        return true;
    }

    public void createInstallationRecord(IXMLElement rootElement) {
        new SelectPrinterPanelAutomation().createInstallationRecord(this.installData, rootElement);
    }
}

