/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.shortcut;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.adaptator.impl.XMLElementImpl;
import com.izforge.izpack.api.adaptator.impl.XMLParser;
import com.izforge.izpack.api.data.ExecutableFile;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.Pack;
import com.izforge.izpack.api.event.AbstractInstallerListener;
import com.izforge.izpack.api.event.InstallerListener;
import com.izforge.izpack.api.event.ProgressListener;
import com.izforge.izpack.api.exception.IzPackException;
import com.izforge.izpack.api.exception.ResourceNotFoundException;
import com.izforge.izpack.api.resource.Messages;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.api.substitutor.SubstitutionType;
import com.izforge.izpack.core.substitutor.VariableSubstitutorImpl;
import com.izforge.izpack.installer.data.UninstallData;
import com.izforge.izpack.installer.event.InstallerListeners;
import com.izforge.izpack.panels.shortcut.ShortcutData;
import com.izforge.izpack.util.CleanupClient;
import com.izforge.izpack.util.Housekeeper;
import com.izforge.izpack.util.OsConstraintHelper;
import com.izforge.izpack.util.OsVersion;
import com.izforge.izpack.util.Platform;
import com.izforge.izpack.util.PlatformModelMatcher;
import com.izforge.izpack.util.StringTool;
import com.izforge.izpack.util.TargetFactory;
import com.izforge.izpack.util.os.Shortcut;
import com.izforge.izpack.util.os.Unix_Shortcut;
import com.izforge.izpack.util.unix.UnixHelper;
import com.izforge.izpack.util.xml.XMLHelper;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class ShortcutPanelLogic
implements CleanupClient {
    private static final Logger logger = Logger.getLogger(ShortcutPanelLogic.class.getName());
    private String suggestedProgramGroup;
    private String groupName;
    private String programGroupIconFile;
    private String programGroupComment;
    private boolean skipIfNotSupported = false;
    private boolean previousDisabled = false;
    private Shortcut shortcut;
    private List<ShortcutData> shortcuts;
    private List<ShortcutData> desktopShortcuts;
    private List<ShortcutData> startupShortcuts;
    private List<String> files;
    private List<ExecutableFile> execFiles;
    private boolean createShortcuts = false;
    private boolean createMenuShortcuts = false;
    private boolean createDesktopShortcuts = false;
    private boolean createStartupShortcuts = false;
    private boolean simulateNotSupported = false;
    private int userType;
    private final InstallData installData;
    private final Resources resources;
    private final UninstallData uninstallData;
    private final PlatformModelMatcher matcher;
    private boolean defaultCurrentUserFlag = false;
    private boolean createShortcutsImmediately = true;
    private boolean allowProgramGroup;
    private Vector<String> defaultGroup;
    private Platform platform;

    public ShortcutPanelLogic(InstallData installData, Resources resources, UninstallData uninstallData, Housekeeper housekeeper, TargetFactory factory, InstallerListeners listeners, PlatformModelMatcher matcher) throws Exception {
        this.matcher = matcher;
        this.resources = resources;
        this.installData = installData;
        this.uninstallData = uninstallData;
        this.shortcut = (Shortcut)factory.makeObject(Shortcut.class);
        this.shortcut.initialize(1, "-");
        if (!this.isCreateShortcutsImmediately()) {
            listeners.add((InstallerListener)new LateShortcutInstallListener());
        }
        this.defaultGroup = new Vector();
        this.defaultGroup.add("(Default)");
        housekeeper.registerForCleanup((CleanupClient)this);
    }

    public void refreshShortcutData() throws Exception {
        IXMLElement spec = this.readShortcutSpec();
        this.loadClassData(spec);
        this.createShortcutData(spec);
    }

    public void createAndRegisterShortcuts() {
        if (this.createMenuShortcuts) {
            this.createShortcuts(this.shortcuts);
        }
        if (this.createDesktopShortcuts) {
            this.createShortcuts(this.desktopShortcuts);
        }
        if (this.createStartupShortcuts) {
            this.createShortcuts(this.startupShortcuts);
        }
        this.addToUninstaller();
    }

    public List<String> getProgramGroups(int user) {
        return this.shortcut.getProgramGroups(user);
    }

    public Vector<String> getDefaultGroup() {
        return this.defaultGroup;
    }

    public File getProgramsFolder(int user) {
        String path = this.shortcut.getProgramsFolder(user);
        return new File(path);
    }

    public String getSuggestedProgramGroup() {
        return this.installData.getVariables().replace(this.suggestedProgramGroup);
    }

    public void setSuggestedProgramGroup(String suggestedProgramGroup) {
        this.suggestedProgramGroup = suggestedProgramGroup;
    }

    public List<String> getTargets() {
        ArrayList<String> retVal = new ArrayList<String>();
        for (ShortcutData data : this.shortcuts) {
            retVal.add(data.target);
        }
        return retVal;
    }

    public int getUserType() {
        return this.userType;
    }

    public List<IXMLElement> getAutoinstallXMLData(IXMLElement panelRoot) {
        ArrayList<IXMLElement> xmlData = new ArrayList<IXMLElement>();
        XMLElementImpl dataElement = new XMLElementImpl("createMenuShortcuts", panelRoot);
        dataElement.setContent(Boolean.toString(this.createMenuShortcuts));
        xmlData.add((IXMLElement)dataElement);
        dataElement = new XMLElementImpl("programGroup", panelRoot);
        dataElement.setContent(this.getGroupName());
        xmlData.add((IXMLElement)dataElement);
        dataElement = new XMLElementImpl("createDesktopShortcuts", panelRoot);
        dataElement.setContent(Boolean.toString(this.createDesktopShortcuts));
        xmlData.add((IXMLElement)dataElement);
        dataElement = new XMLElementImpl("createStartupShortcuts", panelRoot);
        dataElement.setContent(Boolean.toString(this.createStartupShortcuts));
        xmlData.add((IXMLElement)dataElement);
        dataElement = new XMLElementImpl("shortcutType", panelRoot);
        String userTypeString = "user";
        if (this.getUserType() == 2) {
            userTypeString = "all";
        }
        dataElement.setContent(userTypeString);
        xmlData.add((IXMLElement)dataElement);
        return xmlData;
    }

    public void setAutoinstallXMLData(IXMLElement panelRoot) {
        IXMLElement dataElement = panelRoot.getFirstChildNamed("createShortcuts");
        if (dataElement != null) {
            this.setCreateMenuShortcuts(Boolean.valueOf(dataElement.getContent()));
            if (this.isCreateMenuShortcuts()) {
                this.setCreateStartupShortcuts(true);
                dataElement = panelRoot.getFirstChildNamed("programGroup");
                this.setGroupName(dataElement.getContent());
                dataElement = panelRoot.getFirstChildNamed("createDesktopShortcuts");
                this.setCreateDesktopShortcuts(Boolean.valueOf(dataElement.getContent()));
                dataElement = panelRoot.getFirstChildNamed("shortcutType");
                if ("user".equals(dataElement.getContent())) {
                    this.setUserType(1);
                } else {
                    this.setUserType(2);
                }
            }
        } else {
            dataElement = panelRoot.getFirstChildNamed("createMenuShortcuts");
            this.setCreateMenuShortcuts(Boolean.valueOf(dataElement.getContent()));
            dataElement = panelRoot.getFirstChildNamed("createDesktopShortcuts");
            this.setCreateDesktopShortcuts(Boolean.valueOf(dataElement.getContent()));
            dataElement = panelRoot.getFirstChildNamed("createStartupShortcuts");
            this.setCreateStartupShortcuts(Boolean.valueOf(dataElement.getContent()));
            dataElement = panelRoot.getFirstChildNamed("programGroup");
            this.setGroupName(dataElement.getContent());
            dataElement = panelRoot.getFirstChildNamed("shortcutType");
            this.setUserType(2);
            if ("user".equals(dataElement.getContent())) {
                this.setUserType(1);
            }
        }
    }

    public final boolean isDefaultCurrentUserFlag() {
        return this.defaultCurrentUserFlag;
    }

    public boolean hasDesktopShortcuts() {
        return this.desktopShortcuts.size() > 0;
    }

    public boolean hasStartupShortcuts() {
        return this.startupShortcuts.size() > 0;
    }

    public void setCreateDesktopShortcuts(boolean createDesktopShortcuts) {
        this.createDesktopShortcuts = createDesktopShortcuts;
    }

    public void setCreateStartupShortcuts(boolean createStartupShortcuts) {
        this.createStartupShortcuts = createStartupShortcuts;
    }

    private boolean isCreateMenuShortcuts() {
        return this.createMenuShortcuts;
    }

    public final void setCreateMenuShortcuts(boolean createMenuShortcuts) {
        this.createMenuShortcuts = createMenuShortcuts;
    }

    public boolean skipIfNotSupported() {
        return this.skipIfNotSupported;
    }

    public boolean isPreviousDisabled() {
        return this.previousDisabled;
    }

    public boolean isSupported() {
        return !this.simulateNotSupported && this.shortcut.supported();
    }

    public boolean isSupportingMultipleUsers() {
        return this.shortcut.multipleUsers();
    }

    public void cleanUp() {
        if (!this.installData.isInstallSuccess()) {
            for (String file : this.files) {
                File fl = new File(file);
                if (!fl.exists()) continue;
                fl.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToFile(File file) {
        int nextIndex;
        FileWriter output;
        StringBuilder buffer = new StringBuilder();
        Messages messages = this.installData.getMessages();
        String header = messages.get("ShortcutPanel.textFile.header", new Object[0]);
        String newline = System.getProperty("line.separator", "\n");
        try {
            output = new FileWriter(file);
        }
        catch (Throwable exception) {
            return;
        }
        int currentIndex = 0;
        do {
            if ((nextIndex = header.indexOf("\\n", currentIndex)) > -1) {
                buffer.append(header.substring(currentIndex, nextIndex));
                buffer.append(newline);
                currentIndex = nextIndex + 2;
                continue;
            }
            buffer.append(header.substring(currentIndex, header.length()));
            buffer.append(newline);
        } while (nextIndex > -1);
        buffer.append("--------------------------------------------------------------------------------");
        buffer.append(newline);
        buffer.append(newline);
        for (ShortcutData data : this.shortcuts) {
            buffer.append(messages.get("ShortcutPanel.textFile.name", new Object[0]));
            buffer.append(data.name);
            buffer.append(newline);
            buffer.append(messages.get("ShortcutPanel.textFile.location", new Object[0]));
            switch (data.type) {
                case 3: {
                    buffer.append(messages.get("ShortcutPanel.location.desktop", new Object[0]));
                    break;
                }
                case 1: {
                    buffer.append(messages.get("ShortcutPanel.location.applications", new Object[0]));
                    break;
                }
                case 2: {
                    buffer.append(messages.get("ShortcutPanel.location.startMenu", new Object[0]));
                    break;
                }
                case 4: {
                    buffer.append(messages.get("ShortcutPanel.location.startup", new Object[0]));
                }
            }
            buffer.append(newline);
            buffer.append(messages.get("ShortcutPanel.textFile.description", new Object[0]));
            buffer.append(data.description);
            buffer.append(newline);
            buffer.append(messages.get("ShortcutPanel.textFile.target", new Object[0]));
            buffer.append(data.target);
            buffer.append(newline);
            buffer.append(messages.get("ShortcutPanel.textFile.command", new Object[0]));
            buffer.append(data.commandLine);
            buffer.append(newline);
            buffer.append(messages.get("ShortcutPanel.textFile.iconName", new Object[0]));
            buffer.append(data.iconFile);
            buffer.append(newline);
            buffer.append(messages.get("ShortcutPanel.textFile.iconIndex", new Object[0]));
            buffer.append(data.iconIndex);
            buffer.append(newline);
            buffer.append(messages.get("ShortcutPanel.textFile.work", new Object[0]));
            buffer.append(data.workingDirectory);
            buffer.append(newline);
            buffer.append(newline);
            buffer.append("--------------------------------------------------------------------------------");
            buffer.append(newline);
            buffer.append(newline);
        }
        try {
            output.write(buffer.toString());
        }
        catch (Throwable throwable) {
        }
        finally {
            try {
                output.flush();
                output.close();
                this.files.add(file.getPath());
            }
            catch (Throwable throwable) {}
        }
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    private String getGroupName() {
        if (this.groupName == null) {
            return this.suggestedProgramGroup;
        }
        return this.groupName;
    }

    public void setUserType(int userType) {
        this.userType = userType;
        this.shortcut.setUserType(this.userType);
    }

    public boolean initUserType() {
        File dir = this.getProgramsFolder(2);
        logger.fine("All Users Program Folder: '" + dir + "'");
        boolean writable = this.isWritable(dir);
        logger.fine((writable ? "Can" : "Cannot") + " write into '" + dir + "'");
        boolean allUsers = !this.isDefaultCurrentUserFlag() && writable;
        int type = allUsers ? 2 : 1;
        this.setUserType(type);
        return writable;
    }

    public boolean isDesktopShortcutCheckboxSelected() {
        return Boolean.valueOf(this.installData.getVariable("DesktopShortcutCheckboxEnabled"));
    }

    public boolean isStartupShortcutCheckboxSelected() {
        return Boolean.valueOf(this.installData.getVariable("StartupShortcutCheckboxEnabled"));
    }

    public String getCreateShortcutsPrompt() {
        Messages messages = this.installData.getMessages();
        String menuKind = messages.get("ShortcutPanel.regular.StartMenu:Start-Menu", new Object[0]);
        if (this.installData.getPlatform().isA(Platform.Name.UNIX) && UnixHelper.kdeIsInstalled()) {
            menuKind = messages.get("ShortcutPanel.regular.StartMenu:K-Menu", new Object[0]);
        }
        return StringTool.replace((String)messages.get("ShortcutPanel.regular.create", new Object[0]), (String)"StartMenu", (String)menuKind);
    }

    public String getCreateDesktopShortcutsPrompt() {
        return this.installData.getMessages().get("ShortcutPanel.regular.desktop", new Object[0]);
    }

    public String getCreateStartupShortcutsPrompt() {
        return this.installData.getMessages().get("ShortcutPanel.regular.startup", new Object[0]);
    }

    public String getCreateForUserPrompt() {
        return this.installData.getMessages().get("ShortcutPanel.regular.userIntro", new Object[0]);
    }

    public String getCreateForAllUsersPrompt() {
        return this.installData.getMessages().get("ShortcutPanel.regular.allUsers", new Object[0]);
    }

    public String getCreateForCurrentUserPrompt() {
        return this.installData.getMessages().get("ShortcutPanel.regular.currentUser", new Object[0]);
    }

    private boolean isWritable(File dir) {
        boolean result = true;
        try {
            File test = File.createTempFile("shortcut", "", dir);
            FileUtils.deleteQuietly((File)test);
        }
        catch (IOException exception) {
            result = false;
        }
        return result;
    }

    private void addToUninstaller() {
        for (String file : this.files) {
            this.uninstallData.addFile(file, true);
        }
    }

    private void loadClassData(IXMLElement spec) {
        String location;
        if (spec == null) {
            this.createShortcuts = false;
            return;
        }
        this.simulateNotSupported = spec.getFirstChildNamed("notSupported") != null;
        this.defaultCurrentUserFlag = spec.getFirstChildNamed("defaultCurrentUser") != null;
        this.skipIfNotSupported = spec.getFirstChildNamed("skipIfNotSupported") != null;
        this.previousDisabled = spec.getFirstChildNamed("previousDisabled") != null;
        this.setCreateShortcutsImmediately(spec.getFirstChildNamed("lateShortcutInstall") == null);
        IXMLElement group = null;
        List groupSpecs = spec.getChildrenNamed("programGroup");
        String selectedInstallGroup = this.installData.getVariable("INSTALL_GROUP");
        if (selectedInstallGroup != null) {
            for (IXMLElement g : groupSpecs) {
                String instGrp = g.getAttribute("installGroup");
                if (instGrp == null || !selectedInstallGroup.equalsIgnoreCase(instGrp)) continue;
                group = g;
                break;
            }
        }
        if (group == null) {
            group = spec.getFirstChildNamed("programGroup");
        }
        if (group != null) {
            this.programGroupComment = group.getAttribute("comment", "");
            this.programGroupIconFile = group.getAttribute("iconFile", "");
            this.suggestedProgramGroup = group.getAttribute("defaultName", "");
            location = group.getAttribute("location", "applications");
        } else {
            this.suggestedProgramGroup = "";
            location = "applications";
        }
        try {
            if (location.equals("applications")) {
                this.shortcut.setLinkType(1);
            } else if (location.equals("startMenu")) {
                this.shortcut.setLinkType(2);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    private void createShortcutData(IXMLElement spec) {
        if (spec == null) {
            return;
        }
        List shortcutSpecs = spec.getChildrenNamed("shortcut");
        this.files = new ArrayList<String>();
        this.execFiles = new ArrayList<ExecutableFile>();
        this.shortcuts = new ArrayList<ShortcutData>();
        this.desktopShortcuts = new ArrayList<ShortcutData>();
        this.startupShortcuts = new ArrayList<ShortcutData>();
        this.allowProgramGroup = false;
        for (IXMLElement shortcutSpec : shortcutSpecs) {
            List forPacks;
            if (!this.matcher.matchesCurrentPlatform(OsConstraintHelper.getOsList((IXMLElement)shortcutSpec))) continue;
            logger.fine("Checking Condition for " + shortcutSpec.getAttribute("name"));
            if (!this.checkConditions(shortcutSpec)) continue;
            logger.fine("Checked Condition for " + shortcutSpec.getAttribute("name"));
            ShortcutData data = new ShortcutData();
            data.name = shortcutSpec.getAttribute("name");
            data.subgroup = shortcutSpec.getAttribute("subgroup", "");
            data.description = shortcutSpec.getAttribute("description", "");
            data.deskTopEntryLinux_URL = shortcutSpec.getAttribute("url", "");
            data.deskTopEntryLinux_Type = shortcutSpec.getAttribute("type", "");
            data.deskTopEntryLinux_Encoding = shortcutSpec.getAttribute("encoding", "");
            data.deskTopEntryLinux_MimeType = shortcutSpec.getAttribute("mimetype", "");
            data.deskTopEntryLinux_Terminal = shortcutSpec.getAttribute("terminal", "");
            data.deskTopEntryLinux_TerminalOptions = shortcutSpec.getAttribute("terminalOptions", "");
            data.deskTopEntryLinux_X_KDE_UserName = shortcutSpec.getAttribute("KdeUsername", "root");
            data.deskTopEntryLinux_X_KDE_SubstituteUID = shortcutSpec.getAttribute("KdeSubstUID", "false");
            data.TryExec = shortcutSpec.getAttribute("tryexec", "");
            data.Categories = shortcutSpec.getAttribute("categories", "");
            data.createForAll = Boolean.valueOf(shortcutSpec.getAttribute("createForAll", "false"));
            data.commandLine = shortcutSpec.getAttribute("commandLine", "");
            data.target = this.fixSeparatorChar(shortcutSpec.getAttribute("target", ""));
            data.iconFile = this.fixSeparatorChar(shortcutSpec.getAttribute("iconFile", ""));
            data.iconIndex = Integer.parseInt(shortcutSpec.getAttribute("iconIndex", "0"));
            data.workingDirectory = this.fixSeparatorChar(shortcutSpec.getAttribute("workingDirectory", ""));
            String initialState = shortcutSpec.getAttribute("initialState", "");
            data.initialState = initialState.equals("noShow") ? 0 : (initialState.equals("normal") ? 1 : (initialState.equals("maximized") ? 3 : (initialState.equals("minimized") ? 2 : 1)));
            data.runAsAdministrator = Boolean.valueOf(shortcutSpec.getAttribute("runAsAdministrator", "false"));
            if (data.name == null) {
                logger.warning("Shorcut specification is missing the name attribute");
                continue;
            }
            if (data.target == null) {
                logger.warning("Shortcut " + data.name + "has not target");
                data.target = "";
            }
            if (!this.shortcutRequiredFor(forPacks = shortcutSpec.getChildrenNamed("createForPack"))) continue;
            if (XMLHelper.attributeIsTrue((IXMLElement)shortcutSpec, (String)"desktop")) {
                data.addToGroup = false;
                data.type = 3;
                this.desktopShortcuts.add(data.clone());
            }
            if (XMLHelper.attributeIsTrue((IXMLElement)shortcutSpec, (String)"applications")) {
                data.addToGroup = false;
                data.type = 1;
                this.shortcuts.add(data.clone());
            }
            if (XMLHelper.attributeIsTrue((IXMLElement)shortcutSpec, (String)"startMenu")) {
                data.addToGroup = false;
                data.type = 2;
                this.shortcuts.add(data.clone());
            }
            if (XMLHelper.attributeIsTrue((IXMLElement)shortcutSpec, (String)"startup")) {
                data.addToGroup = false;
                data.type = 4;
                this.startupShortcuts.add(data.clone());
            }
            if (!XMLHelper.attributeIsTrue((IXMLElement)shortcutSpec, (String)"programGroup")) continue;
            this.allowProgramGroup = true;
            data.addToGroup = true;
            data.type = this.shortcut.getLinkType();
            this.shortcuts.add(data.clone());
        }
        if (this.shortcuts.size() > 0) {
            this.createShortcuts = true;
        }
    }

    private boolean checkConditions(IXMLElement shortcutSpec) {
        boolean result = true;
        String condition = shortcutSpec.getAttribute("condition");
        if (condition != null) {
            result = this.installData.getRules().isConditionTrue(condition);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createShortcuts(List<ShortcutData> shortcuts) {
        if (!this.createShortcuts) {
            return;
        }
        ArrayList<String> startMenuShortcuts = new ArrayList<String>();
        for (ShortcutData data : shortcuts) {
            try {
                Unix_Shortcut unixcut;
                String f;
                String groupName = this.getGroupName() + data.subgroup;
                this.shortcut.setUserType(this.userType);
                this.shortcut.setLinkName(data.name);
                this.shortcut.setLinkType(data.type);
                this.shortcut.setArguments(data.commandLine);
                this.shortcut.setDescription(data.description);
                this.shortcut.setIconLocation(data.iconFile, data.iconIndex);
                this.shortcut.setShowCommand(data.initialState);
                this.shortcut.setTargetPath(data.target);
                this.shortcut.setWorkingDirectory(data.workingDirectory);
                this.shortcut.setEncoding(data.deskTopEntryLinux_Encoding);
                this.shortcut.setMimetype(data.deskTopEntryLinux_MimeType);
                this.shortcut.setRunAsAdministrator(data.runAsAdministrator);
                this.shortcut.setTerminal(data.deskTopEntryLinux_Terminal);
                this.shortcut.setTerminalOptions(data.deskTopEntryLinux_TerminalOptions);
                this.shortcut.setType(data.deskTopEntryLinux_Type);
                this.shortcut.setKdeSubstUID(data.deskTopEntryLinux_X_KDE_SubstituteUID);
                this.shortcut.setKdeUserName(data.deskTopEntryLinux_X_KDE_UserName);
                this.shortcut.setURL(data.deskTopEntryLinux_URL);
                this.shortcut.setTryExec(data.TryExec);
                this.shortcut.setCategories(data.Categories);
                this.shortcut.setCreateForAll(Boolean.valueOf(data.createForAll));
                this.shortcut.setUninstaller(this.uninstallData);
                if (data.addToGroup) {
                    this.shortcut.setProgramGroup(groupName);
                } else {
                    this.shortcut.setProgramGroup("");
                }
                this.shortcut.save();
                if ((data.type == 1 || data.addToGroup) && this.shortcut instanceof Unix_Shortcut && (f = (unixcut = (Unix_Shortcut)this.shortcut).getWrittenFileName()) != null) {
                    startMenuShortcuts.add(f);
                }
                String fileName = this.shortcut.getFileName();
                this.files.add(0, fileName);
                File file = new File(fileName);
                File base = new File(this.shortcut.getBasePath());
                Vector<File> intermediates = new Vector<File>();
                this.execFiles.add(new ExecutableFile(fileName, 2, 3, new ArrayList(), false));
                this.files.add(fileName);
                while ((file = file.getParentFile()) != null && !file.equals(base)) {
                    intermediates.add(file);
                }
                if (file == null) continue;
                Enumeration filesEnum = intermediates.elements();
                while (filesEnum.hasMoreElements()) {
                    this.files.add(0, ((File)filesEnum.nextElement()).toString());
                }
            }
            catch (Exception exception) {
            }
        }
        if (!startMenuShortcuts.isEmpty() && OsVersion.IS_UNIX) {
            this.writeXDGMenuFile(startMenuShortcuts, this.getGroupName(), this.programGroupIconFile, this.programGroupComment);
        }
        if (!shortcuts.isEmpty()) {
            this.shortcut.execPostAction();
        }
        try {
            if (this.execFiles == null) {
                // empty if block
            }
        }
        catch (NullPointerException nep) {
            nep.printStackTrace();
        }
        catch (RuntimeException cannot) {
            cannot.printStackTrace();
        }
        this.shortcut.cleanUp();
    }

    private String createXDGDirectory(String menuName, String icon, String comment) {
        String menuDirectoryDescriptor = "[Desktop Entry]\nName=$Name\nComment=$Comment\nIcon=$Icon\nType=Directory\nEncoding=UTF-8";
        menuDirectoryDescriptor = StringTool.replace((String)menuDirectoryDescriptor, (String)"$Name", (String)menuName);
        menuDirectoryDescriptor = StringTool.replace((String)menuDirectoryDescriptor, (String)"$Comment", (String)comment);
        menuDirectoryDescriptor = StringTool.replace((String)menuDirectoryDescriptor, (String)"$Icon", (String)icon);
        return menuDirectoryDescriptor;
    }

    private String createXDGMenu(List<String> shortcutFiles, String menuName) {
        String menuConfigText = "<Menu>\n<Name>Applications</Name>\n<Menu>\n<Directory>" + menuName.replaceAll(" ", "-") + "-izpack.directory</Directory>\n<Name>" + menuName + "</Name>\n<Include>\n";
        for (String shortcutFile : shortcutFiles) {
            menuConfigText = menuConfigText + "<Filename>" + shortcutFile + "</Filename>\n";
        }
        menuConfigText = menuConfigText + "</Include>\n</Menu>\n</Menu>";
        return menuConfigText;
    }

    private String fixSeparatorChar(String path) {
        String newPath = path.replace('/', File.separatorChar);
        newPath = newPath.replace('\\', File.separatorChar);
        return newPath;
    }

    private IXMLElement readShortcutSpec() throws Exception {
        IXMLElement spec;
        InputStream shortcutSpec = null;
        try {
            shortcutSpec = this.resources.getInputStream(TargetFactory.getCurrentOSPrefix() + "shortcutSpec.xml");
        }
        catch (ResourceNotFoundException resourceNotFound) {
            try {
                shortcutSpec = this.resources.getInputStream("shortcutSpec.xml");
            }
            catch (ResourceNotFoundException resourceNotFoundException) {
                // empty catch block
            }
        }
        try {
            VariableSubstitutorImpl replacer = new VariableSubstitutorImpl(this.installData.getVariables());
            String substitutedSpec = replacer.substitute(shortcutSpec, SubstitutionType.TYPE_XML);
            XMLParser parser = new XMLParser();
            spec = parser.parse(substitutedSpec);
        }
        catch (Exception e) {
            return null;
        }
        IOUtils.closeQuietly((InputStream)shortcutSpec);
        return spec;
    }

    private boolean shortcutRequiredFor(List<IXMLElement> packs) {
        if (packs.size() == 0) {
            return true;
        }
        for (int i = 0; i < this.installData.getSelectedPacks().size(); ++i) {
            String selected = ((Pack)this.installData.getSelectedPacks().get(i)).getName();
            for (IXMLElement pack : packs) {
                String required = pack.getAttribute("name", "");
                if (!selected.equals(required)) continue;
                return true;
            }
        }
        return false;
    }

    private void writeString(String str, String file) {
        boolean failed = false;
        try {
            FileWriter writer = new FileWriter(file);
            writer.write(str);
            writer.close();
        }
        catch (Exception ignore) {
            failed = true;
            logger.warning("Failed to create Gnome menu");
        }
        if (!failed) {
            this.uninstallData.addFile(file, true);
        }
    }

    private void writeXDGMenuFile(List<String> desktopFileNames, String groupName, String icon, String comment) {
        if ("".equals(this.suggestedProgramGroup) || this.suggestedProgramGroup == null) {
            return;
        }
        if (OsVersion.IS_UNIX) {
            String directoryFolder;
            String gnome3MenuFolder;
            String menuFolder;
            String menuFile = this.createXDGMenu(desktopFileNames, groupName);
            String dirFile = this.createXDGDirectory(groupName, icon, comment);
            if (this.userType == 2) {
                menuFolder = "/etc/xdg/menus/applications-merged/";
                gnome3MenuFolder = "/etc/xdg/menus/applications-gnome-merged/";
                directoryFolder = "/usr/share/desktop-directories/";
            } else {
                menuFolder = System.getProperty("user.home") + File.separator + ".config/menus/applications-merged/";
                gnome3MenuFolder = System.getProperty("user.home") + File.separator + ".config/menus/applications-gnome-merged/";
                directoryFolder = System.getProperty("user.home") + File.separator + ".local/share/desktop-directories/";
            }
            File menuFolderFile = new File(menuFolder);
            File gnome3MenuFolderFile = new File(gnome3MenuFolder);
            File directoryFolderFile = new File(directoryFolder);
            String menuFilePath = menuFolder + groupName + ".menu";
            String gnome3MenuFilePath = gnome3MenuFolder + groupName + ".menu";
            String dirFilePath = directoryFolder + groupName.replaceAll(" ", "-") + "-izpack.directory";
            menuFolderFile.mkdirs();
            gnome3MenuFolderFile.mkdirs();
            directoryFolderFile.mkdirs();
            this.writeString(menuFile, menuFilePath);
            this.writeString(menuFile, gnome3MenuFilePath);
            this.writeString(dirFile, dirFilePath);
        }
    }

    public String verifyProgramGroup(String groupName) {
        if (!this.platform.isValidDirectorySyntax(groupName)) {
            return this.installData.getMessages().get("ShortcutPanel.group.error", new Object[0]);
        }
        return "";
    }

    public final boolean isCreateShortcutsImmediately() {
        return this.createShortcutsImmediately;
    }

    private void setCreateShortcutsImmediately(boolean createShortcutsImmediately) {
        this.createShortcutsImmediately = createShortcutsImmediately;
    }

    public void setPlatform(Platform platform) {
        this.platform = platform;
    }

    public boolean canCreateShortcuts() {
        return this.createShortcuts;
    }

    public boolean allowProgramGroup() {
        return this.allowProgramGroup;
    }

    class LateShortcutInstallListener
    extends AbstractInstallerListener {
        LateShortcutInstallListener() {
        }

        public void afterPacks(List<Pack> packs, ProgressListener listener) {
            try {
                ShortcutPanelLogic.this.createAndRegisterShortcuts();
            }
            catch (Exception exception) {
                throw new IzPackException("Failed to create shortcuts", (Throwable)exception);
            }
        }
    }
}

