/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.sudo;

import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.api.substitutor.VariableSubstitutor;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.gui.InstallerFrame;
import com.izforge.izpack.installer.gui.IzPanel;
import com.izforge.izpack.util.Platform;
import com.izforge.izpack.util.PlatformModelMatcher;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SudoPanel
extends IzPanel
implements ActionListener {
    private static Logger logger = Logger.getLogger(SudoPanel.class.getName());
    private static final long serialVersionUID = 3689628116465561651L;
    private final JTextField passwordField;
    private boolean isValid = false;

    public SudoPanel(Panel panel, InstallerFrame parent, GUIInstallData installData, Resources resources, VariableSubstitutor replacer, PlatformModelMatcher matcher) {
        super(panel, parent, installData, resources);
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        this.add(LabelFactory.create((String)this.getString("SudoPanel.info"), (int)11));
        this.add(Box.createRigidArea(new Dimension(0, 5)));
        this.add(LabelFactory.create((String)this.getString("SudoPanel.tip"), (Icon)((Icon)parent.getIcons().get((Object)"tip")), (int)11));
        this.add(Box.createRigidArea(new Dimension(0, 5)));
        JPanel spacePanel = new JPanel();
        spacePanel.setAlignmentX(0.0f);
        spacePanel.setAlignmentY(0.5f);
        spacePanel.setBorder(BorderFactory.createEmptyBorder(80, 30, 0, 50));
        spacePanel.setLayout(new BorderLayout(5, 5));
        spacePanel.add((Component)LabelFactory.create((String)this.getString("SudoPanel.specifyAdminPassword")), "North");
        this.passwordField = new JTextField();
        this.passwordField.addActionListener(this);
        JPanel space2Panel = new JPanel();
        space2Panel.setLayout(new BorderLayout());
        space2Panel.add((Component)this.passwordField, "North");
        space2Panel.add(Box.createRigidArea(new Dimension(0, 5)), "Center");
        spacePanel.add((Component)space2Panel, "Center");
        this.add(spacePanel);
    }

    public void panelActivate() {
        this.passwordField.requestFocus();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.doSudoCmd();
    }

    private void doSudoCmd() {
        Platform platform = this.installData.getPlatform();
        String pass = this.passwordField.getText();
        this.isValid = false;
        try {
            if (platform.isA(Platform.Name.UNIX)) {
                this.isValid = SudoPanel.checkUnixRootPassByCommandline(pass);
                if (this.isValid) {
                    this.installData.setVariable("password", pass);
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, e.getMessage(), e);
            this.isValid = false;
        }
    }

    public boolean isValidated() {
        if (!this.isValid) {
            this.doSudoCmd();
        }
        if (!this.isValid) {
            JOptionPane.showMessageDialog((Component)((Object)this), this.getString("SudoPanel.invalidPassword"), "Error", 0);
        }
        return this.isValid;
    }

    private static List<String> getSudoCommandline(String password, String command) {
        if (password == null) {
            password = "";
        }
        if (command == null) {
            command = "";
        }
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("/bin/bash");
        cmd.add("-c");
        cmd.add("echo " + password + " | sudo -S " + command.trim());
        return cmd;
    }

    public static void execCmdAuthByCommandline(String password, String commandString) throws Exception {
        List<String> command = SudoPanel.getSudoCommandline(password, commandString);
        SudoPanel.get(command);
    }

    public static boolean checkUnixRootPassByCommandline(String password) throws Exception {
        boolean root = false;
        String dir = "/test_root_" + new Date().getTime();
        SudoPanel.execCmdAuthByCommandline(password, "mkdir " + dir);
        if (new File(dir).exists()) {
            SudoPanel.execCmdAuthByCommandline(password, "rm -rf " + dir);
            root = true;
        }
        return root;
    }

    public static int get(List<String> command) throws Exception {
        int result = -1;
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(command);
            processBuilder.inheritIO();
            result = processBuilder.start().waitFor();
        }
        catch (Exception reason) {
            throw new Exception("Problem executing command", reason);
        }
        return result;
    }
}

