/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.treepacks;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.plaf.metal.MetalLookAndFeel;

class PartialIcon
implements Icon {
    Color color;

    public PartialIcon(boolean enabled) {
        this.color = enabled ? Color.green : Color.gray;
    }

    protected int getControlSize() {
        return 13;
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int x, int y) {
        int controlSize = this.getControlSize();
        graphics.setColor(MetalLookAndFeel.getControlShadow());
        graphics.fillRect(x, y, controlSize - 1, controlSize - 1);
        this.drawBorder(graphics, x, y, controlSize, controlSize);
        graphics.setColor(this.color);
        this.drawCheck(component, graphics, x, y);
    }

    private void drawBorder(Graphics graphics, int x, int y, int width, int height) {
        graphics.translate(x, y);
        graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
        graphics.setColor(new Color(0.4f, 0.4f, 0.4f));
        graphics.drawRect(0, 0, width - 2, height - 2);
        graphics.setColor(MetalLookAndFeel.getControlHighlight());
        graphics.setColor(new Color(0.6f, 0.6f, 0.6f));
        graphics.drawRect(1, 1, width - 2, height - 2);
        graphics.setColor(new Color(0.99f, 0.99f, 0.99f));
        graphics.fillRect(2, 2, width - 3, height - 3);
        graphics.setColor(MetalLookAndFeel.getControl());
        graphics.drawLine(0, height - 1, 1, height - 2);
        graphics.drawLine(width - 1, 0, width - 2, 1);
        graphics.translate(-x, -y);
    }

    protected void drawCheck(Component component, Graphics graphics, int x, int y) {
        int controlSize = this.getControlSize();
        graphics.setColor(new Color(0.0f, 0.7f, 0.0f));
        graphics.fillOval(x + controlSize / 2 - 2, y + controlSize / 2 - 2, 6, 6);
    }

    @Override
    public int getIconWidth() {
        return this.getControlSize();
    }

    @Override
    public int getIconHeight() {
        return this.getControlSize();
    }
}

