/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.userinput;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.adaptator.impl.XMLElementImpl;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.Overrides;
import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.data.Variables;
import com.izforge.izpack.api.exception.InstallerException;
import com.izforge.izpack.api.factory.ObjectFactory;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.installer.automation.PanelAutomation;
import com.izforge.izpack.panels.userinput.field.AbstractFieldView;
import com.izforge.izpack.panels.userinput.field.Field;
import com.izforge.izpack.panels.userinput.field.FieldView;
import com.izforge.izpack.panels.userinput.field.UserInputPanelSpec;
import com.izforge.izpack.panels.userinput.field.custom.CustomFieldType;
import com.izforge.izpack.util.PlatformModelMatcher;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class UserInputPanelAutomationHelper
implements PanelAutomation {
    private static final Logger logger = Logger.getLogger(UserInputPanelAutomationHelper.class.getName());
    private static final String AUTO_KEY_ENTRY = "entry";
    private static final String AUTO_ATTRIBUTE_KEY = "key";
    private static final String AUTO_ATTRIBUTE_VALUE = "value";
    private Panel panel;
    private UserInputPanelSpec model;
    private List<? extends AbstractFieldView> views;

    public UserInputPanelAutomationHelper(Panel panel, Resources resources, ObjectFactory factory, PlatformModelMatcher matcher, InstallData installData) {
        this.panel = panel;
        this.model = new UserInputPanelSpec(resources, installData, factory, matcher);
    }

    public UserInputPanelAutomationHelper(List<? extends AbstractFieldView> views) {
        this.views = views;
    }

    public void createInstallationRecord(InstallData installData, IXMLElement rootElement) {
        HashSet<String> omitFromAutoSet = new HashSet<String>();
        Map<String, String> entries = this.generateEntries(installData, this.views, omitFromAutoSet);
        for (String key : entries.keySet()) {
            XMLElementImpl dataElement = new XMLElementImpl(AUTO_KEY_ENTRY, rootElement);
            dataElement.setAttribute(AUTO_ATTRIBUTE_KEY, key);
            String value = omitFromAutoSet.contains(key) ? "" : entries.get(key);
            dataElement.setAttribute(AUTO_ATTRIBUTE_VALUE, value);
            rootElement.addChild((IXMLElement)dataElement);
        }
    }

    private Map<String, String> generateEntries(InstallData installData, List<? extends AbstractFieldView> views, HashSet<String> omitFromAutoSet) {
        HashMap<String, String> entries = new HashMap<String, String>();
        for (FieldView fieldView : views) {
            if (!fieldView.isDisplayed()) continue;
            String variable = fieldView.getField().getVariable();
            if (variable != null) {
                String entry = installData.getVariable(variable);
                if (fieldView.getField().getOmitFromAuto()) {
                    omitFromAutoSet.add(variable);
                }
                entries.put(variable, entry);
            }
            List<Object> namedVariables = new ArrayList();
            if (fieldView instanceof CustomFieldType) {
                CustomFieldType customField = (CustomFieldType)((Object)fieldView);
                namedVariables = customField.getVariables();
            }
            for (String numberedVariable : namedVariables) {
                entries.put(numberedVariable, installData.getVariable(numberedVariable));
            }
        }
        return entries;
    }

    public void runAutomated(InstallData idata, IXMLElement panelRoot) throws InstallerException {
        HashMap<String, String> attributeValues = new HashMap<String, String>();
        for (IXMLElement dataElement : panelRoot.getChildrenNamed(AUTO_KEY_ENTRY)) {
            String variable = dataElement.getAttribute(AUTO_ATTRIBUTE_KEY);
            String value = dataElement.getAttribute(AUTO_ATTRIBUTE_VALUE);
            if (variable == null || value == null) continue;
            attributeValues.put(variable, value);
        }
        Variables variables = idata.getVariables();
        IXMLElement panelSpec = this.model.getPanelSpec(this.panel.getPanelId());
        HashSet<String> blockedVariablesList = new HashSet<String>();
        if (panelSpec != null) {
            for (Field field : this.model.createFields(panelSpec)) {
                String variable = field.getVariable();
                if (variable == null) continue;
                String value = (String)attributeValues.remove(variable);
                if (value == null) {
                    if (variables.get(variable) != null) continue;
                    UserInputPanelAutomationHelper.setVariable(idata, blockedVariablesList, variable, field.getDefaultValue());
                    continue;
                }
                UserInputPanelAutomationHelper.setVariable(idata, blockedVariablesList, variable, value);
            }
        }
        for (Map.Entry entry : attributeValues.entrySet()) {
            UserInputPanelAutomationHelper.setVariable(idata, blockedVariablesList, (String)entry.getKey(), (String)entry.getValue());
        }
        variables.registerBlockedVariableNames(blockedVariablesList, (Object)panelRoot.getName());
    }

    private static void setVariable(InstallData idata, HashSet<String> blockedVariablesList, String variable, String value) {
        String expandedValue = idata.getVariables().replace(value);
        logger.fine("Setting variable " + variable + " to " + expandedValue);
        idata.setVariable(variable, expandedValue);
        blockedVariablesList.add(variable);
    }

    public void processOptions(InstallData installData, Overrides overrides) {
    }
}

