/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.userinput.console.custom;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.exception.UserInterruptException;
import com.izforge.izpack.api.handler.Prompt;
import com.izforge.izpack.api.resource.Messages;
import com.izforge.izpack.panels.userinput.FieldCommand;
import com.izforge.izpack.panels.userinput.console.ConsoleField;
import com.izforge.izpack.panels.userinput.field.Field;
import com.izforge.izpack.panels.userinput.field.UserInputPanelSpec;
import com.izforge.izpack.panels.userinput.field.ValidationStatus;
import com.izforge.izpack.panels.userinput.field.custom.Column;
import com.izforge.izpack.panels.userinput.field.custom.CustomField;
import com.izforge.izpack.panels.userinput.field.custom.CustomFieldType;
import com.izforge.izpack.util.Console;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConsoleCustomField
extends ConsoleField
implements CustomFieldType {
    private final UserInputPanelSpec userInputPanelSpec;
    private final IXMLElement spec;
    private final FieldCommand createField;
    private int numberOfRows = 0;
    private int numberOfColumns = 0;
    private final CustomField customInfoField;
    private final int maxRow;
    private final int minRow;
    private static final int CONTINUE = 1;
    private static final int REDISPLAY = 2;
    Map<Integer, List<ConsoleField>> consoleFields;

    public ConsoleCustomField(CustomField customField, Console console, Prompt prompt, FieldCommand createField, UserInputPanelSpec userInputPanelSpec, IXMLElement spec) {
        super(customField, console, prompt);
        this.spec = spec;
        this.userInputPanelSpec = userInputPanelSpec;
        this.createField = createField;
        this.customInfoField = customField;
        this.maxRow = customField.getMaxRow();
        this.minRow = customField.getMinRow();
        this.numberOfColumns = customField.getFields().size();
    }

    @Override
    public CustomField getField() {
        return (CustomField)super.getField();
    }

    private void addInitialRows() {
        for (int count = this.minRow; count >= 1; --count) {
            this.addRow();
        }
    }

    private void showInitialRows() {
        for (int i = 1; i <= this.numberOfRows; ++i) {
            this.editRow(i, true);
        }
    }

    private boolean editRow(int rowNumber, boolean initial) {
        List<ConsoleField> fields = this.consoleFields.get(rowNumber);
        this.print("--> Row " + rowNumber + ": ");
        for (ConsoleField field : fields) {
            field.setDisplayed(true);
            boolean ro = field.isReadonly();
            if (initial) {
                field.setReadonly(true);
                field.getField().setValue(field.getField().getInitialValue());
            }
            while (!field.display()) {
            }
            if (!initial) continue;
            field.setReadonly(ro);
        }
        return true;
    }

    private boolean canAddRow() {
        return this.numberOfRows < this.maxRow;
    }

    private boolean addRow() {
        if (!this.canAddRow()) {
            return false;
        }
        ++this.numberOfRows;
        ArrayList<ConsoleField> fields = new ArrayList<ConsoleField>();
        for (Field field : this.createCustomField(this.userInputPanelSpec, this.spec).getFields()) {
            field.setVariable(field.getVariable() + "." + this.numberOfRows);
            ConsoleField consoleField = this.createField.createConsoleField(field);
            consoleField.setReadonly(this.isReadonly());
            fields.add(consoleField);
        }
        this.consoleFields.put(this.numberOfRows, fields);
        return true;
    }

    private boolean canRemoveRow() {
        return this.numberOfRows > this.minRow;
    }

    private boolean removeRow() {
        if (!this.canRemoveRow()) {
            return false;
        }
        this.consoleFields.remove(this.numberOfRows);
        --this.numberOfRows;
        return true;
    }

    @Override
    public boolean display() {
        int value;
        this.numberOfRows = 0;
        this.consoleFields = new HashMap<Integer, List<ConsoleField>>();
        this.addInitialRows();
        do {
            int userValue;
            this.showInitialRows();
            if (this.isReadonly()) {
                String prompt = this.getMessage("ConsoleInstaller.continueQuitRedisplay");
                userValue = this.getConsole().prompt(prompt, 1, 3, 3, 2);
                switch (userValue) {
                    case 1: {
                        value = 1;
                        break;
                    }
                    case 2: {
                        throw new UserInterruptException(this.getMessage("ConsoleInstaller.aborted.PressedQuit"));
                    }
                    default: {
                        value = 2;
                        break;
                    }
                }
                continue;
            }
            userValue = this.getConsole().prompt(this.getPrompt(), 0, this.numberOfRows + 4, this.numberOfRows + 2, 0);
            if (userValue == 0) {
                throw new UserInterruptException(this.getMessage("ConsoleInstaller.aborted.PressedQuit"));
            }
            if (userValue <= this.numberOfRows) {
                this.editRow(userValue, false);
                value = 2;
                continue;
            }
            if (userValue == this.numberOfRows + 1) {
                value = 1;
                continue;
            }
            if (userValue == this.numberOfRows + 3) {
                if (this.addRow()) {
                    this.editRow(this.numberOfRows, false);
                }
                value = 2;
                continue;
            }
            if (userValue == this.numberOfRows + 4) {
                this.removeRow();
                value = 2;
                continue;
            }
            value = 2;
        } while (value != 1);
        this.customInfoField.setValue(Integer.toString(this.numberOfRows));
        if (!this.columnsAreValid()) {
            this.display();
        }
        return true;
    }

    private String getPrompt() {
        InstallData installData = this.getField().getInstallData();
        Messages messages = installData.getMessages();
        if (this.canAddRow() && this.canRemoveRow()) {
            return messages.get("UserInputPanel.custom.console.add.and.remove", new Object[]{this.numberOfRows, this.numberOfRows + 1, this.numberOfRows + 2, this.numberOfRows + 3, this.numberOfRows + 4, 0});
        }
        if (this.canAddRow()) {
            return messages.get("UserInputPanel.custom.console.add", new Object[]{this.numberOfRows, this.numberOfRows + 1, this.numberOfRows + 2, this.numberOfRows + 3, 0});
        }
        if (this.canRemoveRow()) {
            return messages.get("UserInputPanel.custom.console.remove", new Object[]{this.numberOfRows, this.numberOfRows + 1, this.numberOfRows + 2, this.numberOfRows + 4, 0});
        }
        return messages.get("UserInputPanel.custom.console.add.and.remove", new Object[]{this.numberOfRows, this.numberOfRows + 1, this.numberOfRows + 2, 0});
    }

    private boolean columnsAreValid() {
        List<Column> columns = this.customInfoField.getColumns();
        String[] columnVariables = this.getVariablesByColumn();
        for (int i = 0; i < columnVariables.length; ++i) {
            ValidationStatus status = columns.get(i).validate(columnVariables[i]);
            if (status.isValid()) continue;
            System.out.println(status.getMessage());
            return false;
        }
        return true;
    }

    private String[] getVariablesByColumn() {
        String[] columnVariables = new String[this.numberOfColumns];
        for (int col = 0; col < this.numberOfColumns; ++col) {
            columnVariables[col] = "";
            for (int row = 1; row <= this.numberOfRows; ++row) {
                ConsoleField consoleField = this.consoleFields.get(row).get(col);
                if (!consoleField.isDisplayed()) continue;
                int n = col;
                columnVariables[n] = columnVariables[n] + this.getField().getInstallData().getVariable(consoleField.getVariable()) + ",";
            }
        }
        for (int i = 0; i < columnVariables.length; ++i) {
            String v = columnVariables[i];
            columnVariables[i] = v.substring(0, v.length() - 1);
        }
        return columnVariables;
    }

    @Override
    public List<String> getVariables() {
        ArrayList<String> countedVariables = new ArrayList<String>();
        for (int i = 1; i <= this.numberOfRows; ++i) {
            for (ConsoleField consoleField : this.consoleFields.get(i)) {
                if (!consoleField.isDisplayed()) continue;
                countedVariables.add(consoleField.getVariable());
            }
        }
        return countedVariables;
    }

    private CustomField createCustomField(UserInputPanelSpec userInputPanelSpec, IXMLElement spec) {
        List<Field> fields = userInputPanelSpec.createFields(spec);
        for (Field field : fields) {
            if (!(field instanceof CustomField)) continue;
            return (CustomField)field;
        }
        return null;
    }
}

