/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.userinput.field;

import com.izforge.izpack.api.data.Configurable;
import com.izforge.izpack.api.data.ConfigurationOption;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.factory.ObjectFactory;
import com.izforge.izpack.panels.userinput.field.FieldValidatorReader;
import com.izforge.izpack.panels.userinput.processorclient.ValuesProcessingClient;
import com.izforge.izpack.panels.userinput.validator.Validator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FieldValidator {
    private final String className;
    private final String message;
    private final ObjectFactory factory;
    private Validator validator;
    private Configurable configurable;
    private InstallData installData;
    private static final Logger logger = Logger.getLogger(FieldValidator.class.getName());

    public FieldValidator(Class<? extends Validator> type, String message, ObjectFactory factory) {
        this.className = type.getName();
        this.message = message;
        this.factory = factory;
    }

    public FieldValidator(String className, Configurable configurable, String message, ObjectFactory factory) {
        this.className = className;
        this.configurable = configurable;
        this.message = message;
        this.factory = factory;
    }

    public FieldValidator(FieldValidatorReader validatorReader, ObjectFactory factory) {
        this.configurable = validatorReader;
        this.className = validatorReader.getClassName();
        this.message = validatorReader.getMessage();
        this.factory = factory;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean validate(String[] values) {
        return this.validate(new ValuesProcessingClient(values));
    }

    public void setInstallData(InstallData installData) {
        this.installData = installData;
    }

    public boolean validate(ValuesProcessingClient values) {
        boolean result = false;
        try {
            Set names;
            if (this.validator == null) {
                this.validator = (Validator)this.factory.create(this.className, Validator.class, new Object[0]);
            }
            if (this.configurable != null && (names = this.configurable.getNames()) != null) {
                for (String key : names) {
                    ConfigurationOption option = this.configurable.getConfigurationOption(key);
                    if (this.installData != null) {
                        String value = option.getValue(this.installData.getRules());
                        String newValue = this.installData.getVariables().replace(value);
                        if (value != null && !value.equals(newValue)) {
                            option = new ConfigurationOption(newValue);
                        }
                    }
                    values.addConfigurationOption(key, option);
                }
            }
            result = this.validator.validate(values);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Validation " + (result ? "OK" : "FAILED") + " using " + this.validator.getClass().getSimpleName());
            }
        }
        catch (Throwable exception) {
            logger.log(Level.WARNING, "Validation using " + this.className + " failed: " + exception.getMessage(), exception);
        }
        return result;
    }
}

