/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.userpath;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.config.Options;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.resource.Messages;
import com.izforge.izpack.core.substitutor.VariableSubstitutorImpl;
import com.izforge.izpack.installer.console.AbstractConsolePanel;
import com.izforge.izpack.installer.console.ConsolePanel;
import com.izforge.izpack.installer.panel.PanelView;
import com.izforge.izpack.panels.userpath.UserPathPanelAutomationHelper;
import com.izforge.izpack.util.Console;
import java.io.File;
import java.util.Arrays;
import java.util.Properties;

public class UserPathConsolePanel
extends AbstractConsolePanel {
    public static final String USER_PATH_INFO = "UserPathPanel.info";
    public static final String USER_PATH_NO_DIR = "UserPathPanel.nodir";
    public static final String USER_PATH_EXISTS = "UserPathPanel.exists_warn";
    private static final String EMPTY = "";
    private Messages messages;
    private final InstallData installData;

    public UserPathConsolePanel(PanelView<ConsolePanel> panel, InstallData installData) {
        super(panel);
        this.installData = installData;
    }

    private void loadLangpack(InstallData installData) {
        this.messages = installData.getMessages();
    }

    private String getTranslation(String id) {
        return this.messages.get(id, new Object[0]);
    }

    public boolean generateOptions(InstallData installData, Options options) {
        String name = "UserPathPanelVariable";
        options.add((Object)"UserPathPanelVariable", (Object)installData.getVariable("UserPathPanelVariable"));
        options.addEmptyLine((Object)"UserPathPanelVariable");
        options.putComment((Object)"UserPathPanelVariable", Arrays.asList(this.getPanel().getPanelId()));
        return true;
    }

    public boolean run(InstallData installData, Properties properties) {
        String userPath = properties.getProperty("UserPathPanelVariable");
        if (userPath == null || userPath.trim().isEmpty()) {
            System.err.println("Missing mandatory UserPathPanelVariable!");
            return false;
        }
        userPath = installData.getVariables().replace(userPath);
        installData.setVariable("UserPathPanelVariable", userPath);
        return true;
    }

    public boolean run(InstallData installData, Console console) {
        this.printHeadLine(installData, console);
        this.loadLangpack(installData);
        String introText = this.getI18nStringForClass("intro", "UserPathPanel", installData);
        if (introText != null) {
            console.println(introText);
            console.println();
        }
        VariableSubstitutorImpl vs = new VariableSubstitutorImpl(installData.getVariables());
        String pathMessage = this.getTranslation(USER_PATH_INFO);
        String defaultUserPath = installData.getVariable("UserPathPanelVariable");
        defaultUserPath = defaultUserPath == null ? EMPTY : vs.substitute(defaultUserPath, null);
        String userPath = console.promptLocation(pathMessage + " [" + defaultUserPath + "]", defaultUserPath);
        if (userPath == null) {
            return false;
        }
        if (EMPTY.equals(userPath)) {
            if (EMPTY.equals(defaultUserPath)) {
                UserPathConsolePanel.out("Error: Path is empty! Enter a valid path");
                return this.run(installData, console);
            }
            userPath = defaultUserPath;
        } else {
            userPath = vs.substitute(userPath, null);
        }
        if (!UserPathConsolePanel.isPathAFile(userPath)) {
            if (UserPathConsolePanel.doesPathExists(userPath) && !UserPathConsolePanel.isPathEmpty(userPath)) {
                UserPathConsolePanel.out(this.getTranslation(USER_PATH_EXISTS));
                if (!this.promptEndPanel(installData, console)) {
                    return false;
                }
            }
        } else {
            UserPathConsolePanel.out(this.getTranslation(USER_PATH_NO_DIR));
            return this.run(installData, console);
        }
        if (this.promptEndPanel(installData, console)) {
            installData.setVariable("UserPathPanelVariable", userPath);
            return true;
        }
        return false;
    }

    private static boolean doesPathExists(String path) {
        File file = new File(path);
        return file.exists();
    }

    private static boolean isPathAFile(String path) {
        File file = new File(path);
        return file.isFile();
    }

    private static boolean isPathEmpty(String path) {
        File file = new File(path);
        return file.list().length == 0;
    }

    private static void out(String out) {
        System.out.println(out);
    }

    public void createInstallationRecord(IXMLElement panelRoot) {
        new UserPathPanelAutomationHelper().createInstallationRecord(this.installData, panelRoot);
    }
}

