/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.userpath;

import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.exception.ResourceNotFoundException;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.gui.IzPanelLayout;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.gui.log.Log;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.gui.InstallerFrame;
import com.izforge.izpack.installer.gui.IzPanel;
import com.izforge.izpack.panels.path.PathSelectionPanel;
import com.izforge.izpack.util.IoHelper;
import com.izforge.izpack.util.OsVersion;
import com.izforge.izpack.util.Platform;
import java.awt.Component;
import java.awt.LayoutManager2;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UserPathInputPanel
extends IzPanel
implements ActionListener {
    private static final long serialVersionUID = 3257566217698292531L;
    private static final Logger logger = Logger.getLogger(UserPathInputPanel.class.getName());
    protected String targetPanel;
    protected boolean mustExist = false;
    protected boolean loadedDefaultDir = false;
    protected String[] existFiles = null;
    protected PathSelectionPanel pathSelectionPanel;
    protected String error;
    protected String warn;
    protected String emptyTargetMsg;
    protected String warnMsg;
    protected String reqMsg;
    protected String notValidMsg;
    protected String notWritableMsg;
    protected String createDirMsg;
    protected String defaultDir = null;

    public UserPathInputPanel(Panel panel, String targetPanel, InstallerFrame parent, GUIInstallData installData, Resources resources, Log log) {
        super(panel, parent, installData, (LayoutManager2)new IzPanelLayout(log), resources);
        this.targetPanel = targetPanel;
        String mustExist = panel.getConfigurationOptionValue("mustExist", installData.getRules());
        if (mustExist != null) {
            this.mustExist = Boolean.parseBoolean(mustExist);
        }
        this.loadMessages();
        String introText = this.getI18nStringForClass("intro", targetPanel);
        if (introText != null) {
            this.add((Component)LabelFactory.createMultiLineLabel((String)introText));
            this.add(IzPanelLayout.createParagraphGap());
        }
        this.add(this.createLabel("info", this.targetPanel, "open", 2, true), "nextLine");
        this.pathSelectionPanel = new PathSelectionPanel(this, installData, this.targetPanel, log);
        this.add(this.pathSelectionPanel, "nextLine");
        this.createLayoutBottom();
        this.getLayoutHelper().completeLayout();
    }

    public void createLayoutBottom() {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.pathSelectionPanel.getPathInputField()) {
            this.parent.navigateNext();
        }
    }

    private void loadMessages() {
        this.error = this.getString("installer.error");
        this.warn = this.getString("installer.warning");
        this.reqMsg = this.getMessage("required");
        this.emptyTargetMsg = this.getMessage("empty_target");
        this.warnMsg = this.getMessage("exists_warn");
        this.notValidMsg = this.getMessage("notValid");
        this.notWritableMsg = this.getMessage("notwritable");
        this.createDirMsg = this.getMessage("createdir");
    }

    private String getMessage(String subkey) {
        String msg = this.getI18nStringForClass(subkey, this.targetPanel);
        if (msg == null) {
            msg = this.targetPanel + "." + subkey;
        }
        return msg;
    }

    public boolean isValidated() {
        String chosenPath = this.pathSelectionPanel.getPath();
        boolean ok = true;
        if (chosenPath.length() == 0) {
            if (this.isMustExist()) {
                this.emitError(this.error, this.reqMsg);
                return false;
            }
            ok = this.emitWarning(this.warn, this.emptyTargetMsg);
        }
        if (!ok) {
            return ok;
        }
        File path = new File(chosenPath).getAbsoluteFile();
        chosenPath = path.toString();
        this.pathSelectionPanel.setPath(chosenPath);
        if (this.isMustExist()) {
            if (!path.exists()) {
                this.emitError(this.error, this.reqMsg);
                return false;
            }
            if (!this.pathIsValid()) {
                this.emitError(this.error, this.notValidMsg);
                return false;
            }
        } else {
            int res;
            if (!this.isWriteable()) {
                this.emitError(this.error, this.notWritableMsg);
                return false;
            }
            ok = path.exists() ? (res = this.askQuestion(this.warn, this.warnMsg, 37, 47)) == 47 : this.emitNotificationFeedback(this.createDirMsg + "\n" + chosenPath);
        }
        return ok;
    }

    protected boolean pathIsValid() {
        if (this.existFiles == null) {
            return true;
        }
        for (String _existFile : this.existFiles) {
            File path = new File(this.pathSelectionPanel.getPath(), _existFile).getAbsoluteFile();
            if (path.exists()) continue;
            return false;
        }
        return true;
    }

    public boolean isMustExist() {
        return this.mustExist;
    }

    public void setMustExist(boolean mustExist) {
        this.mustExist = mustExist;
    }

    public String[] getExistFiles() {
        return this.existFiles;
    }

    public void setExistFiles(String[] strings) {
        this.existFiles = strings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDefaultDir() {
        if (!this.loadedDefaultDir) {
            Resources resources = this.getResources();
            BufferedReader reader = null;
            try {
                InputStream in = null;
                String os = System.getProperty("os.name");
                os = os.replace(' ', '_');
                os = os.toLowerCase();
                try {
                    in = resources.getInputStream(this.targetPanel + ".dir.".concat(os));
                }
                catch (ResourceNotFoundException resourceNotFoundException) {
                    // empty catch block
                }
                if (in == null) {
                    Platform platform = this.installData.getPlatform();
                    if (platform.isA(Platform.Name.WINDOWS)) {
                        try {
                            in = resources.getInputStream(this.targetPanel + ".dir.windows");
                        }
                        catch (ResourceNotFoundException resourceNotFoundException) {}
                    } else if (platform.isA(Platform.Name.MAC_OSX)) {
                        try {
                            in = resources.getInputStream(this.targetPanel + ".dir.mac");
                        }
                        catch (ResourceNotFoundException resourceNotFoundException) {}
                    } else {
                        try {
                            in = resources.getInputStream(this.targetPanel + ".dir.unix");
                        }
                        catch (ResourceNotFoundException resourceNotFoundException) {
                            // empty catch block
                        }
                    }
                }
                if (in == null) {
                    try {
                        in = resources.getInputStream(this.targetPanel + ".dir");
                    }
                    catch (ResourceNotFoundException platform) {
                        // empty catch block
                    }
                }
                if (in != null) {
                    String line;
                    InputStreamReader isr = new InputStreamReader(in);
                    reader = new BufferedReader(isr);
                    while ((line = reader.readLine()) != null && "".equals(line = line.trim())) {
                    }
                    this.defaultDir = line;
                    this.defaultDir = this.installData.getVariables().replace(this.defaultDir);
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e.getMessage(), e);
                this.defaultDir = null;
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        this.loadedDefaultDir = true;
    }

    public boolean isWriteable() {
        File existParent = IoHelper.existingParent((File)new File(this.pathSelectionPanel.getPath()));
        if (existParent == null) {
            return false;
        }
        if (OsVersion.IS_WINDOWS) {
            try {
                File tmpFile = File.createTempFile("izWrTe", ".tmp", existParent);
                tmpFile.deleteOnExit();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, e.toString(), e);
                return false;
            }
            return true;
        }
        return existParent.canWrite();
    }

    public String getDefaultDir() {
        if (this.defaultDir == null && !this.loadedDefaultDir) {
            this.loadDefaultDir();
        }
        return this.defaultDir;
    }

    public void setDefaultDir(String defaultDir) {
        this.defaultDir = defaultDir;
    }

    public String getTargetPanel() {
        return this.targetPanel;
    }

    public void setTargetPanel(String targetPanel) {
        this.targetPanel = targetPanel;
    }
}

