/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.userpath;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.Pack;
import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.data.Variables;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.gui.log.Log;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.gui.InstallerFrame;
import com.izforge.izpack.panels.userpath.UserPathInputPanel;
import com.izforge.izpack.panels.userpath.UserPathPanelAutomationHelper;
import java.util.logging.Logger;

public class UserPathPanel
extends UserPathInputPanel {
    private static final long serialVersionUID = 3256443616359429170L;
    private static final Logger logger = Logger.getLogger(UserPathPanel.class.getName());
    public static final String PANEL_NAME = "UserPathPanel";
    private boolean skip = false;
    public static final String PATH_VARIABLE_NAME = "UserPathPanelVariable";
    public static final String PATH_DEPENDS_PACK_NAME = "UserPathPanelDependsName";
    public static final String PATH_ELEMENT_NAME = "UserPathPanelElement";

    public UserPathPanel(Panel panel, InstallerFrame parent, GUIInstallData installData, Resources resources, Log log) {
        super(panel, PANEL_NAME, parent, installData, resources, log);
        if (this.getDefaultDir() != null) {
            installData.setVariable(PATH_VARIABLE_NAME, this.getDefaultDir());
        }
    }

    public void panelActivate() {
        this.skip = true;
        logger.fine("Looking for activation condition");
        String dependsPackName = this.installData.getVariable(PATH_DEPENDS_PACK_NAME);
        if (dependsPackName != null && !dependsPackName.isEmpty()) {
            logger.fine("Checking for pack dependency of " + dependsPackName);
            for (Pack pack : this.installData.getSelectedPacks()) {
                logger.fine("- Checking if " + pack.getName() + " equals " + dependsPackName);
                if (!pack.getName().equalsIgnoreCase(dependsPackName)) continue;
                this.skip = false;
                logger.fine("-- Found " + dependsPackName + ", panel will be shown");
                break;
            }
        } else {
            logger.fine("Not Checking for a pack dependency, panel will be shown");
            this.skip = false;
        }
        if (this.skip) {
            logger.fine("UserPathPanel will not be shown");
            this.parent.skipPanel();
            return;
        }
        super.panelActivate();
        Variables variables = this.installData.getVariables();
        String expandedPath = variables.get(PATH_VARIABLE_NAME);
        expandedPath = variables.replace(expandedPath);
        this.pathSelectionPanel.setPath(expandedPath);
    }

    @Override
    public boolean isValidated() {
        if (!super.isValidated()) {
            return false;
        }
        this.installData.setVariable(PATH_VARIABLE_NAME, this.pathSelectionPanel.getPath());
        return true;
    }

    public void createInstallationRecord(IXMLElement panelRoot) {
        if (!this.skip) {
            new UserPathPanelAutomationHelper().createInstallationRecord((InstallData)this.installData, panelRoot);
        }
    }

    public String getSummaryBody() {
        if (this.skip) {
            return null;
        }
        return this.installData.getVariable(PATH_VARIABLE_NAME);
    }
}

