/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.xinfo;

import com.izforge.izpack.api.GuiId;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.gui.IzPanelLayout;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.gui.log.Log;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.gui.InstallerFrame;
import com.izforge.izpack.installer.gui.IzPanel;
import com.izforge.izpack.installer.util.PanelHelper;
import java.awt.Font;
import java.awt.LayoutManager2;
import javax.swing.Icon;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class XInfoPanel
extends IzPanel {
    private static final long serialVersionUID = 3257009856274970416L;
    private final String panelResourceName;
    private JTextArea textArea;

    public XInfoPanel(Panel panel, InstallerFrame parent, GUIInstallData installData, Resources resources, Log log) {
        super(panel, parent, installData, (LayoutManager2)new IzPanelLayout(log), resources);
        this.panelResourceName = PanelHelper.getPanelResourceName((Panel)panel, (String)"info", (Resources)resources);
        String panelName = PanelHelper.getPanelName((Panel)panel);
        String titleMessageKey = PanelHelper.getPanelTitleMessageKey((Panel)panel, (String)"info", (InstallData)installData);
        this.add(LabelFactory.create((String)this.getString(titleMessageKey), (Icon)((Icon)parent.getIcons().get((Object)"edit")), (int)10), "nextLine");
        this.textArea = new JTextArea();
        this.textArea.setName(panelName.equals("XInfoPanel") ? GuiId.XINFO_PANEL_TEXT_AREA.id : GuiId.INFO_PANEL_TEXT_AREA.id);
        this.textArea.setCaretPosition(0);
        this.textArea.setEditable(false);
        String textAreaFont = installData.getVariable(panelName + ".font");
        if (textAreaFont != null && textAreaFont.length() > 0) {
            Font font = Font.decode(textAreaFont);
            this.textArea.setFont(font);
        }
        JScrollPane scroller = new JScrollPane(this.textArea);
        this.add(scroller, "nextLine");
        this.getLayoutHelper().completeLayout();
    }

    private String getInfoText() {
        String infoText = this.getResources().getString(this.panelResourceName, null, "Error : could not load the infoText text !");
        if (this.substituteVariables()) {
            infoText = this.installData.getVariables().replace(infoText);
        }
        return infoText;
    }

    public void panelActivate() {
        this.textArea.setText(this.getInfoText());
        this.textArea.setCaretPosition(0);
    }

    public boolean isValidated() {
        return true;
    }

    protected boolean substituteVariables() {
        return true;
    }
}

