/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.compiler;

import com.izforge.izpack.Pack;
import com.izforge.izpack.PackFile;
import com.izforge.izpack.compiler.ByteCountingOutputStream;
import com.izforge.izpack.compiler.Compiler;
import com.izforge.izpack.compiler.CompilerException;
import com.izforge.izpack.compiler.PackInfo;
import com.izforge.izpack.compiler.PackagerBase;
import com.izforge.izpack.compiler.PackagerHelper;
import com.izforge.izpack.util.FileUtil;
import com.izforge.izpack.util.JarOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Pack200;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import net.n3.nanoxml.XMLElement;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Packager
extends PackagerBase {
    private JarOutputStream primaryJarStream;

    public Packager() throws CompilerException {
        this("default");
    }

    public Packager(String string) throws CompilerException {
        this(string, -1);
    }

    public Packager(String string, int n) throws CompilerException {
        this.initPackCompressor(string, n);
    }

    @Override
    public void createInstaller(File file) throws Exception {
        String string = file.getName();
        if (string.endsWith(".jar")) {
            string = string.substring(0, string.length() - 4);
            this.baseFile = new File(file.getParentFile(), string);
        } else {
            this.baseFile = file;
        }
        this.info.setInstallerBase(this.baseFile.getName());
        this.packJarsSeparate = this.info.getWebDirURL() != null;
        this.primaryJarStream = this.getJarOutputStream(this.baseFile.getName() + ".jar");
        this.sendStart();
        this.writeInstaller();
        this.primaryJarStream.closeAlways();
        this.sendStop();
    }

    @Override
    protected void writeSkeletonInstaller() throws IOException {
        Object object;
        this.sendMsg("Copying the skeleton installer", 3);
        InputStream inputStream = Packager.class.getResourceAsStream("/lib/installer.jar");
        if (inputStream == null) {
            object = new File(Compiler.IZPACK_HOME, "lib/installer.jar");
            inputStream = new FileInputStream((File)object);
        }
        object = new ZipInputStream(inputStream);
        this.copyZip((ZipInputStream)object, this.primaryJarStream);
    }

    @Override
    protected void writeInstallerObject(String string, Object object) throws IOException {
        this.primaryJarStream.putNextEntry(new ZipEntry(string));
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(this.primaryJarStream);
        objectOutputStream.writeObject(object);
        objectOutputStream.flush();
        this.primaryJarStream.closeEntry();
    }

    @Override
    protected void writeInstallerResources() throws IOException {
        this.sendMsg("Copying " + this.installerResourceURLMap.size() + " files into installer");
        for (String string : this.installerResourceURLMap.keySet()) {
            InputStream inputStream = ((URL)this.installerResourceURLMap.get(string)).openStream();
            ZipEntry zipEntry = new ZipEntry(string);
            long l = FileUtil.getFileDateTime((URL)this.installerResourceURLMap.get(string));
            if (l != -1L) {
                zipEntry.setTime(l);
            }
            this.primaryJarStream.putNextEntry(zipEntry);
            PackagerHelper.copyStream(inputStream, this.primaryJarStream);
            this.primaryJarStream.closeEntry();
            inputStream.close();
        }
    }

    @Override
    protected void writeIncludedJars() throws IOException {
        this.sendMsg("Merging " + this.includedJarURLs.size() + " jars into installer");
        for (Object[] objectArray : this.includedJarURLs) {
            InputStream inputStream = ((URL)objectArray[0]).openStream();
            ZipInputStream zipInputStream = new ZipInputStream(inputStream);
            this.copyZip(zipInputStream, this.primaryJarStream, (List)objectArray[1]);
        }
    }

    @Override
    protected void writePacks() throws Exception {
        Closeable closeable;
        Object object;
        Object object22;
        Object object3;
        int n = this.packsList.size();
        this.sendMsg("Writing " + n + " Pack" + (n > 1 ? "s" : "") + " into installer");
        HashMap<File, Object[]> hashMap = new HashMap<File, Object[]>();
        HashMap<Integer, File> hashMap2 = new HashMap<Integer, File>();
        int n2 = 0;
        this.primaryJarStream.setEncoding("utf-8");
        int n3 = 0;
        Iterator iterator = this.packsList.iterator();
        XMLElement xMLElement = new XMLElement("packs");
        while (iterator.hasNext()) {
            Object object4;
            object3 = (PackInfo)iterator.next();
            Pack pack = ((PackInfo)object3).getPack();
            pack.nbytes = 0L;
            if (pack.id == null || pack.id.length() == 0) {
                pack.id = pack.name;
            }
            object22 = this.primaryJarStream;
            if (this.packJarsSeparate) {
                object4 = this.baseFile.getName() + ".pack-" + pack.id + ".jar";
                object22 = this.getJarOutputStream((String)object4);
            }
            object4 = object22;
            this.sendMsg("Writing Pack " + n3 + ": " + pack.name, 3);
            Object object5 = new ZipEntry("packs/pack-" + pack.id);
            if (!this.compressor.useStandardCompression()) {
                ((java.util.zip.ZipEntry)object5).setMethod(0);
                ((java.util.zip.ZipEntry)object5).setComment(this.compressor.getCompressionFormatSymbols()[0]);
                ((JarOutputStream)object22).putNextEntry((ZipEntry)object5);
                ((ZipOutputStream)object22).flush();
                object4 = this.compressor.getOutputStream((OutputStream)object22);
            } else {
                int n4 = this.compressor.getCompressionLevel();
                if (n4 >= 0 && n4 < 10) {
                    ((ZipOutputStream)object22).setLevel(n4);
                }
                ((JarOutputStream)object22).putNextEntry((ZipEntry)object5);
                ((ZipOutputStream)object22).flush();
            }
            object = new ByteCountingOutputStream((OutputStream)object4);
            closeable = new ObjectOutputStream((OutputStream)object);
            ((ObjectOutputStream)closeable).writeInt(((PackInfo)object3).getPackFiles().size());
            Iterator iterator2 = ((PackInfo)object3).getPackFiles().iterator();
            while (iterator2.hasNext()) {
                Object[] objectArray;
                boolean bl = !pack.loose;
                boolean bl2 = false;
                PackFile packFile = (PackFile)iterator2.next();
                File file = ((PackInfo)object3).getFile(packFile);
                if (file.getName().toLowerCase().endsWith(".jar") && this.info.isPack200Compression() && this.isNotSignedJar(file)) {
                    packFile.setPack200Jar(true);
                    bl2 = true;
                }
                if ((objectArray = (Object[])hashMap.get(file)) != null && !this.packJarsSeparate) {
                    packFile.setPreviousPackFileRef((String)objectArray[0], (Long)objectArray[1]);
                    bl = false;
                }
                ((ObjectOutputStream)closeable).writeObject(packFile);
                if (bl && !packFile.isDirectory()) {
                    long l = ((ByteCountingOutputStream)object).getByteCount();
                    if (bl2) {
                        hashMap2.put(n2, file);
                        ((ObjectOutputStream)closeable).writeInt(n2);
                        ++n2;
                    } else {
                        FileInputStream fileInputStream = new FileInputStream(file);
                        long l2 = PackagerHelper.copyStream(fileInputStream, (OutputStream)closeable);
                        fileInputStream.close();
                        if (l2 != packFile.length()) {
                            throw new IOException("File size mismatch when reading " + file);
                        }
                    }
                    hashMap.put(file, new Object[]{pack.id, l});
                }
                pack.nbytes += packFile.length();
            }
            ((ObjectOutputStream)closeable).writeInt(((PackInfo)object3).getParsables().size());
            iterator2 = ((PackInfo)object3).getParsables().iterator();
            while (iterator2.hasNext()) {
                ((ObjectOutputStream)closeable).writeObject(iterator2.next());
            }
            ((ObjectOutputStream)closeable).writeInt(((PackInfo)object3).getExecutables().size());
            iterator2 = ((PackInfo)object3).getExecutables().iterator();
            while (iterator2.hasNext()) {
                ((ObjectOutputStream)closeable).writeObject(iterator2.next());
            }
            ((ObjectOutputStream)closeable).writeInt(((PackInfo)object3).getUpdateChecks().size());
            iterator2 = ((PackInfo)object3).getUpdateChecks().iterator();
            while (iterator2.hasNext()) {
                ((ObjectOutputStream)closeable).writeObject(iterator2.next());
            }
            ((ObjectOutputStream)closeable).flush();
            if (!this.compressor.useStandardCompression()) {
                ((OutputStream)object4).close();
            }
            ((ZipOutputStream)object22).closeEntry();
            if (this.packJarsSeparate) {
                ((JarOutputStream)object22).closeAlways();
            }
            XMLElement xMLElement2 = new XMLElement("pack");
            xMLElement2.setAttribute("nbytes", Long.toString(pack.nbytes));
            xMLElement2.setAttribute("name", pack.name);
            if (pack.id != null) {
                xMLElement2.setAttribute("id", pack.id);
            }
            xMLElement.addChild(xMLElement2);
            ++n3;
        }
        this.primaryJarStream.putNextEntry(new ZipEntry("packs.info"));
        object3 = new ObjectOutputStream(this.primaryJarStream);
        ((ObjectOutputStream)object3).writeInt(this.packsList.size());
        for (Object object22 : this.packsList) {
            ((ObjectOutputStream)object3).writeObject(((PackInfo)object22).getPack());
        }
        ((ObjectOutputStream)object3).flush();
        this.primaryJarStream.closeEntry();
        object22 = this.createAgressivePack200Packer();
        for (Object object5 : hashMap2.keySet()) {
            object = (File)hashMap2.get(object5);
            this.primaryJarStream.putNextEntry(new ZipEntry("packs/pack200-" + object5));
            closeable = new JarFile((File)object);
            object22.pack((JarFile)closeable, (OutputStream)this.primaryJarStream);
            ((ZipFile)closeable).close();
            this.primaryJarStream.closeEntry();
        }
    }

    private Pack200.Packer createAgressivePack200Packer() {
        Pack200.Packer packer = Pack200.newPacker();
        SortedMap sortedMap = packer.properties();
        sortedMap.put("pack.effort", "9");
        sortedMap.put("pack.segment.limit", "-1");
        sortedMap.put("pack.keep.file.order", "false");
        sortedMap.put("pack.deflate.hint", "false");
        sortedMap.put("pack.modification.time", "latest");
        sortedMap.put("pack.code.attribute.LineNumberTable", "strip");
        sortedMap.put("pack.code.attribute.LocalVariableTable", "strip");
        sortedMap.put("pack.code.attribute.SourceFile", "strip");
        return packer;
    }

    private boolean isNotSignedJar(File file) throws IOException {
        JarFile jarFile = new JarFile(file);
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            if (!jarEntry.getName().startsWith("META-INF") || !jarEntry.getName().endsWith(".SF")) continue;
            jarFile.close();
            return false;
        }
        jarFile.close();
        return true;
    }

    private JarOutputStream getJarOutputStream(String string) throws IOException {
        File file = new File(this.baseFile.getParentFile(), string);
        this.sendMsg("Building installer jar: " + file.getAbsolutePath());
        JarOutputStream jarOutputStream = new JarOutputStream(file);
        jarOutputStream.setLevel(9);
        jarOutputStream.setPreventClose(true);
        return jarOutputStream;
    }

    private void copyZip(ZipInputStream zipInputStream, ZipOutputStream zipOutputStream) throws IOException {
        this.copyZip(zipInputStream, zipOutputStream, null);
    }

    private void copyZip(ZipInputStream zipInputStream, ZipOutputStream zipOutputStream, List<String> list) throws IOException {
        java.util.zip.ZipEntry zipEntry;
        if (!this.alreadyWrittenFiles.containsKey(zipOutputStream)) {
            this.alreadyWrittenFiles.put(zipOutputStream, new HashSet());
        }
        HashSet hashSet = (HashSet)this.alreadyWrittenFiles.get(zipOutputStream);
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            Object object;
            String string = zipEntry.getName();
            String string2 = string.replace('/', '.');
            string2 = string2.replace('\\', '.');
            if (list != null) {
                object = list.iterator();
                boolean bl = false;
                while (object.hasNext()) {
                    String string3 = object.next();
                    if (!string2.matches(string3)) continue;
                    bl = true;
                    break;
                }
                if (!bl) continue;
            }
            if (hashSet.contains(string)) continue;
            try {
                object = new ZipEntry(string);
                long l = zipEntry.getTime();
                if (l != -1L) {
                    ((java.util.zip.ZipEntry)object).setTime(l);
                }
                zipOutputStream.putNextEntry((ZipEntry)object);
                PackagerHelper.copyStream(zipInputStream, zipOutputStream);
                zipOutputStream.closeEntry();
                zipInputStream.closeEntry();
                hashSet.add(string);
            }
            catch (ZipException zipException) {}
        }
    }

    @Override
    public void addConfigurationInformation(XMLElement xMLElement) {
    }
}

