/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.ref.SoftReference;
import java.net.URL;
import org.codehaus.jackson.JsonEncoding;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.impl.ByteSourceBootstrapper;
import org.codehaus.jackson.impl.ReaderBasedParser;
import org.codehaus.jackson.impl.WriterBasedGenerator;
import org.codehaus.jackson.io.IOContext;
import org.codehaus.jackson.io.UTF8Writer;
import org.codehaus.jackson.sym.NameCanonicalizer;
import org.codehaus.jackson.util.BufferRecycler;
import org.codehaus.jackson.util.SymbolTable;

public final class JsonFactory {
    static final ThreadLocal<SoftReference<BufferRecycler>> mRecyclerRef = new ThreadLocal();
    private SymbolTable mCharSymbols = SymbolTable.createRoot();
    private NameCanonicalizer mByteSymbols = NameCanonicalizer.createRoot();

    public JsonParser createJsonParser(File f) throws IOException, JsonParseException {
        return this.createJsonParser(new FileInputStream(f), this.createContext(f));
    }

    public JsonParser createJsonParser(URL url) throws IOException, JsonParseException {
        return this.createJsonParser(JsonFactory.optimizedStreamFromURL(url), this.createContext(url));
    }

    public JsonParser createJsonParser(InputStream in) throws IOException, JsonParseException {
        return this.createJsonParser(in, this.createContext(in));
    }

    public JsonParser createJsonParser(Reader r) throws IOException, JsonParseException {
        return new ReaderBasedParser(this.createContext(r), r, this.mCharSymbols.makeChild());
    }

    private JsonParser createJsonParser(InputStream in, IOContext ctxt) throws IOException, JsonParseException {
        ByteSourceBootstrapper bb = new ByteSourceBootstrapper(ctxt, in);
        JsonEncoding enc = bb.detectEncoding();
        if (enc == JsonEncoding.UTF8) {
            return bb.createFastUtf8Parser(this.mByteSymbols.makeChild());
        }
        return new ReaderBasedParser(ctxt, bb.constructReader(), this.mCharSymbols.makeChild());
    }

    public JsonGenerator createJsonGenerator(OutputStream out, JsonEncoding enc) throws IOException {
        IOContext ctxt = this.createContext(out);
        ctxt.setEncoding(enc);
        if (enc == JsonEncoding.UTF8) {
            return new WriterBasedGenerator(ctxt, new UTF8Writer(ctxt, out));
        }
        return new WriterBasedGenerator(ctxt, new OutputStreamWriter(out, enc.getJavaName()));
    }

    public JsonGenerator createJsonGenerator(Writer out) throws IOException {
        IOContext ctxt = this.createContext(out);
        return new WriterBasedGenerator(ctxt, out);
    }

    public JsonGenerator createJsonGenerator(File f, JsonEncoding enc) throws IOException {
        return this.createJsonGenerator(new FileOutputStream(f), enc);
    }

    protected IOContext createContext(Object srcRef) {
        return new IOContext(this.getBufferRecycler(), srcRef);
    }

    protected BufferRecycler getBufferRecycler() {
        BufferRecycler br;
        SoftReference<BufferRecycler> ref = mRecyclerRef.get();
        BufferRecycler bufferRecycler = br = ref == null ? null : ref.get();
        if (br == null) {
            br = new BufferRecycler();
            if (ref == null) {
                mRecyclerRef.set(new SoftReference<BufferRecycler>(br));
            }
        }
        return br;
    }

    protected static InputStream optimizedStreamFromURL(URL url) throws IOException {
        if ("file".equals(url.getProtocol()) && url.getHost() == null) {
            return new FileInputStream(url.getPath());
        }
        return url.openStream();
    }
}

