/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.impl;

import java.io.IOException;
import java.math.BigDecimal;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonWriteContext;
import org.codehaus.jackson.impl.DefaultPrettyPrinter;

public abstract class JsonGeneratorBase
extends JsonGenerator {
    protected JsonWriteContext mWriteContext = JsonWriteContext.createRootContext();

    protected JsonGeneratorBase() {
    }

    public final void useDefaultPrettyPrinter() {
        this.setPrettyPrinter(new DefaultPrettyPrinter());
    }

    public void writeStartArray() throws IOException, JsonGenerationException {
        this.verifyValueWrite("start an array");
        this.mWriteContext = this.mWriteContext.createChildArrayContext();
        if (this.mPrettyPrinter != null) {
            this.mPrettyPrinter.writeStartArray(this);
        } else {
            this.doWriteStartArray();
        }
    }

    protected abstract void doWriteStartArray() throws IOException, JsonGenerationException;

    public void writeEndArray() throws IOException, JsonGenerationException {
        if (!this.mWriteContext.inArray()) {
            this.reportError("Current context not an array but " + (Object)((Object)this.mWriteContext.getType()));
        }
        if (this.mPrettyPrinter != null) {
            this.mPrettyPrinter.writeEndArray(this, this.mWriteContext.getEntryCount());
        } else {
            this.doWriteEndArray();
        }
        this.mWriteContext = this.mWriteContext.getParent();
    }

    protected abstract void doWriteEndArray() throws IOException, JsonGenerationException;

    public void writeStartObject() throws IOException, JsonGenerationException {
        this.verifyValueWrite("start an object");
        this.mWriteContext = this.mWriteContext.createChildObjectContext();
        if (this.mPrettyPrinter != null) {
            this.mPrettyPrinter.writeStartObject(this);
        } else {
            this.doWriteStartObject();
        }
    }

    protected abstract void doWriteStartObject() throws IOException, JsonGenerationException;

    public void writeEndObject() throws IOException, JsonGenerationException {
        if (!this.mWriteContext.inObject()) {
            this.reportError("Current context not an object but " + (Object)((Object)this.mWriteContext.getType()));
        }
        this.mWriteContext = this.mWriteContext.getParent();
        if (this.mPrettyPrinter != null) {
            this.mPrettyPrinter.writeEndObject(this, this.mWriteContext.getEntryCount());
        } else {
            this.doWriteEndObject();
        }
    }

    protected abstract void doWriteEndObject() throws IOException, JsonGenerationException;

    public void writeFieldName(String name) throws IOException, JsonGenerationException {
        int status = this.mWriteContext.writeFieldName(name);
        if (status == 4) {
            this.reportError("Can not write a field name, expecting a value");
        }
        this.doWriteFieldName(name, status == 1);
    }

    public abstract void doWriteFieldName(String var1, boolean var2) throws IOException, JsonGenerationException;

    public abstract void writeNumber(int var1) throws IOException, JsonGenerationException;

    public abstract void writeNumber(long var1) throws IOException, JsonGenerationException;

    public abstract void writeNumber(double var1) throws IOException, JsonGenerationException;

    public abstract void writeNumber(float var1) throws IOException, JsonGenerationException;

    public abstract void writeNumber(BigDecimal var1) throws IOException, JsonGenerationException;

    public abstract void writeBoolean(boolean var1) throws IOException, JsonGenerationException;

    public abstract void writeNull() throws IOException, JsonGenerationException;

    protected abstract void releaseBuffers();

    public abstract void flush() throws IOException;

    public abstract void close() throws IOException;

    protected abstract void verifyValueWrite(String var1) throws IOException, JsonGenerationException;

    protected void reportError(String msg) throws JsonGenerationException {
        throw new JsonGenerationException(msg);
    }
}

