/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.impl;

import java.io.IOException;
import org.codehaus.jackson.JsonLocation;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonReadContext;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.io.IOContext;
import org.codehaus.jackson.util.TextBuffer;

public abstract class JsonParserBase
extends JsonParser {
    static final int INT_TAB = 9;
    static final int INT_LF = 10;
    static final int INT_CR = 13;
    static final int INT_SPACE = 32;
    static final int INT_LBRACKET = 91;
    static final int INT_RBRACKET = 93;
    static final int INT_LCURLY = 123;
    static final int INT_RCURLY = 125;
    static final int INT_QUOTE = 34;
    static final int INT_BACKSLASH = 92;
    static final int INT_SLASH = 47;
    static final int INT_COLON = 58;
    static final int INT_b = 98;
    static final int INT_f = 102;
    static final int INT_n = 110;
    static final int INT_r = 114;
    static final int INT_t = 116;
    static final int INT_u = 117;
    protected final IOContext mIOContext;
    protected JsonToken mCurrToken;
    protected int mInputPtr = 0;
    protected int mInputLast = 0;
    protected long mCurrInputProcessed = 0L;
    protected int mCurrInputRow = 1;
    protected int mCurrInputRowStart = 0;
    protected long mTokenInputTotal = 0L;
    protected int mTokenInputRow = 1;
    protected int mTokenInputCol = 0;
    protected JsonReadContext mParsingContext;
    protected boolean mTokenIncomplete = false;
    protected final TextBuffer mTextBuffer;
    protected boolean mFieldInBuffer = false;

    protected JsonParserBase(IOContext ctxt) {
        this.mIOContext = ctxt;
        this.mTextBuffer = ctxt.constructTextBuffer();
        this.mParsingContext = JsonReadContext.createRootContext(this.mTokenInputRow, this.mTokenInputCol);
    }

    protected abstract void finishString() throws IOException, JsonParseException;

    public abstract JsonToken nextToken() throws IOException, JsonParseException;

    public void skipChildren() throws IOException, JsonParseException {
        if (this.mCurrToken != JsonToken.START_OBJECT && this.mCurrToken != JsonToken.START_ARRAY) {
            return;
        }
        int open = 1;
        while (true) {
            JsonToken t;
            if ((t = this.nextToken()) == null) {
                this.handleEOF();
            }
            switch (t) {
                case START_OBJECT: 
                case START_ARRAY: {
                    ++open;
                    break;
                }
                case END_OBJECT: 
                case END_ARRAY: {
                    if (--open != 0) break;
                    return;
                }
            }
        }
    }

    public JsonToken getCurrentToken() {
        return this.mCurrToken;
    }

    public boolean hasCurrentToken() {
        return this.mCurrToken != null;
    }

    public String getCurrentName() throws IOException, JsonParseException {
        return this.mCurrToken == JsonToken.FIELD_NAME ? this.mParsingContext.getCurrentName() : null;
    }

    public void close() throws IOException {
        this.closeInput();
        this.releaseBuffers();
    }

    public JsonReadContext getParsingContext() {
        return this.mParsingContext;
    }

    public JsonLocation getTokenLocation() {
        return new JsonLocation(this.mIOContext.getSourceReference(), this.mTokenInputTotal, this.mTokenInputRow, this.mTokenInputCol + 1);
    }

    public JsonLocation getCurrentLocation() {
        return new JsonLocation(this.mIOContext.getSourceReference(), this.mCurrInputProcessed + (long)this.mInputPtr - 1L, this.mCurrInputRow, this.mInputPtr - this.mCurrInputRowStart);
    }

    public String getText() throws IOException, JsonParseException {
        if (this.mCurrToken != null) {
            switch (this.mCurrToken) {
                case FIELD_NAME: {
                    return this.mParsingContext.getCurrentName();
                }
                case VALUE_STRING: {
                    if (this.mTokenIncomplete) {
                        this.mTokenIncomplete = false;
                        this.finishString();
                    }
                }
                case VALUE_NUMBER_INT: 
                case VALUE_NUMBER_FLOAT: {
                    return this.mTextBuffer.contentsAsString();
                }
            }
            return this.mCurrToken.asString();
        }
        return null;
    }

    public char[] getTextCharacters() throws IOException, JsonParseException {
        if (this.mCurrToken != null) {
            switch (this.mCurrToken) {
                case FIELD_NAME: {
                    if (!this.mFieldInBuffer) {
                        this.mTextBuffer.resetWithString(this.mParsingContext.getCurrentName());
                        this.mFieldInBuffer = true;
                    }
                    return this.mTextBuffer.getTextBuffer();
                }
                case VALUE_STRING: {
                    if (this.mTokenIncomplete) {
                        this.mTokenIncomplete = false;
                        this.finishString();
                    }
                }
                case VALUE_NUMBER_INT: 
                case VALUE_NUMBER_FLOAT: {
                    return this.mTextBuffer.getTextBuffer();
                }
            }
            return this.mCurrToken.asCharArray();
        }
        return null;
    }

    public int getTextLength() throws IOException, JsonParseException {
        if (this.mCurrToken != null) {
            switch (this.mCurrToken) {
                case FIELD_NAME: {
                    return this.mParsingContext.getCurrentName().length();
                }
                case VALUE_STRING: {
                    if (this.mTokenIncomplete) {
                        this.mTokenIncomplete = false;
                        this.finishString();
                    }
                }
                case VALUE_NUMBER_INT: 
                case VALUE_NUMBER_FLOAT: {
                    return this.mTextBuffer.size();
                }
            }
            return this.mCurrToken.asCharArray().length;
        }
        return 0;
    }

    public int getTextOffset() throws IOException, JsonParseException {
        if (this.mCurrToken != null) {
            switch (this.mCurrToken) {
                case FIELD_NAME: {
                    return 0;
                }
                case VALUE_STRING: {
                    if (this.mTokenIncomplete) {
                        this.mTokenIncomplete = false;
                        this.finishString();
                    }
                }
                case VALUE_NUMBER_INT: 
                case VALUE_NUMBER_FLOAT: {
                    return this.mTextBuffer.getTextOffset();
                }
            }
        }
        return 0;
    }

    public final long getTokenCharacterOffset() {
        return this.mTokenInputTotal;
    }

    public final int getTokenLineNr() {
        return this.mTokenInputRow;
    }

    public final int getTokenColumnNr() {
        return this.mTokenInputCol;
    }

    protected final void skipCR() throws IOException {
        if (this.mInputPtr < this.mInputLast || this.loadMore()) {
            ++this.mInputPtr;
        }
        ++this.mCurrInputRow;
        this.mCurrInputRowStart = this.mInputPtr;
    }

    protected final void skipLF() throws IOException {
        ++this.mCurrInputRow;
        this.mCurrInputRowStart = this.mInputPtr;
    }

    protected final void markLF() {
        ++this.mCurrInputRow;
        this.mCurrInputRowStart = this.mInputPtr;
    }

    protected final void markLF(int inputPtr) {
        ++this.mCurrInputRow;
        this.mCurrInputRowStart = inputPtr;
    }

    protected abstract boolean loadMore() throws IOException;

    protected final void loadMoreGuaranteed() throws IOException {
        if (!this.loadMore()) {
            this.reportInvalidEOF();
        }
    }

    protected abstract void closeInput() throws IOException;

    protected void releaseBuffers() throws IOException {
        this.mTextBuffer.releaseBuffers();
    }

    protected void handleEOF() throws JsonParseException {
        if (!this.mParsingContext.isRoot()) {
            this.reportInvalidEOF(": expected close marker for " + this.mParsingContext.getTypeDesc() + " (from " + this.mParsingContext.getStartLocation(this.mIOContext.getSourceReference()) + ")");
        }
    }

    protected void reportUnexpectedChar(int ch, String comment) throws JsonParseException {
        String msg = "Unexpected character (" + JsonParserBase.getCharDesc(ch) + ")";
        if (comment != null) {
            msg = msg + ": " + comment;
        }
        this.reportError(msg);
    }

    protected void reportInvalidEOF() throws JsonParseException {
        this.reportInvalidEOF(" in " + (Object)((Object)this.mCurrToken));
    }

    protected void reportInvalidEOF(String msg) throws JsonParseException {
        this.reportError("Unexpected end-of-input" + msg);
    }

    protected void throwInvalidSpace(int i) throws JsonParseException {
        char c = (char)i;
        String msg = "Illegal character (" + JsonParserBase.getCharDesc(c) + "): only regular white space (\\r, \\n, \\t) is allowed between tokens";
        this.reportError(msg);
    }

    protected void throwUnquotedSpace(int i, String ctxtDesc) throws JsonParseException {
        char c = (char)i;
        String msg = "Illegal unquoted character (" + JsonParserBase.getCharDesc(c) + "): has to be escaped using backslash to be included in " + ctxtDesc;
        this.reportError(msg);
    }

    protected void reportMismatchedEndMarker(int actCh, char expCh) throws JsonParseException {
        String startDesc = "" + this.mParsingContext.getStartLocation(this.mIOContext.getSourceReference());
        this.reportError("Unexpected close marker '" + (char)actCh + "': expected '" + expCh + "' (for " + this.mParsingContext.getTypeDesc() + " starting at " + startDesc + ")");
    }

    protected static String getCharDesc(int ch) {
        char c = (char)ch;
        if (Character.isISOControl(c)) {
            return "(CTRL-CHAR, code " + ch + ")";
        }
        if (ch > 255) {
            return "'" + c + "' (code " + ch + " / 0x" + Integer.toHexString(ch) + ")";
        }
        return "'" + c + "' (code " + ch + ")";
    }

    protected void reportError(String msg) throws JsonParseException {
        throw new JsonParseException(msg, this.getCurrentLocation());
    }

    protected void wrapError(String msg, Throwable t) throws JsonParseException {
        throw new JsonParseException(msg, this.getCurrentLocation(), t);
    }

    protected void throwInternal() {
        throw new RuntimeException("Internal error: this code path should never get executed");
    }
}

