/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.sym;

import org.codehaus.jackson.sym.Name;
import org.codehaus.jackson.sym.Name1;
import org.codehaus.jackson.sym.Name2;
import org.codehaus.jackson.sym.Name3;
import org.codehaus.jackson.sym.NameN;

public final class NameCanonicalizer {
    protected static final int DEFAULT_TABLE_SIZE = 64;
    static final int MAX_TABLE_SIZE = 6000;
    static final int MIN_HASH_SIZE = 16;
    static final int INITIAL_COLLISION_LEN = 32;
    static final int LAST_VALID_BUCKET = 254;
    final NameCanonicalizer mParent;
    private int mCount;
    private int mMainHashMask;
    private int[] mMainHash;
    private Name[] mMainNames;
    private Bucket[] mCollList;
    private int mCollCount;
    private int mCollEnd;
    private transient boolean mNeedRehash;
    private boolean mMainHashShared;
    private boolean mMainNamesShared;
    private boolean mCollListShared;

    public static NameCanonicalizer createRoot() {
        return new NameCanonicalizer(64);
    }

    public synchronized NameCanonicalizer makeChild() {
        return new NameCanonicalizer(this);
    }

    public void release() {
        if (this.maybeDirty() && this.mParent != null) {
            this.mParent.mergeChild(this);
            this.markAsShared();
        }
    }

    private NameCanonicalizer(int hashSize) {
        this.mParent = null;
        if (hashSize < 16) {
            hashSize = 16;
        } else if ((hashSize & hashSize - 1) != 0) {
            int curr;
            for (curr = 16; curr < hashSize; curr += curr) {
            }
            hashSize = curr;
        }
        this.initTables(hashSize);
    }

    private NameCanonicalizer(NameCanonicalizer parent) {
        this.mParent = parent;
        this.mCount = parent.mCount;
        this.mMainHashMask = parent.mMainHashMask;
        this.mMainHash = parent.mMainHash;
        this.mMainNames = parent.mMainNames;
        this.mCollList = parent.mCollList;
        this.mCollCount = parent.mCollCount;
        this.mCollEnd = parent.mCollEnd;
        this.mNeedRehash = false;
        this.mMainHashShared = true;
        this.mMainNamesShared = true;
        this.mCollListShared = true;
    }

    private void initTables(int hashSize) {
        this.mCount = 0;
        this.mMainHash = new int[hashSize];
        this.mMainNames = new Name[hashSize];
        this.mMainHashShared = false;
        this.mMainNamesShared = false;
        this.mMainHashMask = hashSize - 1;
        this.mCollListShared = true;
        this.mCollList = null;
        this.mCollEnd = 0;
        this.mNeedRehash = false;
    }

    private synchronized void mergeChild(NameCanonicalizer child) {
        int childCount = child.mCount;
        if (childCount <= this.mCount) {
            return;
        }
        if (child.size() > 6000) {
            this.initTables(64);
        } else {
            this.mCount = child.mCount;
            this.mMainHash = child.mMainHash;
            this.mMainNames = child.mMainNames;
            this.mMainHashShared = true;
            this.mMainNamesShared = true;
            this.mMainHashMask = child.mMainHashMask;
            this.mCollList = child.mCollList;
            this.mCollCount = child.mCollCount;
            this.mCollEnd = child.mCollEnd;
        }
    }

    private void markAsShared() {
        this.mMainHashShared = true;
        this.mMainNamesShared = true;
        this.mCollListShared = true;
    }

    public int size() {
        return this.mCount;
    }

    public boolean maybeDirty() {
        return !this.mMainHashShared;
    }

    public static Name getEmptyName() {
        return Name1.getEmptyName();
    }

    public Name findName(int firstQuad) {
        Bucket bucket;
        int hash = NameCanonicalizer.calcHash(firstQuad);
        int ix = hash & this.mMainHashMask;
        int val = this.mMainHash[ix];
        if ((val >> 8 ^ hash) << 8 == 0) {
            Name name = this.mMainNames[ix];
            if (name == null) {
                return null;
            }
            if (name.equals(firstQuad)) {
                return name;
            }
        } else if (val == 0) {
            return null;
        }
        if ((val &= 0xFF) > 0 && (bucket = this.mCollList[--val]) != null) {
            return bucket.find(hash, firstQuad, 0);
        }
        return null;
    }

    public Name findName(int firstQuad, int secondQuad) {
        Bucket bucket;
        int hash = NameCanonicalizer.calcHash(firstQuad, secondQuad);
        int ix = hash & this.mMainHashMask;
        int val = this.mMainHash[ix];
        if ((val >> 8 ^ hash) << 8 == 0) {
            Name name = this.mMainNames[ix];
            if (name == null) {
                return null;
            }
            if (name.equals(firstQuad, secondQuad)) {
                return name;
            }
        } else if (val == 0) {
            return null;
        }
        if ((val &= 0xFF) > 0 && (bucket = this.mCollList[--val]) != null) {
            return bucket.find(hash, firstQuad, secondQuad);
        }
        return null;
    }

    public Name findName(int[] quads, int qlen) {
        Bucket bucket;
        int hash = NameCanonicalizer.calcHash(quads, qlen);
        int ix = hash & this.mMainHashMask;
        int val = this.mMainHash[ix];
        if ((val >> 8 ^ hash) << 8 == 0) {
            Name name = this.mMainNames[ix];
            if (name == null || name.equals(quads, qlen)) {
                return name;
            }
        } else if (val == 0) {
            return null;
        }
        if ((val &= 0xFF) > 0 && (bucket = this.mCollList[--val]) != null) {
            return bucket.find(hash, quads, qlen);
        }
        return null;
    }

    public Name addName(String symbolStr, int[] quads, int qlen) {
        int hash = NameCanonicalizer.calcHash(quads, qlen);
        Name symbol = NameCanonicalizer.constructName(hash, symbolStr, quads, qlen);
        this.doAddSymbol(hash, symbol);
        return symbol;
    }

    public static final int calcHash(int firstQuad) {
        int hash = firstQuad;
        hash ^= hash >>> 16;
        hash ^= hash >>> 8;
        return hash;
    }

    public static final int calcHash(int firstQuad, int secondQuad) {
        int hash = firstQuad * 31 + secondQuad;
        hash ^= hash >>> 16;
        hash ^= hash >>> 8;
        return hash;
    }

    public static final int calcHash(int[] quads, int qlen) {
        int hash = quads[0];
        for (int i = 1; i < qlen; ++i) {
            hash = hash * 31 + quads[i];
        }
        hash ^= hash >>> 16;
        hash ^= hash >>> 8;
        return hash;
    }

    public static int[] calcQuads(byte[] wordBytes) {
        int blen = wordBytes.length;
        int[] result = new int[(blen + 3) / 4];
        for (int i = 0; i < blen; ++i) {
            int x = wordBytes[i] & 0xFF;
            if (++i < blen) {
                x = x << 8 | wordBytes[i] & 0xFF;
                if (++i < blen) {
                    x = x << 8 | wordBytes[i] & 0xFF;
                    if (++i < blen) {
                        x = x << 8 | wordBytes[i] & 0xFF;
                    }
                }
            }
            result[i >> 2] = x;
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[NameCanonicalizer, size: ");
        sb.append(this.mCount);
        sb.append('/');
        sb.append(this.mMainHash.length);
        sb.append(", ");
        sb.append(this.mCollCount);
        sb.append(" coll; avg length: ");
        int pathCount = this.mCount;
        for (int i = 0; i < this.mCollEnd; ++i) {
            int spillLen = this.mCollList[i].length();
            for (int j = 1; j <= spillLen; ++j) {
                pathCount += j;
            }
        }
        double avgLength = this.mCount == 0 ? 0.0 : (double)pathCount / (double)this.mCount;
        sb.append(avgLength);
        sb.append(']');
        return sb.toString();
    }

    private void doAddSymbol(int hash, Name symbol) {
        if (this.mMainHashShared) {
            this.unshareMain();
        }
        if (this.mNeedRehash) {
            this.rehash();
        }
        ++this.mCount;
        int ix = hash & this.mMainHashMask;
        if (this.mMainNames[ix] == null) {
            this.mMainHash[ix] = hash << 8;
            if (this.mMainNamesShared) {
                this.unshareNames();
            }
            this.mMainNames[ix] = symbol;
        } else {
            if (this.mCollListShared) {
                this.unshareCollision();
            }
            ++this.mCollCount;
            int entryValue = this.mMainHash[ix];
            int bucket = entryValue & 0xFF;
            if (bucket == 0) {
                if (this.mCollEnd <= 254) {
                    if ((bucket = this.mCollEnd++) >= this.mCollList.length) {
                        this.expandCollision();
                    }
                } else {
                    bucket = this.findBestBucket();
                }
                this.mMainHash[ix] = entryValue & 0xFFFFFF00 | bucket + 1;
            } else {
                --bucket;
            }
            this.mCollList[bucket] = new Bucket(symbol, this.mCollList[bucket]);
        }
        int hashSize = this.mMainHash.length;
        if (this.mCount > hashSize >> 1) {
            int hashQuarter = hashSize >> 2;
            if (this.mCount > hashSize - hashQuarter) {
                this.mNeedRehash = true;
            } else if (this.mCollCount >= hashQuarter) {
                this.mNeedRehash = true;
            }
        }
    }

    private void rehash() {
        this.mNeedRehash = false;
        this.mMainNamesShared = false;
        int symbolsSeen = 0;
        int[] oldMainHash = this.mMainHash;
        int len = oldMainHash.length;
        this.mMainHash = new int[len + len];
        this.mMainHashMask = len + len - 1;
        Name[] oldNames = this.mMainNames;
        this.mMainNames = new Name[len + len];
        for (int i = 0; i < len; ++i) {
            Name symbol = oldNames[i];
            if (symbol == null) continue;
            ++symbolsSeen;
            int hash = symbol.hashCode();
            int ix = hash & this.mMainHashMask;
            this.mMainNames[ix] = symbol;
            this.mMainHash[ix] = hash << 8;
        }
        int oldEnd = this.mCollEnd;
        if (oldEnd == 0) {
            return;
        }
        this.mCollCount = 0;
        this.mCollEnd = 0;
        this.mCollListShared = false;
        Bucket[] oldBuckets = this.mCollList;
        this.mCollList = new Bucket[oldBuckets.length];
        for (int i = 0; i < oldEnd; ++i) {
            Bucket curr = oldBuckets[i];
            while (curr != null) {
                ++symbolsSeen;
                Name symbol = curr.mName;
                int hash = symbol.hashCode();
                int ix = hash & this.mMainHashMask;
                int val = this.mMainHash[ix];
                if (this.mMainNames[ix] == null) {
                    this.mMainHash[ix] = hash << 8;
                    this.mMainNames[ix] = symbol;
                } else {
                    ++this.mCollCount;
                    int bucket = val & 0xFF;
                    if (bucket == 0) {
                        if (this.mCollEnd <= 254) {
                            if ((bucket = this.mCollEnd++) >= this.mCollList.length) {
                                this.expandCollision();
                            }
                        } else {
                            bucket = this.findBestBucket();
                        }
                        this.mMainHash[ix] = val & 0xFFFFFF00 | bucket + 1;
                    } else {
                        --bucket;
                    }
                    this.mCollList[bucket] = new Bucket(symbol, this.mCollList[bucket]);
                }
                curr = curr.mNext;
            }
        }
        if (symbolsSeen != this.mCount) {
            throw new RuntimeException("Internal error: count after rehash " + symbolsSeen + "; should be " + this.mCount);
        }
    }

    private int findBestBucket() {
        Bucket[] buckets = this.mCollList;
        int bestCount = Integer.MAX_VALUE;
        int bestIx = -1;
        int len = this.mCollEnd;
        for (int i = 0; i < len; ++i) {
            int count = buckets[i].length();
            if (count >= bestCount) continue;
            if (count == 1) {
                return i;
            }
            bestCount = count;
            bestIx = i;
        }
        return bestIx;
    }

    private void unshareMain() {
        int[] old = this.mMainHash;
        int len = this.mMainHash.length;
        this.mMainHash = new int[len];
        System.arraycopy(old, 0, this.mMainHash, 0, len);
        this.mMainHashShared = false;
    }

    private void unshareCollision() {
        Bucket[] old = this.mCollList;
        if (old == null) {
            this.mCollList = new Bucket[32];
        } else {
            int len = old.length;
            this.mCollList = new Bucket[len];
            System.arraycopy(old, 0, this.mCollList, 0, len);
        }
        this.mCollListShared = false;
    }

    private void unshareNames() {
        Name[] old = this.mMainNames;
        int len = old.length;
        this.mMainNames = new Name[len];
        System.arraycopy(old, 0, this.mMainNames, 0, len);
        this.mMainNamesShared = false;
    }

    private void expandCollision() {
        Bucket[] old = this.mCollList;
        int len = old.length;
        this.mCollList = new Bucket[len + len];
        System.arraycopy(old, 0, this.mCollList, 0, len);
    }

    public static Name constructName(int hash, String name, int q1, int q2) {
        name = name.intern();
        if (q2 == 0) {
            return new Name1(name, hash, q1);
        }
        return new Name2(name, hash, q1, q2);
    }

    public static Name constructName(int hash, String name, int[] quads, int qlen) {
        name = name.intern();
        if (qlen < 4) {
            switch (qlen) {
                case 1: {
                    return new Name1(name, hash, quads[0]);
                }
                case 2: {
                    return new Name2(name, hash, quads[0], quads[1]);
                }
                case 3: {
                    return new Name3(name, hash, quads[0], quads[1], quads[2]);
                }
            }
        }
        int[] buf = new int[qlen];
        for (int i = 0; i < qlen; ++i) {
            buf[i] = quads[i];
        }
        return new NameN(name, hash, buf, qlen);
    }

    static final class Bucket {
        final Name mName;
        final Bucket mNext;

        Bucket(Name name, Bucket next) {
            this.mName = name;
            this.mNext = next;
        }

        public int length() {
            int len = 1;
            Bucket curr = this.mNext;
            while (curr != null) {
                ++len;
                curr = curr.mNext;
            }
            return len;
        }

        public Name find(int hash, int firstQuad, int secondQuad) {
            if (this.mName.hashCode() == hash && this.mName.equals(firstQuad, secondQuad)) {
                return this.mName;
            }
            Bucket curr = this.mNext;
            while (curr != null) {
                Name currName = curr.mName;
                if (currName.hashCode() == hash && currName.equals(firstQuad, secondQuad)) {
                    return currName;
                }
                curr = curr.mNext;
            }
            return null;
        }

        public Name find(int hash, int[] quads, int qlen) {
            if (this.mName.hashCode() == hash && this.mName.equals(quads, qlen)) {
                return this.mName;
            }
            Bucket curr = this.mNext;
            while (curr != null) {
                Name currName = curr.mName;
                if (currName.hashCode() == hash && currName.equals(quads, qlen)) {
                    return currName;
                }
                curr = curr.mNext;
            }
            return null;
        }
    }
}

