/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.node;

import java.io.IOException;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.node.ValueNode;
import org.codehaus.jackson.util.CharTypes;

public final class TextNode
extends ValueNode {
    static final TextNode EMPTY_STRING_NODE = new TextNode("");
    final String mValue;

    public TextNode(String v) {
        this.mValue = v;
    }

    public static TextNode valueOf(String v) {
        if (v == null) {
            return null;
        }
        if (v.length() == 0) {
            return EMPTY_STRING_NODE;
        }
        return new TextNode(v);
    }

    public boolean isTextual() {
        return true;
    }

    public String getTextValue() {
        return this.mValue;
    }

    public String getValueAsText() {
        return this.mValue;
    }

    public void writeTo(JsonGenerator jg) throws IOException, JsonGenerationException {
        jg.writeString(this.mValue);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        return ((TextNode)o).mValue == this.mValue;
    }

    public int hashCode() {
        return this.mValue.hashCode();
    }

    public String toString() {
        int len = this.mValue.length();
        len = len + 2 + (len >> 4);
        StringBuilder sb = new StringBuilder(len);
        TextNode.appendQuoted(sb, this.mValue);
        return sb.toString();
    }

    protected static void appendQuoted(StringBuilder sb, String content) {
        sb.append('\"');
        CharTypes.appendQuoted((StringBuilder)sb, (String)content);
        sb.append('\"');
    }
}

