/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.type;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.jackson.map.type.ArrayType;
import org.codehaus.jackson.map.type.CollectionType;
import org.codehaus.jackson.map.type.JavaType;
import org.codehaus.jackson.map.type.MapType;
import org.codehaus.jackson.map.type.SimpleType;
import org.codehaus.jackson.map.type.TypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeFactory {
    public static final TypeFactory instance = new TypeFactory();
    protected final HashMap<String, JavaType> _commonTypeCache = new HashMap();

    public TypeFactory() {
        SimpleType.addCommonTypes(this._commonTypeCache);
        ArrayType.addCommonTypes(this._commonTypeCache);
    }

    public JavaType fromClass(Class<?> clz) {
        String clzName = clz.getName();
        JavaType type = this._commonTypeCache.get(clzName);
        if (type != null) {
            return type;
        }
        if (clz.isArray()) {
            return ArrayType.construct(this.fromClass(clz.getComponentType()));
        }
        if (Map.class.isAssignableFrom(clz)) {
            JavaType unknownType = this.fromClass(Object.class);
            return MapType.untyped(clz, unknownType, unknownType);
        }
        if (Collection.class.isAssignableFrom(clz)) {
            JavaType unknownType = this.fromClass(Object.class);
            return CollectionType.untyped(clz, unknownType);
        }
        return SimpleType.construct(clz);
    }

    public JavaType fromTypeReference(TypeReference<?> ref) {
        return this.fromType(ref.getType());
    }

    public JavaType fromType(Type type) {
        if (type instanceof Class) {
            return this.fromClass((Class)type);
        }
        if (type instanceof ParameterizedType) {
            return this.fromParamType((ParameterizedType)type);
        }
        if (type instanceof GenericArrayType) {
            return this.fromArrayType((GenericArrayType)type);
        }
        if (type instanceof TypeVariable) {
            return this.fromVariable((TypeVariable)type);
        }
        if (type instanceof WildcardType) {
            return this.fromWildcard((WildcardType)type);
        }
        throw new IllegalArgumentException("Unrecognized Type: " + type.toString());
    }

    protected JavaType fromParamType(ParameterizedType type) {
        Class rawType = (Class)type.getRawType();
        if (Map.class.isAssignableFrom(rawType)) {
            Type[] args = type.getActualTypeArguments();
            return MapType.typed(rawType, this.fromType(args[0]), this.fromType(args[1]));
        }
        if (Collection.class.isAssignableFrom(rawType)) {
            return CollectionType.typed(rawType, this.fromType(type.getActualTypeArguments()[0]));
        }
        return this.fromClass(rawType);
    }

    protected JavaType fromArrayType(GenericArrayType type) {
        JavaType compType = this.fromType(type.getGenericComponentType());
        return ArrayType.construct(compType);
    }

    protected JavaType fromVariable(TypeVariable<?> type) {
        return this.fromType(type.getBounds()[0]);
    }

    protected JavaType fromWildcard(WildcardType type) {
        return this.fromType(type.getUpperBounds()[0]);
    }
}

