/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.ser;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.SerializerProvider;
import org.codehaus.jackson.map.ser.SerializerBase;
import org.codehaus.jackson.map.type.ArrayType;
import org.codehaus.jackson.map.type.TypeFactory;
import org.codehaus.jackson.node.ObjectNode;
import org.codehaus.jackson.schema.JsonSchema;
import org.codehaus.jackson.schema.SchemaAware;
import org.codehaus.jackson.type.JavaType;

public final class ArraySerializers {
    private ArraySerializers() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DoubleArraySerializer
    extends SerializerBase<double[]> {
        @Override
        public void serialize(double[] value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            jgen.writeStartArray();
            int len = value.length;
            for (int i = 0; i < len; ++i) {
                jgen.writeNumber(value[i]);
            }
            jgen.writeEndArray();
        }

        @Override
        public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
            ObjectNode o = this.createSchemaNode("array", true);
            o.put("items", this.createSchemaNode("number"));
            return o;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class FloatArraySerializer
    extends SerializerBase<float[]> {
        @Override
        public void serialize(float[] value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            jgen.writeStartArray();
            int len = value.length;
            for (int i = 0; i < len; ++i) {
                jgen.writeNumber(value[i]);
            }
            jgen.writeEndArray();
        }

        @Override
        public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
            ObjectNode o = this.createSchemaNode("array", true);
            o.put("items", this.createSchemaNode("number"));
            return o;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class LongArraySerializer
    extends SerializerBase<long[]> {
        @Override
        public void serialize(long[] value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            jgen.writeStartArray();
            int len = value.length;
            for (int i = 0; i < len; ++i) {
                jgen.writeNumber(value[i]);
            }
            jgen.writeEndArray();
        }

        @Override
        public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
            ObjectNode o = this.createSchemaNode("array", true);
            o.put("items", this.createSchemaNode("number", true));
            return o;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class IntArraySerializer
    extends SerializerBase<int[]> {
        @Override
        public void serialize(int[] value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            jgen.writeStartArray();
            int len = value.length;
            for (int i = 0; i < len; ++i) {
                jgen.writeNumber(value[i]);
            }
            jgen.writeEndArray();
        }

        @Override
        public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
            ObjectNode o = this.createSchemaNode("array", true);
            o.put("items", this.createSchemaNode("integer"));
            return o;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class CharArraySerializer
    extends SerializerBase<char[]> {
        @Override
        public void serialize(char[] value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            jgen.writeString(value, 0, value.length);
        }

        @Override
        public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
            ObjectNode o = this.createSchemaNode("array", true);
            ObjectNode itemSchema = this.createSchemaNode("string");
            itemSchema.put("type", "string");
            o.put("items", itemSchema);
            return o;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ShortArraySerializer
    extends SerializerBase<short[]> {
        @Override
        public void serialize(short[] value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            jgen.writeStartArray();
            int len = value.length;
            for (int i = 0; i < len; ++i) {
                jgen.writeNumber((int)value[i]);
            }
            jgen.writeEndArray();
        }

        @Override
        public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
            ObjectNode o = this.createSchemaNode("array", true);
            o.put("items", this.createSchemaNode("integer"));
            return o;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ByteArraySerializer
    extends SerializerBase<byte[]> {
        @Override
        public void serialize(byte[] value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            jgen.writeBinary(value);
        }

        @Override
        public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
            ObjectNode o = this.createSchemaNode("array", true);
            ObjectNode itemSchema = this.createSchemaNode("string");
            o.put("items", itemSchema);
            return o;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class BooleanArraySerializer
    extends SerializerBase<boolean[]> {
        @Override
        public void serialize(boolean[] value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            jgen.writeStartArray();
            int len = value.length;
            for (int i = 0; i < len; ++i) {
                jgen.writeBoolean(value[i]);
            }
            jgen.writeEndArray();
        }

        @Override
        public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
            ObjectNode o = this.createSchemaNode("array", true);
            o.put("items", this.createSchemaNode("boolean"));
            return o;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class StringArraySerializer
    extends SerializerBase<String[]> {
        @Override
        public void serialize(String[] value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            jgen.writeStartArray();
            int len = value.length;
            if (len > 0) {
                for (int i = 0; i < len; ++i) {
                    String str = value[i];
                    if (str == null) {
                        jgen.writeNull();
                        continue;
                    }
                    jgen.writeString(value[i]);
                }
            }
            jgen.writeEndArray();
        }

        @Override
        public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
            ObjectNode o = this.createSchemaNode("array", true);
            o.put("items", this.createSchemaNode("string"));
            return o;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ObjectArraySerializer
    extends SerializerBase<Object[]> {
        public static final ObjectArraySerializer instance = new ObjectArraySerializer();

        @Override
        public void serialize(Object[] value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            jgen.writeStartArray();
            int len = value.length;
            if (len > 0) {
                JsonSerializer<Object> prevSerializer = null;
                Class<?> prevClass = null;
                for (int i = 0; i < len; ++i) {
                    JsonSerializer<Object> currSerializer;
                    Object elem = value[i];
                    if (elem == null) {
                        provider.getNullValueSerializer().serialize(null, jgen, provider);
                        continue;
                    }
                    Class<?> cc = elem.getClass();
                    if (cc == prevClass) {
                        currSerializer = prevSerializer;
                    } else {
                        prevSerializer = currSerializer = provider.findValueSerializer(cc);
                        prevClass = cc;
                    }
                    try {
                        currSerializer.serialize(elem, jgen, provider);
                        continue;
                    }
                    catch (IOException ioe) {
                        throw ioe;
                    }
                    catch (Exception e) {
                        Throwable t = e;
                        while (t instanceof InvocationTargetException && t.getCause() != null) {
                            t = t.getCause();
                        }
                        if (t instanceof Error) {
                            throw (Error)t;
                        }
                        throw JsonMappingException.wrapWithPath(t, elem, i);
                    }
                }
            }
            jgen.writeEndArray();
        }

        @Override
        public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
            JavaType javaType;
            ObjectNode o = this.createSchemaNode("array", true);
            if (typeHint != null && (javaType = TypeFactory.type(typeHint)).isArrayType()) {
                Class componentType = ((ArrayType)javaType).getContentType().getRawClass();
                JsonSerializer<Object> ser = provider.findValueSerializer(componentType);
                JsonNode schemaNode = ser instanceof SchemaAware ? ((SchemaAware)((Object)ser)).getSchema(provider, null) : JsonSchema.getDefaultSchemaNode();
                o.put("items", schemaNode);
            }
            return o;
        }
    }
}

