/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.commons.compiler.jdk;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import org.codehaus.commons.compiler.Cookable;

final class FileInputJavaFileManager
extends ForwardingJavaFileManager<JavaFileManager> {
    private final JavaFileManager.Location location;
    private final JavaFileObject.Kind kind;
    private final File[] path;
    private final String optionalCharacterEncoding;

    FileInputJavaFileManager(JavaFileManager delegate, JavaFileManager.Location location, JavaFileObject.Kind kind, File[] path, String optionalCharacterEncoding) {
        super(delegate);
        this.location = location;
        this.kind = kind;
        this.path = path;
        this.optionalCharacterEncoding = optionalCharacterEncoding;
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        if (location == this.location && kinds.contains((Object)this.kind)) {
            ArrayList<JavaFileObject> result = new ArrayList<JavaFileObject>();
            String rel = packageName.replace('.', File.separatorChar);
            for (File directory : this.path) {
                File packageDirectory = new File(directory, rel);
                result.addAll(this.list(packageDirectory, packageName.isEmpty() ? "" : packageName + ".", this.kind, recurse));
            }
            return result;
        }
        return super.list(location, packageName, kinds, recurse);
    }

    private Collection<JavaFileObject> list(File directory, String qualification, JavaFileObject.Kind kind, boolean recurse) throws IOException {
        if (!directory.isDirectory()) {
            return Collections.emptyList();
        }
        ArrayList<JavaFileObject> result = new ArrayList<JavaFileObject>();
        for (String name : directory.list()) {
            File file = new File(directory, name);
            if (name.endsWith(kind.extension)) {
                result.add(new InputFileJavaFileObject(file, qualification + name.substring(0, name.length() - kind.extension.length())));
                continue;
            }
            if (!recurse || !file.isDirectory()) continue;
            result.addAll(this.list(file, qualification + name + ".", kind, true));
        }
        return result;
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
        if (location == this.location) {
            return ((InputFileJavaFileObject)file).getBinaryName();
        }
        return super.inferBinaryName(location, file);
    }

    @Override
    public boolean hasLocation(JavaFileManager.Location location) {
        return location == this.location || super.hasLocation(location);
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
        if (location == this.location && kind == this.kind) {
            File f;
            block3: {
                String rel = className.replace('.', File.separatorChar) + kind.extension;
                for (File sourceDirectory : this.path) {
                    f = new File(sourceDirectory, rel);
                    if (!f.exists()) {
                        continue;
                    }
                    break block3;
                }
                return null;
            }
            File sourceFile = f.getCanonicalFile();
            return new InputFileJavaFileObject(sourceFile, className);
        }
        return super.getJavaFileForInput(location, className, kind);
    }

    private class InputFileJavaFileObject
    extends SimpleJavaFileObject {
        private final File file;
        private final String binaryName;

        public InputFileJavaFileObject(File file, String binaryName) {
            super(file.toURI(), FileInputJavaFileManager.this.kind);
            this.file = file;
            this.binaryName = binaryName;
        }

        @Override
        public Reader openReader(boolean ignoreEncodingErrors) throws IOException {
            return FileInputJavaFileManager.this.optionalCharacterEncoding == null ? new FileReader(this.file) : new InputStreamReader((InputStream)new FileInputStream(this.file), FileInputJavaFileManager.this.optionalCharacterEncoding);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
            Reader r = this.openReader(true);
            try {
                String string = Cookable.readString((Reader)r);
                return string;
            }
            finally {
                r.close();
            }
        }

        String getBinaryName() {
            return this.binaryName;
        }
    }
}

