/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.commons.compiler.jdk;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import org.codehaus.commons.compiler.AbstractCompiler;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.commons.compiler.jdk.JavaSourceClassLoader;
import org.codehaus.commons.compiler.jdk.ResourceFinderInputJavaFileManager;
import org.codehaus.commons.compiler.util.reflect.ApiLog;
import org.codehaus.commons.compiler.util.resource.Resource;
import org.codehaus.commons.compiler.util.resource.ResourceCreator;
import org.codehaus.commons.nullanalysis.NotNullByDefault;
import org.codehaus.commons.nullanalysis.Nullable;

public class Compiler
extends AbstractCompiler {
    private static final JavaCompiler SYSTEM_JAVA_COMPILER = Compiler.getSystemJavaCompiler();
    private Collection<String> compilerOptions = new ArrayList<String>();
    @Nullable
    private ResourceFinderInputJavaFileManager fileManagerEnn;

    public void setVerbose(boolean verbose) {
    }

    public void setCompilerOptions(String[] compilerOptions) {
        this.compilerOptions = Arrays.asList(compilerOptions);
    }

    public void compile(Resource[] sourceResources) throws CompileException, IOException {
        ArrayList<ResourceFinderInputJavaFileManager.ResourceJavaFileObject> sourceFileObjects = new ArrayList<ResourceFinderInputJavaFileManager.ResourceJavaFileObject>();
        for (int i = 0; i < sourceResources.length; ++i) {
            Resource sourceResource = sourceResources[i];
            String fn = sourceResource.getFileName();
            String className = fn.substring(fn.lastIndexOf(File.separatorChar) + 1, fn.length() - 5).replace('/', '.');
            ResourceFinderInputJavaFileManager resourceFinderInputJavaFileManager = this.getJavaFileManager();
            resourceFinderInputJavaFileManager.getClass();
            sourceFileObjects.add(resourceFinderInputJavaFileManager.new ResourceFinderInputJavaFileManager.ResourceJavaFileObject(sourceResource, className, JavaFileObject.Kind.SOURCE));
        }
        ArrayList<String> options = new ArrayList<String>(this.compilerOptions);
        ArrayList<String> l = new ArrayList<String>();
        if (this.debugLines) {
            l.add("lines");
        }
        if (this.debugSource) {
            l.add("source");
        }
        if (this.debugVars) {
            l.add("vars");
        }
        if (l.isEmpty()) {
            l.add("none");
        }
        Iterator it = l.iterator();
        String o = "-g:" + (String)it.next();
        while (it.hasNext()) {
            o = o + "," + (String)it.next();
        }
        options.add(o);
        JavaFileManager fileManager = this.getJavaFileManager();
        fileManager = (JavaFileManager)ApiLog.logMethodInvocations((Object)fileManager);
        try {
            if (!SYSTEM_JAVA_COMPILER.getTask(null, fileManager, (DiagnosticListener<? super JavaFileObject>)new DiagnosticListener<JavaFileObject>(){

                @Override
                public void report(@Nullable Diagnostic<? extends JavaFileObject> diagnostic) {
                    assert (diagnostic != null);
                    if (diagnostic.getKind() == Diagnostic.Kind.ERROR) {
                        throw new JavaSourceClassLoader.DiagnosticException(diagnostic);
                    }
                }
            }, options, null, sourceFileObjects).call().booleanValue()) {
                throw new CompileException("Compilation failed", null);
            }
        }
        catch (RuntimeException re) {
            Throwable cause = re.getCause();
            if (cause instanceof JavaSourceClassLoader.DiagnosticException) {
                CompileException ce = new CompileException(((JavaSourceClassLoader.DiagnosticException)cause).getMessage(), null);
                ce.initCause((Throwable)re);
                throw ce;
            }
            throw re;
        }
    }

    private static JavaCompiler getSystemJavaCompiler() {
        JavaCompiler c = ToolProvider.getSystemJavaCompiler();
        if (c == null) {
            throw new UnsupportedOperationException("JDK Java compiler not available - probably you're running a JRE, not a JDK");
        }
        return c;
    }

    private ResourceFinderInputJavaFileManager getJavaFileManager() {
        if (this.fileManagerEnn != null) {
            return this.fileManagerEnn;
        }
        this.fileManagerEnn = this.getJavaFileManager2();
        return this.fileManagerEnn;
    }

    private ResourceFinderInputJavaFileManager getJavaFileManager2() {
        JavaFileManager jfm = SYSTEM_JAVA_COMPILER.getStandardFileManager(null, null, null);
        jfm = new ResourceCreatorJavaFileManager<StandardJavaFileManager>(JavaFileObject.Kind.CLASS, this.classFileCreator, (StandardJavaFileManager)jfm);
        jfm = new ResourceFinderInputJavaFileManager(jfm, StandardLocation.CLASS_PATH, JavaFileObject.Kind.CLASS, this.classFileFinder, this.encoding);
        this.fileManagerEnn = new ResourceFinderInputJavaFileManager(jfm, StandardLocation.SOURCE_PATH, JavaFileObject.Kind.SOURCE, this.sourceFinder, this.encoding);
        return this.fileManagerEnn;
    }

    private static final class ResourceCreatorJavaFileManager<T extends JavaFileManager>
    extends ForwardingJavaFileManager<T> {
        private final JavaFileObject.Kind kind;
        private final ResourceCreator resourceCreator;

        ResourceCreatorJavaFileManager(JavaFileObject.Kind kind, ResourceCreator resourceCreator, T delegate) {
            super(delegate);
            this.kind = kind;
            this.resourceCreator = resourceCreator;
        }

        @Override
        @NotNullByDefault(value=false)
        public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, final String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
            if (kind != this.kind) {
                return super.getJavaFileForOutput(location, className, kind, sibling);
            }
            return new SimpleJavaFileObject(URI.create("bytearray:///" + className.replace('.', '/') + kind.extension), kind){

                @Override
                public OutputStream openOutputStream() throws IOException {
                    return ResourceCreatorJavaFileManager.this.resourceCreator.createResource(className.replace('.', '/') + ".class");
                }
            };
        }
    }
}

