/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.modello.plugin.jackson;

import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.codehaus.modello.ModelloException;
import org.codehaus.modello.model.Model;
import org.codehaus.modello.model.ModelAssociation;
import org.codehaus.modello.model.ModelClass;
import org.codehaus.modello.model.ModelField;
import org.codehaus.modello.plugin.ModelloGenerator;
import org.codehaus.modello.plugin.jackson.AbstractJacksonGenerator;
import org.codehaus.modello.plugin.java.javasource.JClass;
import org.codehaus.modello.plugin.java.javasource.JConstructor;
import org.codehaus.modello.plugin.java.javasource.JField;
import org.codehaus.modello.plugin.java.javasource.JMethod;
import org.codehaus.modello.plugin.java.javasource.JParameter;
import org.codehaus.modello.plugin.java.javasource.JSourceCode;
import org.codehaus.modello.plugin.java.javasource.JSourceWriter;
import org.codehaus.modello.plugin.java.javasource.JStructure;
import org.codehaus.modello.plugin.java.javasource.JType;
import org.codehaus.modello.plugin.java.metadata.JavaClassMetadata;
import org.codehaus.modello.plugin.java.metadata.JavaFieldMetadata;
import org.codehaus.modello.plugin.model.ModelClassMetadata;
import org.codehaus.modello.plugins.xml.metadata.XmlAssociationMetadata;
import org.codehaus.modello.plugins.xml.metadata.XmlClassMetadata;
import org.codehaus.modello.plugins.xml.metadata.XmlFieldMetadata;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.util.StringUtils;

@Component(role=ModelloGenerator.class, hint="jackson-reader")
public class JacksonReaderGenerator
extends AbstractJacksonGenerator {
    private static final String SOURCE_PARAM = "source";
    private static final String LOCATION_VAR = "_location";
    private boolean requiresDomSupport;
    private ModelClass locationTracker;
    private String locationField;
    private ModelClass sourceTracker;
    private String trackingArgs;

    protected boolean isLocationTracking() {
        return false;
    }

    public void generate(Model model, Properties parameters) throws ModelloException {
        this.initialize(model, parameters);
        this.requiresDomSupport = false;
        this.sourceTracker = null;
        this.locationTracker = null;
        this.locationField = "";
        this.trackingArgs = "";
        if (this.isLocationTracking()) {
            this.locationTracker = model.getLocationTracker(this.getGeneratedVersion());
            if (this.locationTracker == null) {
                throw new ModelloException("No model class has been marked as location tracker via the attribute locationTracker=\"locations\", cannot generate extended reader.");
            }
            this.locationField = ((ModelClassMetadata)this.locationTracker.getMetadata(ModelClassMetadata.ID)).getLocationTracker();
            this.sourceTracker = model.getSourceTracker(this.getGeneratedVersion());
            if (this.sourceTracker != null) {
                this.trackingArgs = this.trackingArgs + ", source";
            }
        }
        try {
            this.generateJacksonReader();
        }
        catch (IOException ex) {
            throw new ModelloException("Exception while generating Jackson Reader.", (Throwable)ex);
        }
    }

    private void writeAllClassesReaders(Model objectModel, JClass jClass) {
        ModelClass root = objectModel.getClass(objectModel.getRoot(this.getGeneratedVersion()), this.getGeneratedVersion());
        for (ModelClass clazz : this.getClasses(objectModel)) {
            if (this.isTrackingSupport(clazz)) continue;
            this.writeClassReaders(clazz, jClass, root.getName().equals(clazz.getName()));
        }
    }

    private void writeClassReaders(ModelClass modelClass, JClass jClass, boolean rootElement) {
        JavaClassMetadata javaClassMetadata = (JavaClassMetadata)modelClass.getMetadata(JavaClassMetadata.class.getName());
        if (javaClassMetadata.isAbstract()) {
            return;
        }
        XmlClassMetadata xmlClassMetadata = (XmlClassMetadata)modelClass.getMetadata(XmlClassMetadata.ID);
        if (!rootElement && !xmlClassMetadata.isStandaloneRead()) {
            return;
        }
        String className = modelClass.getName();
        String capClassName = this.capitalise(className);
        String readerMethodName = "read";
        if (!rootElement) {
            readerMethodName = readerMethodName + capClassName;
        }
        JMethod unmarshall = new JMethod(readerMethodName, (JType)new JClass(className), null);
        unmarshall.getModifiers().makePrivate();
        unmarshall.addParameter(new JParameter((JType)new JClass("JsonParser"), "parser"));
        unmarshall.addParameter(new JParameter(JClass.BOOLEAN, "strict"));
        this.addTrackingParameters(unmarshall);
        unmarshall.addException(new JClass("IOException"));
        JSourceCode sc = unmarshall.getSourceCode();
        String variableName = JacksonReaderGenerator.uncapitalise((String)className);
        sc.add(className + ' ' + variableName + " = parse" + capClassName + "( parser, strict" + this.trackingArgs + " );");
        if (rootElement) {
            // empty if block
        }
        sc.add("return " + variableName + ';');
        jClass.addMethod(unmarshall);
        unmarshall = new JMethod(readerMethodName, (JType)new JClass(className), null);
        unmarshall.addParameter(new JParameter((JType)new JClass("Reader"), "reader"));
        unmarshall.addParameter(new JParameter(JClass.BOOLEAN, "strict"));
        this.addTrackingParameters(unmarshall);
        unmarshall.addException(new JClass("IOException"));
        sc = unmarshall.getSourceCode();
        sc.add("JsonParser parser = factory.createParser( reader );");
        sc.add("return " + readerMethodName + "( parser, strict );");
        jClass.addMethod(unmarshall);
        unmarshall = new JMethod(readerMethodName, (JType)new JClass(className), null);
        unmarshall.addParameter(new JParameter((JType)new JClass("Reader"), "reader"));
        unmarshall.addException(new JClass("IOException"));
        sc = unmarshall.getSourceCode();
        sc.add("return " + readerMethodName + "( reader, true );");
        jClass.addMethod(unmarshall);
        unmarshall = new JMethod(readerMethodName, (JType)new JClass(className), null);
        unmarshall.addParameter(new JParameter((JType)new JClass("InputStream"), "in"));
        unmarshall.addParameter(new JParameter(JClass.BOOLEAN, "strict"));
        this.addTrackingParameters(unmarshall);
        unmarshall.addException(new JClass("IOException"));
        sc = unmarshall.getSourceCode();
        sc.add("return " + readerMethodName + "( new InputStreamReader( in ), strict" + this.trackingArgs + " );");
        jClass.addMethod(unmarshall);
        unmarshall = new JMethod(readerMethodName, (JType)new JClass(className), null);
        unmarshall.addParameter(new JParameter((JType)new JClass("InputStream"), "in"));
        unmarshall.addException(new JClass("IOException"));
        sc = unmarshall.getSourceCode();
        sc.add("return " + readerMethodName + "( in, true );");
        jClass.addMethod(unmarshall);
    }

    private void generateJacksonReader() throws ModelloException, IOException {
        Model objectModel = this.getModel();
        String packageName = objectModel.getDefaultPackageName(this.isPackageWithVersion(), this.getGeneratedVersion()) + ".io.jackson";
        String unmarshallerName = this.getFileName("JacksonReader" + (this.isLocationTracking() ? "Ex" : ""));
        JSourceWriter sourceWriter = this.newJSourceWriter(packageName, unmarshallerName);
        JClass jClass = new JClass(packageName + '.' + unmarshallerName);
        this.initHeader(jClass);
        this.suppressAllWarnings(objectModel, (JStructure)jClass);
        jClass.addImport("com.fasterxml.jackson.core.JsonFactory");
        jClass.addImport("com.fasterxml.jackson.core.JsonParser");
        jClass.addImport("com.fasterxml.jackson.core.JsonParser.Feature");
        jClass.addImport("com.fasterxml.jackson.core.JsonParseException");
        jClass.addImport("com.fasterxml.jackson.core.JsonToken");
        jClass.addImport("java.io.InputStream");
        jClass.addImport("java.io.InputStreamReader");
        jClass.addImport("java.io.IOException");
        jClass.addImport("java.io.Reader");
        jClass.addImport("java.text.DateFormat");
        jClass.addImport("java.util.Set");
        jClass.addImport("java.util.HashSet");
        this.addModelImports(jClass, null);
        JField factoryField = new JField((JType)new JClass("JsonFactory"), "factory");
        factoryField.getModifiers().setFinal(true);
        factoryField.setInitString("new JsonFactory()");
        jClass.addField(factoryField);
        JConstructor jacksonReaderConstructor = new JConstructor(jClass);
        JSourceCode sc = jacksonReaderConstructor.getSourceCode();
        sc.add("factory.enable( Feature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER  );");
        sc.add("factory.enable( Feature.ALLOW_COMMENTS );");
        sc.add("factory.enable( Feature.ALLOW_NON_NUMERIC_NUMBERS );");
        sc.add("factory.enable( Feature.ALLOW_NUMERIC_LEADING_ZEROS );");
        sc.add("factory.enable( Feature.ALLOW_SINGLE_QUOTES );");
        sc.add("factory.enable( Feature.ALLOW_UNQUOTED_CONTROL_CHARS );");
        sc.add("factory.enable( Feature.ALLOW_UNQUOTED_FIELD_NAMES );");
        jClass.addConstructor(jacksonReaderConstructor);
        this.writeAllClassesParser(objectModel, jClass);
        this.writeAllClassesReaders(objectModel, jClass);
        this.writeHelpers(jClass);
        if (this.requiresDomSupport) {
            jClass.addImport("com.fasterxml.jackson.databind.ObjectMapper");
            sc.add("factory.setCodec( new ObjectMapper() );");
        }
        jClass.print(sourceWriter);
        sourceWriter.close();
    }

    private void writeAllClassesParser(Model objectModel, JClass jClass) {
        ModelClass root = objectModel.getClass(objectModel.getRoot(this.getGeneratedVersion()), this.getGeneratedVersion());
        for (ModelClass clazz : this.getClasses(objectModel)) {
            if (this.isTrackingSupport(clazz)) continue;
            this.writeClassParser(clazz, jClass, root.getName().equals(clazz.getName()));
        }
    }

    private void writeClassParser(ModelClass modelClass, JClass jClass, boolean rootElement) {
        JavaClassMetadata javaClassMetadata = (JavaClassMetadata)modelClass.getMetadata(JavaClassMetadata.class.getName());
        if (javaClassMetadata.isAbstract()) {
            return;
        }
        String className = modelClass.getName();
        String capClassName = this.capitalise(className);
        String uncapClassName = JacksonReaderGenerator.uncapitalise((String)className);
        JMethod unmarshall = new JMethod("parse" + capClassName, (JType)new JClass(className), null);
        unmarshall.getModifiers().makePrivate();
        unmarshall.addParameter(new JParameter((JType)new JClass("JsonParser"), "parser"));
        unmarshall.addParameter(new JParameter(JClass.BOOLEAN, "strict"));
        this.addTrackingParameters(unmarshall);
        unmarshall.addException(new JClass("IOException"));
        JSourceCode sc = unmarshall.getSourceCode();
        sc.add("if ( JsonToken.START_OBJECT != parser.getCurrentToken() && JsonToken.START_OBJECT != parser.nextToken() )");
        sc.add("{");
        sc.addIndented("throw new JsonParseException( \"Expected '" + className + "' data to start with an Object\", parser.getCurrentLocation() );");
        sc.add("}");
        sc.add(className + " " + uncapClassName + " = new " + className + "();");
        if (this.locationTracker != null) {
            sc.add(this.locationTracker.getName() + " " + LOCATION_VAR + ";");
            this.writeNewSetLocation("\"\"", uncapClassName, null, sc);
        }
        List modelFields = this.getFieldsForXml(modelClass, this.getGeneratedVersion());
        sc.add("Set<String> parsed = new HashSet<String>();");
        sc.add("while ( JsonToken.END_OBJECT != parser.nextToken() )");
        sc.add("{");
        sc.indent();
        boolean addElse = false;
        for (ModelField field : modelFields) {
            XmlFieldMetadata xmlFieldMetadata = (XmlFieldMetadata)field.getMetadata(XmlFieldMetadata.ID);
            this.processField(field, xmlFieldMetadata, addElse, sc, uncapClassName, jClass);
            addElse = true;
        }
        if (addElse) {
            sc.add("else");
            sc.add("{");
            sc.indent();
        }
        sc.add("checkUnknownElement( parser, strict );");
        if (addElse) {
            sc.unindent();
            sc.add("}");
        }
        sc.unindent();
        sc.add("}");
        sc.add("return " + uncapClassName + ";");
        jClass.addMethod(unmarshall);
    }

    private void processField(ModelField field, XmlFieldMetadata xmlFieldMetadata, boolean addElse, JSourceCode sc, String objectName, JClass jClass) {
        String fieldTagName = this.resolveTagName(field, xmlFieldMetadata);
        String capFieldName = this.capitalise(field.getName());
        String singularName = JacksonReaderGenerator.singular((String)field.getName());
        String alias = StringUtils.isEmpty((String)field.getAlias()) ? "null" : "\"" + field.getAlias() + "\"";
        String tagComparison = (addElse ? "else " : "") + "if ( checkFieldWithDuplicate( parser, \"" + fieldTagName + "\", " + alias + ", parsed ) )";
        if (!(field instanceof ModelAssociation)) {
            sc.add(tagComparison);
            sc.add("{");
            sc.indent();
            this.writePrimitiveField(field, field.getType(), objectName, objectName, "\"" + field.getName() + "\"", "set" + capFieldName, sc, false);
            sc.unindent();
            sc.add("}");
        } else {
            ModelAssociation association = (ModelAssociation)field;
            String associationName = association.getName();
            if (association.isOneMultiplicity()) {
                sc.add(tagComparison);
                sc.add("{");
                sc.addIndented(objectName + ".set" + capFieldName + "( parse" + association.getTo() + "( parser, strict" + this.trackingArgs + " ) );");
                sc.add("}");
            } else {
                XmlAssociationMetadata xmlAssociationMetadata = (XmlAssociationMetadata)association.getAssociationMetadata(XmlAssociationMetadata.ID);
                String type = association.getType();
                if ("java.util.List".equals(type) || "java.util.Set".equals(type)) {
                    String adder;
                    boolean inModel = this.isClassInModel(association.getTo(), field.getModelClass().getModel());
                    sc.add((addElse ? "else " : "") + "if ( checkFieldWithDuplicate( parser, \"" + fieldTagName + "\", " + alias + ", parsed ) )");
                    sc.add("{");
                    sc.indent();
                    sc.add("if ( JsonToken.START_ARRAY != parser.nextToken() )");
                    sc.add("{");
                    sc.addIndented("throw new JsonParseException( \"Expected '" + fieldTagName + "' data to start with an Array\", parser.getCurrentLocation() );");
                    sc.add("}");
                    JavaFieldMetadata javaFieldMetadata = (JavaFieldMetadata)association.getMetadata(JavaFieldMetadata.ID);
                    if (javaFieldMetadata.isGetter() && javaFieldMetadata.isSetter()) {
                        sc.add(type + " " + associationName + " = " + objectName + ".get" + capFieldName + "();");
                        sc.add("if ( " + associationName + " == null )");
                        sc.add("{");
                        sc.indent();
                        sc.add(associationName + " = " + association.getDefaultValue() + ";");
                        sc.add(objectName + ".set" + capFieldName + "( " + associationName + " );");
                        sc.unindent();
                        sc.add("}");
                        adder = associationName + ".add";
                    } else {
                        adder = objectName + ".add" + association.getTo();
                    }
                    if (!inModel && this.locationTracker != null) {
                        sc.add(this.locationTracker.getName() + " " + LOCATION_VAR + "s = " + objectName + ".get" + this.capitalise(JacksonReaderGenerator.singular((String)this.locationField)) + "( \"" + field.getName() + "\" );");
                        sc.add("if ( _locations == null )");
                        sc.add("{");
                        sc.indent();
                        this.writeNewSetLocation(field, objectName, "_locations", sc);
                        sc.unindent();
                        sc.add("}");
                    }
                    sc.add("while ( JsonToken.END_ARRAY != parser.nextToken() )");
                    sc.add("{");
                    sc.indent();
                    if (inModel) {
                        sc.add(adder + "( parse" + association.getTo() + "( parser, strict" + this.trackingArgs + " ) );");
                    } else {
                        String key = "java.util.Set".equals(type) ? "?" : (this.hasJavaSourceSupport(5) ? "Integer.valueOf" : "new java.lang.Integer") + "( " + associationName + ".size() )";
                        this.writePrimitiveField((ModelField)association, association.getTo(), associationName, "_locations", key, "add", sc, true);
                    }
                    sc.unindent();
                    sc.add("}");
                    sc.unindent();
                    sc.add("}");
                } else {
                    sc.add(tagComparison);
                    sc.add("{");
                    sc.indent();
                    if (this.locationTracker != null) {
                        sc.add(this.locationTracker.getName() + " " + LOCATION_VAR + "s;");
                        this.writeNewSetLocation(field, objectName, "_locations", sc);
                    }
                    if (xmlAssociationMetadata.isMapExplode()) {
                        sc.add("if ( JsonToken.START_ARRAY != parser.nextToken() )");
                        sc.add("{");
                        sc.addIndented("throw new JsonParseException( \"Expected '" + fieldTagName + "' data to start with an Array\", parser.getCurrentLocation() );");
                        sc.add("}");
                        sc.add("// " + xmlAssociationMetadata.getMapStyle() + " mode.");
                        sc.add("while ( JsonToken.END_ARRAY != parser.nextToken() )");
                        sc.add("{");
                        sc.indent();
                        sc.add("if ( JsonToken.START_OBJECT != parser.getCurrentToken() && JsonToken.START_OBJECT != parser.nextToken() )");
                        sc.add("{");
                        sc.addIndented("throw new JsonParseException( \"Expected '" + fieldTagName + "' item data to start with an Object\", parser.getCurrentLocation() );");
                        sc.add("}");
                        sc.add("String key = null;");
                        sc.add("String value = null;");
                        sc.add("Set<String> parsedPropertiesElements = new HashSet<String>();");
                        sc.add("while ( JsonToken.END_OBJECT != parser.nextToken() )");
                        sc.add("{");
                        sc.indent();
                        sc.add("if ( checkFieldWithDuplicate( parser, \"key\", \"\", parsedPropertiesElements ) )");
                        sc.add("{");
                        sc.addIndented("parser.nextToken();");
                        String parserGetter = "parser.getText()";
                        if (xmlFieldMetadata.isTrim()) {
                            parserGetter = "getTrimmedValue( " + parserGetter + " )";
                        }
                        sc.addIndented("key = " + parserGetter + ";");
                        sc.add("}");
                        sc.add("else if ( checkFieldWithDuplicate( parser, \"value\", \"\", parsedPropertiesElements ) )");
                        sc.add("{");
                        sc.addIndented("parser.nextToken();");
                        parserGetter = "parser.getText()";
                        if (xmlFieldMetadata.isTrim()) {
                            parserGetter = "getTrimmedValue( " + parserGetter + " )";
                        }
                        sc.addIndented("value = " + parserGetter + ";");
                        sc.add("}");
                        sc.add("else");
                        sc.add("{");
                        sc.addIndented("checkUnknownElement( parser, strict );");
                        sc.add("}");
                        sc.unindent();
                        sc.add("}");
                        sc.add(objectName + ".add" + this.capitalise(singularName) + "( key, value );");
                        sc.unindent();
                        sc.add("}");
                    } else {
                        sc.add("if ( JsonToken.START_OBJECT != parser.nextToken() )");
                        sc.add("{");
                        sc.addIndented("throw new JsonParseException( \"Expected '" + fieldTagName + "' data to start with an Object\", parser.getCurrentLocation() );");
                        sc.add("}");
                        sc.add("while ( JsonToken.END_OBJECT != parser.nextToken() )");
                        sc.add("{");
                        sc.indent();
                        sc.add("String key = parser.getCurrentName();");
                        this.writeNewSetLocation("key", "_locations", null, sc);
                        sc.add("String value = parser.nextTextValue()" + (xmlFieldMetadata.isTrim() ? ".trim()" : "") + ";");
                        sc.add(objectName + ".add" + this.capitalise(singularName) + "( key, value );");
                        sc.unindent();
                        sc.add("}");
                    }
                    sc.unindent();
                    sc.add("}");
                }
            }
        }
    }

    private void writePrimitiveField(ModelField field, String type, String objectName, String locatorName, String locationKey, String setterName, JSourceCode sc, boolean wrappedItem) {
        XmlFieldMetadata xmlFieldMetadata = (XmlFieldMetadata)field.getMetadata(XmlFieldMetadata.ID);
        String parserGetter = null;
        if ("boolean".equals(type) || "Boolean".equals(type)) {
            parserGetter = "parser.getBooleanValue()";
        } else if ("int".equals(type) || "Integer".equals(type)) {
            parserGetter = "parser.getIntValue()";
        } else if ("short".equals(type) || "Short".equals(type)) {
            parserGetter = "parser.getShortValue()";
        } else if ("long".equals(type) || "Long".equals(type)) {
            parserGetter = "parser.getLongValue()";
        } else if ("double".equals(type) || "Double".equals(type)) {
            parserGetter = "parser.getDoubleValue()";
        } else if ("float".equals(type) || "Float".equals(type)) {
            parserGetter = "parser.getFloatValue()";
        } else if ("byte".equals(type)) {
            parserGetter = "parser.getByteValue()";
        } else if ("String".equals(type)) {
            parserGetter = "parser.getText()";
            if (xmlFieldMetadata.isTrim()) {
                parserGetter = "getTrimmedValue( " + parserGetter + " )";
            }
        } else if ("DOM".equals(type)) {
            this.requiresDomSupport = true;
            parserGetter = "parser.readValueAsTree()";
        } else {
            throw new IllegalArgumentException("Unknown type " + type + " for field " + field.getModelClass().getName() + "." + field.getName());
        }
        String keyCapture = "";
        this.writeNewLocation(null, sc);
        if (this.locationTracker != null && "?".equals(locationKey)) {
            sc.add("Object _key;");
            locationKey = "_key";
            keyCapture = "_key = ";
        } else {
            this.writeSetLocation(locationKey, locatorName, null, sc);
        }
        if (!wrappedItem) {
            sc.add("parser.nextToken();");
        }
        sc.add(objectName + "." + setterName + "( " + keyCapture + parserGetter + " );");
        if (keyCapture.length() > 0) {
            this.writeSetLocation(locationKey, locatorName, null, sc);
        }
    }

    private void writeHelpers(JClass jClass) {
        JMethod method = new JMethod("getTrimmedValue", (JType)new JClass("String"), null);
        method.getModifiers().makePrivate();
        method.addParameter(new JParameter((JType)new JClass("String"), "s"));
        JSourceCode sc = method.getSourceCode();
        sc.add("if ( s != null )");
        sc.add("{");
        sc.addIndented("s = s.trim();");
        sc.add("}");
        sc.add("return s;");
        jClass.addMethod(method);
        method = new JMethod("getRequiredAttributeValue", (JType)new JClass("String"), null);
        method.addException(new JClass("JsonParseException"));
        method.getModifiers().makePrivate();
        method.addParameter(new JParameter((JType)new JClass("String"), "s"));
        method.addParameter(new JParameter((JType)new JClass("String"), "attribute"));
        method.addParameter(new JParameter((JType)new JClass("JsonParser"), "parser"));
        method.addParameter(new JParameter(JClass.BOOLEAN, "strict"));
        sc = method.getSourceCode();
        sc.add("if ( s == null )");
        sc.add("{");
        sc.indent();
        sc.add("if ( strict )");
        sc.add("{");
        sc.addIndented("throw new JsonParseException( \"Missing required value for attribute '\" + attribute + \"'\", parser.getCurrentLocation() );");
        sc.add("}");
        sc.unindent();
        sc.add("}");
        sc.add("return s;");
        jClass.addMethod(method);
        method = new JMethod("checkFieldWithDuplicate", JType.BOOLEAN, null);
        method.getModifiers().makePrivate();
        method.addParameter(new JParameter((JType)new JClass("JsonParser"), "parser"));
        method.addParameter(new JParameter((JType)new JClass("String"), "tagName"));
        method.addParameter(new JParameter((JType)new JClass("String"), "alias"));
        method.addParameter(new JParameter((JType)new JClass("Set"), "parsed"));
        method.addException(new JClass("IOException"));
        sc = method.getSourceCode();
        sc.add("String currentName = parser.getCurrentName();");
        sc.add("");
        sc.add("if ( !( currentName.equals( tagName ) || currentName.equals( alias ) ) )");
        sc.add("{");
        sc.addIndented("return false;");
        sc.add("}");
        sc.add("if ( !parsed.add( tagName ) )");
        sc.add("{");
        sc.addIndented("throw new JsonParseException( \"Duplicated tag: '\" + tagName + \"'\", parser.getCurrentLocation() );");
        sc.add("}");
        sc.add("return true;");
        jClass.addMethod(method);
        method = new JMethod("checkUnknownElement", null, null);
        method.getModifiers().makePrivate();
        method.addParameter(new JParameter((JType)new JClass("JsonParser"), "parser"));
        method.addParameter(new JParameter(JType.BOOLEAN, "strict"));
        method.addException(new JClass("IOException"));
        sc = method.getSourceCode();
        sc.add("if ( strict )");
        sc.add("{");
        sc.addIndented("throw new JsonParseException( \"Unrecognised tag: '\" + parser.getCurrentName() + \"'\", parser.getCurrentLocation() );");
        sc.add("}");
        sc.add("");
        sc.add("for ( int unrecognizedTagCount = 1; unrecognizedTagCount > 0; )");
        sc.add("{");
        sc.indent();
        sc.add("JsonToken eventType = parser.nextToken();");
        sc.add("if ( eventType == JsonToken.START_OBJECT )");
        sc.add("{");
        sc.addIndented("unrecognizedTagCount++;");
        sc.add("}");
        sc.add("else if ( eventType == JsonToken.END_OBJECT )");
        sc.add("{");
        sc.addIndented("unrecognizedTagCount--;");
        sc.add("}");
        sc.unindent();
        sc.add("}");
        jClass.addMethod(method);
        method = new JMethod("checkUnknownAttribute", null, null);
        method.getModifiers().makePrivate();
        method.addParameter(new JParameter((JType)new JClass("JsonParser"), "parser"));
        method.addParameter(new JParameter((JType)new JClass("String"), "attribute"));
        method.addParameter(new JParameter((JType)new JClass("String"), "tagName"));
        method.addParameter(new JParameter(JType.BOOLEAN, "strict"));
        method.addException(new JClass("IOException"));
        sc = method.getSourceCode();
        if (this.strictXmlAttributes) {
            sc.add("// strictXmlAttributes = true for model: if strict == true, not only elements are checked but attributes too");
            sc.add("if ( strict )");
            sc.add("{");
            sc.addIndented("throw new JsonParseException( \"Unknown attribute '\" + attribute + \"' for tag '\" + tagName + \"'\", parser.getCurrentLocation() );");
            sc.add("}");
        } else {
            sc.add("// strictXmlAttributes = false for model: always ignore unknown XML attribute, even if strict == true");
        }
        jClass.addMethod(method);
    }

    private void addTrackingParameters(JMethod method) {
        if (this.sourceTracker != null) {
            method.addParameter(new JParameter((JType)new JClass(this.sourceTracker.getName()), SOURCE_PARAM));
        }
    }

    private void writeNewSetLocation(ModelField field, String objectName, String trackerVariable, JSourceCode sc) {
        this.writeNewSetLocation("\"" + field.getName() + "\"", objectName, trackerVariable, sc);
    }

    private void writeNewSetLocation(String key, String objectName, String trackerVariable, JSourceCode sc) {
        this.writeNewLocation(trackerVariable, sc);
        this.writeSetLocation(key, objectName, trackerVariable, sc);
    }

    private void writeNewLocation(String trackerVariable, JSourceCode sc) {
        if (this.locationTracker == null) {
            return;
        }
        String constr = "new " + this.locationTracker.getName() + "( parser.getLineNumber(), parser.getColumnNumber()";
        constr = constr + (this.sourceTracker != null ? ", source" : "");
        constr = constr + " )";
        sc.add((trackerVariable != null ? trackerVariable : LOCATION_VAR) + " = " + constr + ";");
    }

    private void writeSetLocation(String key, String objectName, String trackerVariable, JSourceCode sc) {
        if (this.locationTracker == null) {
            return;
        }
        String variable = trackerVariable != null ? trackerVariable : LOCATION_VAR;
        sc.add(objectName + ".set" + this.capitalise(JacksonReaderGenerator.singular((String)this.locationField)) + "( " + key + ", " + variable + " );");
    }
}

