/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.modello.plugin.velocity;

import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.RuntimeInstance;
import org.codehaus.modello.ModelloException;
import org.codehaus.modello.model.Model;
import org.codehaus.modello.model.Version;
import org.codehaus.modello.plugin.AbstractModelloGenerator;
import org.codehaus.modello.plugin.velocity.Helper;
import org.codehaus.plexus.util.io.CachingWriter;

@Named(value="velocity")
@Singleton
public class VelocityGenerator
extends AbstractModelloGenerator {
    public static final String VELOCITY_BASEDIR = "modello.velocity.basedir";
    public static final String VELOCITY_TEMPLATES = "modello.velocity.templates";
    public static final String VELOCITY_PARAMETERS = "modello.velocity.parameters";
    public static final String MODELLO_VELOCITY_OUTPUT = "#MODELLO-VELOCITY#SAVE-OUTPUT-TO ";

    public void generate(Model model, Properties parameters) throws ModelloException {
        try {
            Map params = (Map)Objects.requireNonNull(parameters.get(VELOCITY_PARAMETERS));
            String templates = this.getParameter(parameters, VELOCITY_TEMPLATES);
            String output = this.getParameter(parameters, "modello.output.directory");
            Properties props = new Properties();
            props.put("resource.loader.file.path", this.getParameter(parameters, VELOCITY_BASEDIR));
            RuntimeInstance velocity = new RuntimeInstance();
            velocity.init(props);
            VelocityContext context = new VelocityContext();
            for (Map.Entry<Object, Object> entry : parameters.entrySet()) {
                context.put(entry.getKey().toString(), entry.getValue());
            }
            for (Map.Entry<Object, Object> entry : params.entrySet()) {
                context.put((String)entry.getKey(), entry.getValue());
            }
            Version version = new Version(this.getParameter(parameters, "modello.version"));
            context.put("version", (Object)version);
            context.put("model", (Object)model);
            context.put("Helper", (Object)new Helper(version));
            for (String templatePath : templates.split(",")) {
                Template template = velocity.getTemplate(templatePath);
                context.put("template", (Object)templatePath);
                try (RedirectingWriter w = new RedirectingWriter(Paths.get(output, new String[0]));){
                    template.merge((Context)context, (Writer)w);
                }
            }
        }
        catch (Exception e) {
            throw new ModelloException("Unable to run velocity template", (Throwable)e);
        }
    }

    static class RedirectingWriter
    extends Writer {
        Path dir;
        StringBuilder sb = new StringBuilder();
        Writer current;

        RedirectingWriter(Path dir) {
            this.dir = dir;
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            for (int i = 0; i < len; ++i) {
                if (cbuf[off + i] == '\n') {
                    if (this.sb.length() > 0 && this.sb.charAt(this.sb.length() - 1) == '\r') {
                        this.sb.setLength(this.sb.length() - 1);
                    }
                    this.writeLine(this.sb.toString());
                    this.sb.setLength(0);
                    continue;
                }
                this.sb.append(cbuf[off + i]);
            }
        }

        protected void writeLine(String line) throws IOException {
            if (line.startsWith(VelocityGenerator.MODELLO_VELOCITY_OUTPUT)) {
                String file = line.substring(VelocityGenerator.MODELLO_VELOCITY_OUTPUT.length());
                if (this.current != null) {
                    this.current.close();
                }
                Path out = this.dir.resolve(file);
                Files.createDirectories(out.getParent(), new FileAttribute[0]);
                this.current = new CachingWriter(out, StandardCharsets.UTF_8);
            } else if (this.current != null) {
                this.current.write(line);
                this.current.write("\n");
            }
        }

        @Override
        public void flush() throws IOException {
            if (this.current != null) {
                this.current.flush();
            }
        }

        @Override
        public void close() throws IOException {
            if (this.current != null) {
                this.current.close();
                this.current = null;
            }
        }
    }
}

