/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.animal_sniffer.ant;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.types.resources.FileResource;
import org.codehaus.mojo.animal_sniffer.ClassFileVisitor;
import org.codehaus.mojo.animal_sniffer.ClassListBuilder;
import org.codehaus.mojo.animal_sniffer.SignatureChecker;
import org.codehaus.mojo.animal_sniffer.ant.Annotation;
import org.codehaus.mojo.animal_sniffer.ant.AntLogger;
import org.codehaus.mojo.animal_sniffer.ant.Ignore;
import org.codehaus.mojo.animal_sniffer.logging.Logger;

public class CheckSignatureTask
extends Task {
    private File signature;
    private Path classpath;
    private Path sourcepath;
    private boolean failOnError = true;
    private Vector<Path> paths = new Vector();
    private Vector<Ignore> ignores = new Vector();
    private Vector<Annotation> annotations = new Vector();

    public void addPath(Path path) {
        this.paths.add(path);
    }

    public Ignore createIgnore() {
        Ignore result = new Ignore();
        this.ignores.add(result);
        return result;
    }

    public Annotation createAnnotation() {
        Annotation result = new Annotation();
        this.annotations.add(result);
        return result;
    }

    public void setSignature(File signature) {
        this.signature = signature;
    }

    public Path createClasspath() {
        this.log("In createClasspath", 2);
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setClasspath(Path classpath) {
        this.log("In setClasspath", 2);
        if (this.classpath == null) {
            this.classpath = classpath;
        } else {
            this.classpath.append(classpath);
        }
    }

    public void setClasspathRef(Reference r) {
        this.log("In setClasspathRef", 2);
        this.createClasspath().setRefid(r);
    }

    public Path createSourcepath() {
        this.log("In createSourcepath", 2);
        if (this.sourcepath == null) {
            this.sourcepath = new Path(this.getProject());
        }
        return this.sourcepath.createPath();
    }

    public void setSourcepath(Path sourcepath) {
        this.log("In setSourcepath", 2);
        if (this.sourcepath == null) {
            this.sourcepath = sourcepath;
        } else {
            this.sourcepath.append(sourcepath);
        }
    }

    public void setSourcepathRef(Reference r) {
        this.log("In setSourcepathRef", 2);
        this.createSourcepath().setRefid(r);
    }

    public void setFailOnError(boolean failOnError) {
        this.log("In setFailOnError", 2);
        this.failOnError = failOnError;
    }

    public void execute() throws BuildException {
        this.validate();
        try {
            this.log("Checking unresolved references to " + this.signature, 2);
            if (!this.signature.isFile()) {
                throw new BuildException("Could not find signature: " + this.signature);
            }
            Set<String> ignoredPackages = this.buildPackageList();
            for (Ignore ignore : this.ignores) {
                if (ignore == null || ignore.getClassName() == null) continue;
                ignoredPackages.add(ignore.getClassName().replace('.', '/'));
            }
            SignatureChecker signatureChecker = new SignatureChecker(new FileInputStream(this.signature), ignoredPackages, (Logger)new AntLogger(this));
            ArrayList<File> tmp = new ArrayList<File>();
            if (this.sourcepath != null) {
                for (Object next : this.sourcepath) {
                    if (!(next instanceof FileResource)) continue;
                    File file = ((FileResource)next).getFile();
                    tmp.add(file);
                }
            }
            signatureChecker.setSourcePath(tmp);
            HashSet<String> annotationTypes = new HashSet<String>();
            for (Annotation annotation : this.annotations) {
                if (annotation == null || annotation.getClassName() == null) continue;
                annotationTypes.add(annotation.getClassName());
            }
            signatureChecker.setAnnotationTypes(annotationTypes);
            for (Path path : this.paths) {
                String[] files;
                for (String file : files = path.list()) {
                    signatureChecker.process(new File(file));
                }
            }
            if (signatureChecker.isSignatureBroken()) {
                String message = "Signature errors found. Verify them and ignore them with the proper annotation if needed.";
                if (this.failOnError) {
                    throw new BuildException(message, this.getLocation());
                }
                this.log(message, 1);
            }
        }
        catch (IOException e) {
            throw new BuildException("Failed to check signatures", (Throwable)e);
        }
    }

    protected void validate() {
        if (this.signature == null) {
            throw new BuildException("signature not set");
        }
        if (this.paths.size() < 1) {
            throw new BuildException("path not set");
        }
    }

    private Set<String> buildPackageList() throws IOException {
        ClassListBuilder plb = new ClassListBuilder(new AntLogger(this));
        this.apply(plb);
        return plb.getPackages();
    }

    private void apply(ClassFileVisitor v) throws IOException {
        for (Path path : this.paths) {
            String[] files;
            for (String file : files = path.list()) {
                this.log("Ignoring the signatures from file to be checked: " + file, 2);
                v.process(new File(file));
            }
        }
        if (this.classpath != null) {
            for (Object next : this.classpath) {
                if (!(next instanceof FileResource)) continue;
                File file = ((FileResource)next).getFile();
                this.log("Ignoring the signatures from classpath: " + file, 2);
                v.process(file);
            }
        }
    }
}

