/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.animal_sniffer;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public abstract class ClassFileVisitor {
    private boolean checkJars = true;

    public boolean isCheckJars() {
        return this.checkJars;
    }

    public void setCheckJars(boolean checkJars) {
        this.checkJars = checkJars;
    }

    public void process(File[] files) throws IOException {
        Arrays.sort(files, new Comparator(){

            public int compare(Object o1, Object o2) {
                File f1 = (File)o1;
                File f2 = (File)o2;
                String n1 = f1.getName();
                String n2 = f2.getName();
                int diff = n1.length() - n2.length();
                return diff != 0 ? diff : n1.compareTo(n2);
            }
        });
        for (int i = 0; i < files.length; ++i) {
            this.process(files[i]);
        }
    }

    public void process(File file) throws IOException {
        if (file.isDirectory()) {
            this.processDirectory(file);
        } else if (file.getName().endsWith(".class")) {
            this.processClassFile(file);
        } else if (file.getName().endsWith(".jar") && this.checkJars) {
            this.processJarFile(file);
        }
    }

    protected void processDirectory(File dir) throws IOException {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        this.process(files);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processJarFile(File file) throws IOException {
        try {
            JarFile jar = new JarFile(file);
            TreeSet<JarEntry> entries = new TreeSet<JarEntry>(new Comparator(){

                public int compare(Object o1, Object o2) {
                    JarEntry e1 = (JarEntry)o1;
                    JarEntry e2 = (JarEntry)o2;
                    String n1 = e1.getName();
                    String n2 = e2.getName();
                    int diff = n1.length() - n2.length();
                    return diff != 0 ? diff : n1.compareTo(n2);
                }
            });
            Enumeration<JarEntry> e = jar.entries();
            while (e.hasMoreElements()) {
                JarEntry x = e.nextElement();
                if (!x.getName().endsWith(".class")) continue;
                entries.add(x);
            }
            for (JarEntry x : entries) {
                InputStream is = jar.getInputStream(x);
                try {
                    this.process(file.getPath() + ':' + x.getName(), is);
                }
                finally {
                    is.close();
                }
            }
        }
        catch (IOException e) {
            throw new IOException(" failed to process jar " + file.getPath() + " : " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processClassFile(File file) throws IOException {
        FileInputStream in = new FileInputStream(file);
        try {
            this.process(file.getPath(), in);
        }
        finally {
            ((InputStream)in).close();
        }
    }

    protected abstract void process(String var1, InputStream var2) throws IOException;
}

