/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.animal_sniffer;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import org.codehaus.mojo.animal_sniffer.ClassFileVisitor;
import org.codehaus.mojo.animal_sniffer.logging.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassListBuilder
extends ClassFileVisitor {
    private final Set<String> packages;
    private final Logger logger;

    public Set<String> getPackages() {
        return this.packages;
    }

    public ClassListBuilder(Set<String> packages, Logger logger) {
        this.packages = packages;
        this.logger = logger;
    }

    public ClassListBuilder(Logger logger) {
        this(new HashSet<String>(), logger);
    }

    @Override
    protected void process(String name, InputStream image) throws IOException {
        try {
            ClassReader cr = new ClassReader(image);
            cr.accept(new ClassVisitor(327680){

                public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                    ClassListBuilder.this.packages.add(name.replace('/', '.'));
                }
            }, 0);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.logger.error("Bad class file " + name);
            IOException ioException = new IOException("Bad class file " + name);
            ioException.initCause(e);
            throw ioException;
        }
    }
}

