/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.animal_sniffer;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.codehaus.mojo.animal_sniffer.logging.Logger;
import org.codehaus.mojo.animal_sniffer.logging.PrintWriterLogger;

public abstract class ClassFileVisitor {
    protected final Logger logger;
    private boolean checkJars = true;

    protected ClassFileVisitor() {
        this(new PrintWriterLogger(System.err));
    }

    protected ClassFileVisitor(Logger logger) {
        this.logger = logger;
    }

    public boolean isCheckJars() {
        return this.checkJars;
    }

    public void setCheckJars(boolean checkJars) {
        this.checkJars = checkJars;
    }

    public void process(File[] files) throws IOException {
        Arrays.sort(files, (f1, f2) -> {
            String n1 = f1.getName();
            String n2 = f2.getName();
            int diff = n1.length() - n2.length();
            return diff != 0 ? diff : n1.compareTo(n2);
        });
        for (File f : files) {
            this.process(f);
        }
    }

    public void process(File file) throws IOException {
        if (file.isDirectory()) {
            this.processDirectory(file);
        } else if (file.getName().endsWith(".class")) {
            this.processClassFile(file);
        } else if ((file.getName().endsWith(".jar") || file.getName().endsWith(".jmod")) && this.checkJars) {
            this.processJarFile(file);
        }
    }

    public void process(Path path) throws IOException {
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){
            final SortedSet<Path> files = new TreeSet<Path>();

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                if (file.getFileName().toString().endsWith(".class")) {
                    this.files.add(file);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                if (exc != null) {
                    throw exc;
                }
                for (Path file : this.files) {
                    InputStream inputStream = Files.newInputStream(file, new OpenOption[0]);
                    try {
                        ClassFileVisitor.this.process(file.toString(), inputStream);
                    }
                    finally {
                        if (inputStream == null) continue;
                        inputStream.close();
                    }
                }
                this.files.clear();
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) {
                return FileVisitResult.CONTINUE;
            }
        });
    }

    protected void processDirectory(File dir) throws IOException {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        this.process(files);
    }

    protected void processJarFile(File file) throws IOException {
        try (JarFile jar = new JarFile(file);){
            TreeSet<JarEntry> entries = new TreeSet<JarEntry>((e1, e2) -> {
                String n1 = e1.getName();
                String n2 = e2.getName();
                int diff = n1.length() - n2.length();
                return diff != 0 ? diff : n1.compareTo(n2);
            });
            Enumeration<JarEntry> e = jar.entries();
            while (e.hasMoreElements()) {
                JarEntry x = e.nextElement();
                String name = x.getName();
                if (!name.endsWith(".class")) continue;
                if (name.startsWith("META-INF/") || name.equals("module-info.class")) {
                    this.logger.debug("Ignoring " + name);
                    continue;
                }
                entries.add(x);
            }
            for (JarEntry x : entries) {
                InputStream is = jar.getInputStream(x);
                try {
                    this.process(file.getPath() + ':' + x.getName(), is);
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
        }
        catch (IOException cause) {
            throw new IOException(" failed to process jar " + file.getPath() + " : " + cause.getMessage(), cause);
        }
    }

    protected void processClassFile(File file) throws IOException {
        try (FileInputStream in = new FileInputStream(file);){
            this.process(file.getPath(), in);
        }
    }

    protected abstract void process(String var1, InputStream var2) throws IOException;
}

