/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.animal_sniffer;

import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.codehaus.mojo.animal_sniffer.Clazz;

public class SignatureObjectInputStream
extends ObjectInputStream {
    private static final Set<String> ALLOWED_CLASS_NAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(Clazz.class.getName(), String[].class.getName())));

    public SignatureObjectInputStream(InputStream in) throws IOException {
        super(in);
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        Class<?> c;
        String className = desc.getName();
        if (ALLOWED_CLASS_NAMES.contains(className)) {
            return super.resolveClass(desc);
        }
        try {
            c = super.resolveClass(desc);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InvalidClassException(className, "Class not found, probably disallowed class");
        }
        if (SignatureObjectInputStream.isAllowedSetClass(c)) {
            return c;
        }
        throw new InvalidClassException(className, "Disallowed class for signature data");
    }

    private static boolean isAllowedSetClass(Class<?> c) {
        return Set.class.isAssignableFrom(c) && c.getName().startsWith("java.util.");
    }
}

