/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.animal_sniffer;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.codehaus.mojo.animal_sniffer.Clazz;
import org.codehaus.mojo.animal_sniffer.logging.Logger;

public class SignatureMerger {
    private final Map classes = new HashMap();
    private final Logger logger;

    public static void main(String[] args) throws Exception {
    }

    public SignatureMerger(InputStream[] in, OutputStream out, Logger logger) throws IOException {
        this.logger = logger;
        int i = 0;
        if (i < in.length) {
            try {
                ObjectInputStream ois = new ObjectInputStream(new GZIPInputStream(in[i]));
                while (true) {
                    Clazz c;
                    if ((c = (Clazz)ois.readObject()) == null) {
                        return;
                    }
                    Clazz cur = (Clazz)this.classes.get(c.getName());
                    if (cur == null) {
                        this.classes.put(c.getName(), c);
                        continue;
                    }
                    this.classes.put(c.getName(), new Clazz(c, cur));
                }
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
        }
        ObjectOutputStream oos = new ObjectOutputStream(new GZIPOutputStream(out));
        Iterator i2 = this.classes.entrySet().iterator();
        while (i2.hasNext()) {
            Map.Entry entry = i2.next();
            logger.info((String)entry.getKey());
            oos.writeObject(entry.getValue());
        }
        oos.writeObject(null);
        oos.close();
    }
}

