/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.antlr;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.mojo.antlr.NoExitSecurityManager;
import org.codehaus.mojo.antlr.options.Grammar;
import org.codehaus.plexus.util.StringOutputStream;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractAntlrMojo
extends AbstractMojo {
    protected File sourceDirectory;
    protected MavenProject project;
    private MavenProjectHelper projectHelper;
    protected File outputDirectory;
    protected String grammars;
    protected Grammar[] grammarDefs;
    private boolean debug;
    private boolean diagnostic;
    private boolean trace;
    private boolean traceParser;
    private boolean traceLexer;
    private boolean traceTreeParser;
    static /* synthetic */ Class array$Ljava$lang$String;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeAntlr() throws MojoExecutionException {
        this.validateParameters();
        Artifact antlrArtifact = null;
        if (this.project.getCompileArtifacts() != null) {
            Iterator projectArtifacts = this.project.getCompileArtifacts().iterator();
            while (projectArtifacts.hasNext()) {
                Artifact artifact = (Artifact)projectArtifacts.next();
                if (!"antlr".equals(artifact.getGroupId()) || !"antlr".equals(artifact.getArtifactId()) && !"antlr-all".equals(artifact.getArtifactId())) continue;
                antlrArtifact = artifact;
                break;
            }
        }
        if (antlrArtifact == null) {
            throw new NoAntlrDependencyDefinedException("project did not define antlr:antlr depenency");
        }
        Grammar[] grammarsUsed = this.getGrammars();
        for (int i = 0; i < grammarsUsed.length; ++i) {
            String grammarName = grammarsUsed[i].getName();
            if (StringUtils.isEmpty((String)grammarName)) {
                this.getLog().info((CharSequence)"Empty grammar in the configuration. Skipped.");
                continue;
            }
            File grammar = new File(this.sourceDirectory, grammarName.trim());
            if (!grammar.exists()) {
                throw new MojoExecutionException("The grammar '" + grammar.getAbsolutePath() + "' doesnt exist.");
            }
            this.getLog().info((CharSequence)("Using Antlr grammar: " + grammar));
            File generated = null;
            try {
                generated = this.getGeneratedFile(grammar.getPath(), this.outputDirectory);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to get generated file: " + e.getMessage(), (Exception)e);
            }
            if (generated.exists() && generated.lastModified() > grammar.lastModified()) {
                this.getLog().info((CharSequence)"The grammar is already generated.");
                continue;
            }
            if (!generated.getParentFile().exists()) {
                generated.getParentFile().mkdirs();
            }
            LinkedList<String> arguments = new LinkedList<String>();
            AbstractAntlrMojo.addArgIf(arguments, this.debug, "-debug");
            AbstractAntlrMojo.addArgIf(arguments, this.diagnostic, "-diagnostic");
            AbstractAntlrMojo.addArgIf(arguments, this.trace, "-trace");
            AbstractAntlrMojo.addArgIf(arguments, this.traceParser, "-traceParser");
            AbstractAntlrMojo.addArgIf(arguments, this.traceLexer, "-traceLexer");
            AbstractAntlrMojo.addArgIf(arguments, this.traceTreeParser, "-traceTreeParser");
            this.addArgs(arguments);
            arguments.add("-o");
            arguments.add(generated.getParentFile().getPath());
            if (StringUtils.isNotEmpty((String)grammarsUsed[i].getGlib())) {
                StringBuffer glib = new StringBuffer();
                StringTokenizer st = new StringTokenizer(grammarsUsed[i].getGlib(), ",; ");
                while (st.hasMoreTokens()) {
                    glib.append(new File(this.sourceDirectory, st.nextToken().trim()));
                    if (!st.hasMoreTokens()) continue;
                    glib.append(";");
                }
                arguments.add("-glib");
                arguments.add(glib.toString());
            }
            arguments.add(grammar.getPath());
            Object[] args = arguments.toArray(new String[0]);
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("antlr args=\n" + StringUtils.join((Object[])args, (String)"\n")));
            }
            boolean failedSetManager = false;
            SecurityManager oldSm = null;
            try {
                oldSm = System.getSecurityManager();
                System.setSecurityManager(NoExitSecurityManager.INSTANCE);
            }
            catch (SecurityException ex) {
                oldSm = null;
                failedSetManager = true;
                this.getLog().warn((CharSequence)"Cannot set custom SecurityManager. Antlr's call to System.exit() can cause application shutdown if not handled by the current SecurityManager.");
            }
            PrintStream oldErr = System.err;
            StringOutputStream errOS = new StringOutputStream();
            PrintStream err = new PrintStream((OutputStream)errOS);
            System.setErr(err);
            try {
                this.executeAntlrInIsolatedClassLoader(arguments.toArray(new String[0]), antlrArtifact);
                continue;
            }
            catch (SecurityException e) {
                if (e.getMessage().equals("exitVM-0") || e.getClass().getName().equals("org.netbeans.core.execution.ExitSecurityException")) {
                    this.getLog().debug((Throwable)e);
                    continue;
                }
                throw new MojoExecutionException("Antlr execution failed: " + e.getMessage() + "\n Error output:\n" + errOS, (Exception)e);
            }
            finally {
                if (!failedSetManager) {
                    System.setSecurityManager(oldSm);
                }
                System.setErr(oldErr);
                System.err.println(errOS.toString());
            }
        }
        if (this.project != null) {
            this.projectHelper.addResource(this.project, this.outputDirectory.getAbsolutePath(), Collections.singletonList("**/**.txt"), new ArrayList());
            this.project.addCompileSourceRoot(this.outputDirectory.getAbsolutePath());
        }
    }

    private void executeAntlrInIsolatedClassLoader(String[] args, Artifact antlrArtifact) throws MojoExecutionException {
        try {
            URLClassLoader classLoader = new URLClassLoader(new URL[]{antlrArtifact.getFile().toURL()}, ClassLoader.getSystemClassLoader());
            Class<?> toolClass = classLoader.loadClass("antlr.Tool");
            toolClass.getMethod("main", array$Ljava$lang$String == null ? (array$Ljava$lang$String = AbstractAntlrMojo.class$("[Ljava.lang.String;")) : array$Ljava$lang$String).invoke(null, new Object[]{args});
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Unable to resolve antlr:antlr artifact url", (Exception)e);
        }
        catch (ClassNotFoundException e) {
            throw new MojoExecutionException("could not locate antlr.Tool class");
        }
        catch (NoSuchMethodException e) {
            throw new MojoExecutionException("error locating antlt.Tool#main", (Exception)e);
        }
        catch (InvocationTargetException e) {
            throw new MojoExecutionException("error perforing antlt.Tool#main", e.getTargetException());
        }
        catch (IllegalAccessException e) {
            throw new MojoExecutionException("error perforing antlt.Tool#main", (Exception)e);
        }
    }

    protected abstract void addArgs(List var1);

    protected static void addArgIf(List arguments, boolean b, String value) {
        if (b) {
            arguments.add(value);
        }
    }

    private File getGeneratedFile(String grammar, File outputDir) throws IOException {
        String line;
        String generatedFileName = null;
        String packageName = "";
        BufferedReader in = new BufferedReader(new FileReader(grammar));
        while ((line = in.readLine()) != null) {
            line = line.trim();
            int extendsIndex = line.indexOf(" extends ");
            if (line.startsWith("class ") && extendsIndex > -1) {
                generatedFileName = line.substring(6, extendsIndex).trim();
                break;
            }
            if (!line.startsWith("package")) continue;
            packageName = line.substring(8).trim();
        }
        in.close();
        if (generatedFileName == null) {
            throw new IOException("Unable to generate the output file name: is the grammar '" + grammar + "' valide?");
        }
        File genFile = null;
        if ("".equals(packageName)) {
            genFile = new File(outputDir, generatedFileName + ".java");
        } else {
            String packagePath = packageName.replace('.', File.separatorChar);
            packagePath = packagePath.replace(';', File.separatorChar);
            genFile = new File(new File(outputDir, packagePath), generatedFileName + ".java");
        }
        return genFile;
    }

    private void validateParameters() throws MojoExecutionException {
        if (StringUtils.isEmpty((String)this.grammars) && (this.grammarDefs == null || this.grammarDefs.length == 0)) {
            StringBuffer msg = new StringBuffer();
            msg.append("Antlr plugin parameters are invalid/missing.").append('\n');
            msg.append("Inside the definition for plugin 'antlr-maven-plugin' specify the following:").append('\n');
            msg.append('\n');
            msg.append("<configuration>").append('\n');
            msg.append("  <grammars>VALUE</grammars>").append('\n');
            msg.append("- OR - ").append('\n');
            msg.append("  <grammarDefs>VALUE</grammarDefs>").append('\n');
            msg.append("</configuration>").append('\n');
            throw new MojoExecutionException(msg.toString());
        }
    }

    private Grammar[] getGrammars() {
        ArrayList<Grammar> grammarList = new ArrayList<Grammar>();
        HashSet grammarSet = new HashSet();
        if (StringUtils.isNotEmpty((String)this.grammars)) {
            StringTokenizer st = new StringTokenizer(this.grammars, ", ");
            while (st.hasMoreTokens()) {
                String currentGrammar = st.nextToken().trim();
                if (!StringUtils.isNotEmpty((String)currentGrammar)) continue;
                if (currentGrammar.indexOf(42) != -1 || currentGrammar.indexOf(63) != -1) {
                    final String transformedGrammar = currentGrammar.replaceAll("\\.", "\\\\.").replaceAll("\\*", ".*").replaceAll("\\?", ".");
                    String[] dir = this.sourceDirectory.list(new FilenameFilter(){

                        public boolean accept(File dir, String s) {
                            return Pattern.matches(transformedGrammar, s);
                        }
                    });
                    if (dir == null || dir.length == 0) continue;
                    for (int i = 0; i < dir.length; ++i) {
                        if (grammarSet.contains(dir[i])) continue;
                        Grammar grammar = new Grammar();
                        grammar.setName(dir[i]);
                        grammarList.add(grammar);
                    }
                    continue;
                }
                if (grammarSet.contains(currentGrammar)) continue;
                Grammar grammar = new Grammar();
                grammar.setName(currentGrammar);
                grammarList.add(grammar);
            }
        }
        if (this.grammarDefs != null) {
            grammarList.addAll(Arrays.asList(this.grammarDefs));
        }
        return grammarList.toArray(new Grammar[0]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class NoAntlrDependencyDefinedException
    extends MojoExecutionException {
        public NoAntlrDependencyDefinedException(String s) {
            super(s);
        }
    }
}

