/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.antlr.metadata;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.antlr.Environment;
import org.codehaus.mojo.antlr.metadata.Grammar;
import org.codehaus.mojo.antlr.metadata.GrammarFile;
import org.codehaus.mojo.antlr.metadata.XRef;
import org.codehaus.mojo.antlr.proxy.Helper;
import org.codehaus.plexus.util.StringUtils;

public class MetadataExtracter {
    private final Helper helper;
    private final Environment environment;
    private final Class antlrHierarchyClass;

    public MetadataExtracter(Environment environment, Helper helper) throws MojoExecutionException {
        this.environment = environment;
        this.helper = helper;
        this.antlrHierarchyClass = helper.getAntlrHierarchyClass();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XRef processMetadata(org.codehaus.mojo.antlr.options.Grammar[] grammars) throws MojoExecutionException {
        String grammarFilePath;
        Method getFileMethod;
        Method readGrammarFileMethod;
        Object hierarchy;
        try {
            Object antlrTool = this.helper.getAntlrToolClass().newInstance();
            Constructor ctor = this.antlrHierarchyClass.getConstructor(this.helper.getAntlrToolClass());
            hierarchy = ctor.newInstance(antlrTool);
            readGrammarFileMethod = this.antlrHierarchyClass.getMethod("readGrammarFile", Helper.STRING_ARG_SIGNATURE);
            getFileMethod = this.antlrHierarchyClass.getMethod("getFile", Helper.STRING_ARG_SIGNATURE);
        }
        catch (Throwable t) {
            throw new MojoExecutionException("Unable to instantiate Antlr preprocessor tool", this.causeToUse(t));
        }
        ArrayList<GrammarFile> files = new ArrayList<GrammarFile>();
        for (int i = 0; i < grammars.length; ++i) {
            String grammarName = grammars[i].getName().trim();
            if (StringUtils.isEmpty((String)grammarName)) {
                this.environment.getLog().info((CharSequence)"Empty grammar in the configuration; skipping.");
                continue;
            }
            File grammar = new File(this.environment.getSourceDirectory(), grammarName);
            if (!grammar.exists()) {
                throw new MojoExecutionException("The grammar '" + grammar.getAbsolutePath() + "' doesnt exist.");
            }
            grammarFilePath = grammar.getPath();
            GrammarFile grammarFile = new GrammarFile(grammarName, grammarFilePath, StringUtils.isNotEmpty((String)grammars[i].getGlib()) ? StringUtils.split((String)grammars[i].getGlib(), (String)":,") : new String[]{});
            try {
                BufferedReader in = new BufferedReader(new FileReader(grammar));
                try {
                    String line;
                    while ((line = in.readLine()) != null) {
                        if (!(line = line.trim()).startsWith("package") || !line.endsWith(";")) continue;
                        grammarFile.setPackageName(line.substring(8, line.length() - 1));
                        break;
                    }
                }
                finally {
                    try {
                        in.close();
                    }
                    catch (IOException ioe) {}
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            files.add(grammarFile);
            try {
                readGrammarFileMethod.invoke(hierarchy, grammarFilePath);
                continue;
            }
            catch (Throwable t) {
                throw new MojoExecutionException("Unable to use Antlr preprocessor to read grammar file", this.causeToUse(t));
            }
        }
        XRef xref = new XRef(hierarchy);
        Iterator itr = files.iterator();
        while (itr.hasNext()) {
            GrammarFile gf = (GrammarFile)itr.next();
            grammarFilePath = gf.getFileName();
            try {
                Object antlrGrammarFileDef = getFileMethod.invoke(hierarchy, grammarFilePath);
                this.intrepretMetadata(gf, antlrGrammarFileDef);
                xref.addGrammarFile(gf);
            }
            catch (Throwable t) {
                throw new MojoExecutionException("Unable to build grammar metadata", this.causeToUse(t));
            }
        }
        return xref;
    }

    private void intrepretMetadata(GrammarFile gf, Object antlrGrammarFileDef) throws MojoExecutionException {
        try {
            Object grammarsVector = this.helper.getAntlrGrammarFileClass().getMethod("getGrammars", Helper.NO_ARG_SIGNATURE).invoke(antlrGrammarFileDef, Helper.NO_ARGS);
            Enumeration grammars = (Enumeration)this.helper.getAntlrIndexedVectorClass().getMethod("elements", Helper.NO_ARG_SIGNATURE).invoke(grammarsVector, Helper.NO_ARGS);
            while (grammars.hasMoreElements()) {
                Grammar grammar = new Grammar(gf);
                this.intrepret(grammar, grammars.nextElement());
            }
        }
        catch (Throwable t) {
            throw new MojoExecutionException("Error attempting to access grammars within grammar file", t);
        }
    }

    private void intrepret(Grammar grammar, Object antlrGrammarDef) throws MojoExecutionException {
        try {
            Object exportVocabOption;
            String importVocab;
            Method getNameMethod = this.helper.getAntlrGrammarClass().getDeclaredMethod("getName", Helper.NO_ARG_SIGNATURE);
            getNameMethod.setAccessible(true);
            String name = (String)getNameMethod.invoke(antlrGrammarDef, Helper.NO_ARGS);
            grammar.setClassName(name);
            Method getSuperGrammarNameMethod = this.helper.getAntlrGrammarClass().getMethod("getSuperGrammarName", Helper.NO_ARG_SIGNATURE);
            getSuperGrammarNameMethod.setAccessible(true);
            String superGrammarName = (String)getSuperGrammarNameMethod.invoke(antlrGrammarDef, Helper.NO_ARGS);
            grammar.setSuperGrammarName(superGrammarName);
            Method getOptionsMethod = this.helper.getAntlrGrammarClass().getMethod("getOptions", Helper.NO_ARG_SIGNATURE);
            getOptionsMethod.setAccessible(true);
            Object options = getOptionsMethod.invoke(antlrGrammarDef, Helper.NO_ARGS);
            Method getElementMethod = this.helper.getAntlrIndexedVectorClass().getMethod("getElement", Object.class);
            getElementMethod.setAccessible(true);
            Method getRHSMethod = this.helper.getAntlrOptionClass().getMethod("getRHS", Helper.NO_ARG_SIGNATURE);
            getRHSMethod.setAccessible(true);
            Object importVocabOption = getElementMethod.invoke(options, "importVocab");
            if (importVocabOption != null && (importVocab = (String)getRHSMethod.invoke(importVocabOption, Helper.NO_ARGS)) != null) {
                if ((importVocab = importVocab.trim()).endsWith(";")) {
                    importVocab = importVocab.substring(0, importVocab.length() - 1);
                }
                grammar.setImportVocab(importVocab);
            }
            if ((exportVocabOption = getElementMethod.invoke(options, "exportVocab")) != null) {
                String exportVocab = (String)getRHSMethod.invoke(exportVocabOption, Helper.NO_ARGS);
                if (exportVocab != null && (exportVocab = exportVocab.trim()).endsWith(";")) {
                    exportVocab = exportVocab.substring(0, exportVocab.length() - 1);
                }
                grammar.setExportVocab(exportVocab);
            }
        }
        catch (Throwable t) {
            throw new MojoExecutionException("Error accessing  Antlr grammar metadata", t);
        }
    }

    private Throwable causeToUse(Throwable throwable) {
        if (throwable instanceof InvocationTargetException) {
            return ((InvocationTargetException)throwable).getTargetException();
        }
        return throwable;
    }
}

