/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.appassembler;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.installer.ArtifactInstallationException;
import org.apache.maven.artifact.installer.ArtifactInstaller;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import org.apache.maven.artifact.repository.layout.LegacyRepositoryLayout;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.appassembler.Program;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.InterpolationFilterReader;
import org.codehaus.plexus.util.StringUtils;

public class AssembleMojo
extends AbstractMojo {
    private String buildDirectory;
    private Set artifacts;
    private File assembleDirectory;
    private Artifact projectArtifact;
    private ArtifactRepository localRepository;
    private Set programs;
    private String binPrefix;
    private boolean includeConfigurationDirectoryInClasspath;
    private String repositoryLayout;
    private String extraJvmArguments;
    private Set platforms;
    private ArtifactRepositoryFactory artifactRepositoryFactory;
    private ArtifactInstaller artifactInstaller;
    private ArtifactRepository artifactRepository;
    private ArtifactRepositoryLayout artifactRepositoryLayout;
    private PlatformUtil windowsPlatformUtil = new PlatformUtil(true);
    private PlatformUtil unixPlatformUtil = new PlatformUtil(false);
    private boolean defaultPlatformWindows = true;
    private boolean defaultPlatformUnix = true;

    public void validate() throws MojoFailureException, MojoExecutionException {
        if (this.repositoryLayout == null || this.repositoryLayout.equals("default")) {
            this.artifactRepositoryLayout = new DefaultRepositoryLayout();
        } else if (this.repositoryLayout.equals("legacy")) {
            this.artifactRepositoryLayout = new LegacyRepositoryLayout();
        } else {
            throw new MojoFailureException("Unknown repository layout '" + this.repositoryLayout + "'.");
        }
        HashSet<String> validPlatforms = new HashSet<String>();
        validPlatforms.add("all");
        validPlatforms.add("windows");
        validPlatforms.add("unix");
        if (this.platforms != null) {
            if (!validPlatforms.containsAll(this.platforms)) {
                throw new MojoFailureException("Non-valid default platform declared, supported types are: 'all', 'windows' and 'unix'");
            }
            this.defaultPlatformWindows = false;
            this.defaultPlatformUnix = false;
            if (this.platforms.contains("all")) {
                this.defaultPlatformWindows = true;
                this.defaultPlatformUnix = true;
            }
            if (this.platforms.contains("windows")) {
                this.defaultPlatformWindows = true;
            }
            if (this.platforms.contains("unix")) {
                this.defaultPlatformUnix = true;
            }
        }
        Iterator i = this.programs.iterator();
        while (i.hasNext()) {
            Program program = (Program)i.next();
            if (program.getMainClass() == null || program.getMainClass().trim().equals("")) {
                throw new MojoFailureException("Missing main class in Program configuration");
            }
            if (program.getPlatforms() == null || validPlatforms.containsAll(program.getPlatforms())) continue;
            throw new MojoFailureException("Non-valid platform for program declared, supported types are: 'all', 'windows' and 'unix'");
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.validate();
        this.artifactRepository = this.artifactRepositoryFactory.createDeploymentArtifactRepository("appassembler", "file://" + this.assembleDirectory.getAbsolutePath() + "/repo", this.artifactRepositoryLayout, false);
        Iterator it = this.artifacts.iterator();
        while (it.hasNext()) {
            Artifact artifact = (Artifact)it.next();
            this.installArtifact(artifact);
        }
        this.installArtifact(this.projectArtifact);
        this.setUpWorkingArea();
        it = this.programs.iterator();
        while (it.hasNext()) {
            Program program = (Program)it.next();
            if (program.getPlatforms() == null) {
                if (this.defaultPlatformWindows) {
                    this.createBinScript(program, this.windowsPlatformUtil);
                }
                if (!this.defaultPlatformUnix) continue;
                this.createBinScript(program, this.unixPlatformUtil);
                continue;
            }
            if (program.getPlatforms().contains("all")) {
                this.createBinScript(program, this.windowsPlatformUtil);
                this.createBinScript(program, this.unixPlatformUtil);
                break;
            }
            if (program.getPlatforms().contains("windows")) {
                this.createBinScript(program, this.windowsPlatformUtil);
            }
            if (!program.getPlatforms().contains("unix")) continue;
            this.createBinScript(program, this.unixPlatformUtil);
        }
    }

    private void installArtifact(Artifact artifact) throws MojoExecutionException {
        try {
            artifact.isSnapshot();
            this.artifactInstaller.install(artifact.getFile(), artifact, this.artifactRepository);
        }
        catch (ArtifactInstallationException e) {
            throw new MojoExecutionException("Failed to copy artifact.", (Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createBinScript(Program program, PlatformUtil platformUtil) throws MojoExecutionException {
        try {
            InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream(platformUtil.getBinTemplate());
            InputStreamReader reader = new InputStreamReader(in);
            HashMap<String, String> context = new HashMap<String, String>();
            context.put("MAINCLASS", program.getMainClass());
            context.put("CLASSPATH", platformUtil.getClassPath());
            context.put("EXTRA_JVM_ARGUMENTS", StringUtils.clean((String)this.extraJvmArguments));
            context.put("APP_NAME", program.getName());
            InterpolationFilterReader interpolationFilterReader = new InterpolationFilterReader((Reader)reader, context, platformUtil.getInterpolationToken(), platformUtil.getInterpolationToken());
            String programName = "";
            if (program.getName() == null || program.getName().trim().equals("")) {
                StringTokenizer tokenizer = new StringTokenizer(program.getMainClass(), ".");
                while (tokenizer.hasMoreElements()) {
                    programName = tokenizer.nextToken();
                }
                programName = programName.toLowerCase();
            } else {
                programName = program.getName();
            }
            if (this.binPrefix != null) {
                programName = this.binPrefix.trim() + programName;
            }
            String binFileName = programName + platformUtil.getBinFileExtension();
            File binFile = new File(this.assembleDirectory.getAbsolutePath() + "/bin", binFileName);
            FileWriter out = new FileWriter(binFile);
            try {
                IOUtil.copy((Reader)interpolationFilterReader, (Writer)out);
            }
            finally {
                IOUtil.close((Reader)interpolationFilterReader);
                IOUtil.close((Writer)out);
            }
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException("Failed to get template for bin file.", (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to write bin file.", (Exception)e);
        }
    }

    private void setUpWorkingArea() throws MojoFailureException {
        boolean success;
        File binDir = new File(this.assembleDirectory.getAbsolutePath(), "bin");
        if (!binDir.exists() && !(success = new File(this.assembleDirectory.getAbsolutePath(), "bin").mkdir())) {
            throw new MojoFailureException("Failed to create directory for bin files.");
        }
    }

    private class PlatformUtil {
        boolean isWindows;

        public PlatformUtil(boolean isWindows) {
            this.isWindows = isWindows;
        }

        public String getClassPath() {
            String classPath = "";
            HashSet<Artifact> classPathArtifacts = new HashSet<Artifact>(AssembleMojo.this.artifacts);
            classPathArtifacts.add(AssembleMojo.this.projectArtifact);
            if (AssembleMojo.this.includeConfigurationDirectoryInClasspath) {
                classPath = this.isWindows ? classPath + "\"%BASEDIR%\"\\etc;" : classPath + "\"$BASEDIR\"/etc:";
            }
            Iterator it = classPathArtifacts.iterator();
            while (it.hasNext()) {
                Artifact artifact = (Artifact)it.next();
                if (this.isWindows) {
                    String path = AssembleMojo.this.artifactRepositoryLayout.pathOf(artifact);
                    path = path.replace("/", "\\");
                    classPath = classPath + "%REPO%\\" + path + ";";
                    continue;
                }
                classPath = classPath + "$REPO/" + AssembleMojo.this.artifactRepositoryLayout.pathOf(artifact) + ":";
            }
            return classPath;
        }

        public String getBinTemplate() {
            if (this.isWindows) {
                return "/windowsBinTemplate";
            }
            return "/unixBinTemplate";
        }

        public String getInterpolationToken() {
            if (this.isWindows) {
                return "#";
            }
            return "@";
        }

        public String getBinFileExtension() {
            if (this.isWindows) {
                return ".bat";
            }
            return "";
        }
    }
}

