/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.appassembler.daemon;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.appassembler.daemon.DaemonGenerator;
import org.codehaus.mojo.appassembler.daemon.DaemonGeneratorException;
import org.codehaus.mojo.appassembler.daemon.DaemonGeneratorService;
import org.codehaus.mojo.appassembler.model.Daemon;
import org.codehaus.mojo.appassembler.model.JvmSettings;
import org.codehaus.mojo.appassembler.model.io.xpp3.AppassemblerModelXpp3Reader;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class DefaultDaemonGeneratorService
extends AbstractLogEnabled
implements DaemonGeneratorService {
    private Map generators;

    public void generateDaemon(String platform, File stubDescriptor, File outputDirectory, MavenProject mavenProject, ArtifactRepository localRepository) throws DaemonGeneratorException {
        this.generateDaemon(platform, stubDescriptor, null, outputDirectory, mavenProject, localRepository);
    }

    public void generateDaemon(String platform, File stubDescriptor, Daemon stubDaemon, File outputDirectory, MavenProject mavenProject, ArtifactRepository localRepository) throws DaemonGeneratorException {
        DaemonGenerator generator = (DaemonGenerator)this.generators.get(platform);
        if (generator == null) {
            throw new DaemonGeneratorException("Could not find a generator for platform '" + platform + "'.");
        }
        Daemon fileDaemon = null;
        if (stubDescriptor != null) {
            this.getLogger().debug("Loading daemon descriptor: " + stubDescriptor.getAbsolutePath());
            fileDaemon = this.loadModel(stubDescriptor);
        }
        Daemon mergedDaemon = this.mergeDaemons(stubDaemon, fileDaemon);
        this.validateDaemon(mergedDaemon, stubDescriptor);
        generator.generate(mergedDaemon, mavenProject, localRepository, outputDirectory);
    }

    public Daemon mergeDaemons(Daemon dominant, Daemon recessive) throws DaemonGeneratorException {
        if (dominant == null) {
            return recessive;
        }
        if (recessive == null) {
            return dominant;
        }
        Daemon result = new Daemon();
        result.setId(this.select(dominant.getId(), recessive.getId()));
        result.setMainClass(this.select(dominant.getMainClass(), recessive.getMainClass()));
        result.setDependencies(this.select(dominant.getDependencies(), recessive.getDependencies()));
        result.setCommandLineArguments(this.select(dominant.getCommandLineArguments(), recessive.getCommandLineArguments()));
        result.setJvmSettings((JvmSettings)this.select(dominant.getJvmSettings(), recessive.getJvmSettings()));
        return result;
    }

    public Daemon loadModel(File stubDescriptor) throws DaemonGeneratorException {
        Daemon stubDaemon;
        AppassemblerModelXpp3Reader reader = new AppassemblerModelXpp3Reader();
        try {
            stubDaemon = reader.read((Reader)new FileReader(stubDescriptor));
        }
        catch (XmlPullParserException e) {
            throw new DaemonGeneratorException("Error parsing " + stubDescriptor.getAbsolutePath(), e);
        }
        catch (FileNotFoundException e) {
            throw new DaemonGeneratorException("No such file: " + stubDescriptor.getAbsolutePath());
        }
        catch (IOException e) {
            throw new DaemonGeneratorException("Error while reading: " + stubDescriptor.getAbsolutePath());
        }
        this.validateDaemon(stubDaemon, stubDescriptor);
        return stubDaemon;
    }

    public void validateDaemon(Daemon daemon, File descriptor) throws DaemonGeneratorException {
        String mainClass = daemon.getMainClass();
        String missingRequiredField = descriptor != null ? "Missing required field from '" + descriptor.getAbsolutePath() + "': " : "Missing required field in daemon descriptor: ";
        if (StringUtils.isEmpty((String)mainClass)) {
            throw new DaemonGeneratorException(missingRequiredField + "main class.");
        }
        if (StringUtils.isEmpty((String)daemon.getId())) {
            String id = mainClass;
            int i = id.lastIndexOf(46);
            if (i > 0) {
                id = mainClass.substring(i + 1);
            }
            id = StringUtils.addAndDeHump((String)id);
            daemon.setId(id);
        }
    }

    private String select(String dominant, String recessive) {
        if (StringUtils.isNotEmpty((String)dominant)) {
            return dominant;
        }
        return recessive;
    }

    private List select(List dominant, List recessive) {
        if (dominant != null && dominant.size() > 0) {
            return dominant;
        }
        return recessive;
    }

    private Object select(Object dominant, Object recessive) {
        if (dominant != null) {
            return dominant;
        }
        return recessive;
    }
}

