/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.appassembler.daemon.generic;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.appassembler.daemon.DaemonGenerator;
import org.codehaus.mojo.appassembler.daemon.DaemonGeneratorException;
import org.codehaus.mojo.appassembler.daemon.Util;
import org.codehaus.mojo.appassembler.model.Daemon;
import org.codehaus.mojo.appassembler.model.Dependency;
import org.codehaus.mojo.appassembler.model.JvmSettings;
import org.codehaus.mojo.appassembler.model.io.xpp3.AppassemblerModelXpp3Writer;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

public class GenericDaemonGenerator
extends AbstractLogEnabled
implements DaemonGenerator {
    public void generate(Daemon stubDaemon, MavenProject project, ArtifactRepository localRepository, File outputDirectory) throws DaemonGeneratorException {
        Daemon mergedDaemon = this.mergeDaemon(stubDaemon, project, new JvmSettings());
        AppassemblerModelXpp3Writer writer = new AppassemblerModelXpp3Writer();
        try {
            FileUtils.forceMkdir((File)outputDirectory);
            File outputFile = new File(outputDirectory, mergedDaemon.getId() + ".xml");
            writer.write((Writer)new FileWriter(outputFile), mergedDaemon);
        }
        catch (IOException e) {
            throw new DaemonGeneratorException("Error while writing output file: " + outputDirectory, e);
        }
    }

    private Daemon mergeDaemon(Daemon stub, MavenProject project, JvmSettings defaultJvmSettings) {
        Daemon complete = new Daemon();
        complete.setId(stub.getId());
        complete.setMainClass(stub.getMainClass());
        complete.setJvmSettings(this.mergeJvmSettings(stub.getJvmSettings(), defaultJvmSettings));
        complete.setCommandLineArguments(stub.getCommandLineArguments());
        complete.setDependencies(new ArrayList());
        Dependency projectDependency = new Dependency();
        Artifact projectArtifact = project.getArtifact();
        projectDependency.setGroupId(projectArtifact.getGroupId());
        projectDependency.setArtifactId(projectArtifact.getArtifactId());
        projectDependency.setVersion(projectArtifact.getVersion());
        projectDependency.setClassifier(projectArtifact.getClassifier());
        projectDependency.setRelativePath(Util.getRelativePath(projectArtifact));
        complete.getDependencies().add(projectDependency);
        Iterator it = project.getRuntimeArtifacts().iterator();
        while (it.hasNext()) {
            Artifact artifact = (Artifact)it.next();
            Dependency dependency = new Dependency();
            dependency.setGroupId(artifact.getGroupId());
            dependency.setArtifactId(artifact.getArtifactId());
            dependency.setVersion(artifact.getVersion());
            dependency.setClassifier(artifact.getClassifier());
            dependency.setRelativePath(Util.getRelativePath(artifact));
            complete.getDependencies().add(dependency);
        }
        return complete;
    }

    private JvmSettings mergeJvmSettings(JvmSettings stubJvmSettings, JvmSettings defaultJvmSettings) {
        if (stubJvmSettings == null) {
            return defaultJvmSettings;
        }
        JvmSettings complete = new JvmSettings();
        complete.setInitialMemorySize(this.mergeString(stubJvmSettings.getInitialMemorySize(), defaultJvmSettings.getInitialMemorySize()));
        complete.setMaxMemorySize(this.mergeString(stubJvmSettings.getMaxMemorySize(), defaultJvmSettings.getMaxMemorySize()));
        complete.setMaxStackSize(this.mergeString(stubJvmSettings.getMaxStackSize(), defaultJvmSettings.getMaxStackSize()));
        return complete;
    }

    private String mergeString(String stub, String defaultString) {
        if (StringUtils.isEmpty((String)stub)) {
            return defaultString;
        }
        return stub;
    }
}

