/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.appassembler.daemon.jsw;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.appassembler.daemon.DaemonGenerator;
import org.codehaus.mojo.appassembler.daemon.DaemonGeneratorException;
import org.codehaus.mojo.appassembler.daemon.Util;
import org.codehaus.mojo.appassembler.model.Daemon;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.InterpolationFilterReader;
import org.codehaus.plexus.util.StringUtils;

public class JavaServiceWrapperDaemonGenerator
extends AbstractLogEnabled
implements DaemonGenerator {
    public void generate(Daemon daemon, MavenProject project, ArtifactRepository localRepository, File outputDirectory) throws DaemonGeneratorException {
        InputStream in = this.getClass().getResourceAsStream("wrapper.conf.template");
        if (in == null) {
            throw new DaemonGeneratorException("Could not load template.");
        }
        InputStreamReader reader = new InputStreamReader(in);
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("MAINCLASS", daemon.getMainClass());
        context.put("CLASSPATH", this.constructClasspath(project));
        context.put("ADDITIONAL", "");
        context.put("INITIAL_MEMORY", this.getInitialMemorySize(daemon));
        context.put("MAX_MEMORY", this.getMaxMemorySize(daemon));
        context.put("PARAMETERS", this.createParameters(daemon, project));
        InterpolationFilterReader interpolationFilterReader = new InterpolationFilterReader((Reader)reader, context, "@", "@");
        outputDirectory = new File(outputDirectory, "etc");
        File outputFile = new File(outputDirectory, daemon.getId() + "-wrapper.conf");
        FileWriter out = null;
        try {
            FileUtils.forceMkdir((File)outputDirectory);
            out = new FileWriter(outputFile);
            IOUtil.copy((Reader)interpolationFilterReader, (Writer)out);
        }
        catch (IOException e) {
            try {
                throw new DaemonGeneratorException("Error writing output file: " + outputFile.getAbsolutePath(), e);
            }
            catch (Throwable throwable) {
                IOUtil.close((Reader)interpolationFilterReader);
                IOUtil.close(out);
                throw throwable;
            }
        }
        IOUtil.close((Reader)interpolationFilterReader);
        IOUtil.close((Writer)out);
    }

    private String getInitialMemorySize(Daemon daemon) {
        if (daemon.getJvmSettings() == null || StringUtils.isNotEmpty((String)daemon.getJvmSettings().getInitialMemorySize())) {
            return null;
        }
        return daemon.getJvmSettings().getInitialMemorySize();
    }

    private String getMaxMemorySize(Daemon daemon) {
        if (daemon.getJvmSettings() == null || StringUtils.isNotEmpty((String)daemon.getJvmSettings().getMaxMemorySize())) {
            return null;
        }
        return daemon.getJvmSettings().getMaxMemorySize();
    }

    private String constructClasspath(MavenProject project) {
        StringWriter string = new StringWriter();
        PrintWriter writer = new PrintWriter(string);
        writer.println("wrapper.java.classpath.1=lib/wrapper.jar");
        writer.println("wrapper.java.classpath.2=../../repo/" + Util.getRelativePath(project.getArtifact()));
        int i = 3;
        Iterator it = project.getRuntimeArtifacts().iterator();
        while (it.hasNext()) {
            Artifact artifact = (Artifact)it.next();
            String path = Util.getRelativePath(artifact);
            writer.println("wrapper.java.classpath." + i + "=../../repo/" + path);
            ++i;
        }
        return string.toString();
    }

    private String createParameters(Daemon daemon, MavenProject project) {
        StringWriter buffer = new StringWriter();
        PrintWriter writer = new PrintWriter(buffer);
        writer.println("wrapper.app.parameter.1=" + daemon.getMainClass());
        int i = 2;
        Iterator it = daemon.getCommandLineArguments().iterator();
        while (it.hasNext()) {
            String argument = (String)it.next();
            writer.println("wrapper.app.parameter." + i + "=" + argument);
            ++i;
        }
        return buffer.toString();
    }
}

