/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.appassembler.daemon.generic;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.appassembler.daemon.DaemonGenerationRequest;
import org.codehaus.mojo.appassembler.daemon.DaemonGenerator;
import org.codehaus.mojo.appassembler.daemon.DaemonGeneratorException;
import org.codehaus.mojo.appassembler.daemon.merge.DaemonMerger;
import org.codehaus.mojo.appassembler.model.Classpath;
import org.codehaus.mojo.appassembler.model.Daemon;
import org.codehaus.mojo.appassembler.model.Dependency;
import org.codehaus.mojo.appassembler.model.io.stax.AppassemblerModelStaxWriter;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;

public class GenericDaemonGenerator
extends AbstractLogEnabled
implements DaemonGenerator {
    private DaemonMerger daemonMerger;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void generate(DaemonGenerationRequest request) throws DaemonGeneratorException {
        Daemon createdDaemon = this.createDaemon(request.getMavenProject(), request.getRepositoryLayout());
        Daemon mergedDaemon = this.daemonMerger.mergeDaemons(request.getDaemon(), createdDaemon);
        FileWriter writer = null;
        try {
            FileUtils.forceMkdir((File)request.getOutputDirectory());
            File outputFile = new File(request.getOutputDirectory(), mergedDaemon.getId() + ".xml");
            writer = new FileWriter(outputFile);
            AppassemblerModelStaxWriter staxWriter = new AppassemblerModelStaxWriter();
            staxWriter.write((Writer)writer, mergedDaemon);
        }
        catch (IOException e) {
            try {
                throw new DaemonGeneratorException("Error while writing output file: " + request.getOutputDirectory(), e);
                catch (XMLStreamException e2) {
                    throw new DaemonGeneratorException("Error while writing output file: " + request.getOutputDirectory(), e2);
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(writer);
                throw throwable;
            }
        }
        IOUtil.close((Writer)writer);
    }

    private Daemon createDaemon(MavenProject project, ArtifactRepositoryLayout layout) {
        Daemon complete = new Daemon();
        complete.setClasspath(new Classpath());
        Dependency projectDependency = new Dependency();
        Artifact projectArtifact = project.getArtifact();
        projectDependency.setGroupId(projectArtifact.getGroupId());
        projectDependency.setArtifactId(projectArtifact.getArtifactId());
        projectDependency.setVersion(projectArtifact.getVersion());
        projectDependency.setClassifier(projectArtifact.getClassifier());
        projectDependency.setRelativePath(layout.pathOf(projectArtifact));
        complete.getClasspath().addDependency(projectDependency);
        Iterator it = project.getRuntimeArtifacts().iterator();
        while (it.hasNext()) {
            Artifact artifact = (Artifact)it.next();
            Dependency dependency = new Dependency();
            dependency.setGroupId(artifact.getGroupId());
            dependency.setArtifactId(artifact.getArtifactId());
            dependency.setVersion(artifact.getVersion());
            dependency.setClassifier(artifact.getClassifier());
            dependency.setRelativePath(layout.pathOf(artifact));
            complete.getClasspath().addDependency(dependency);
        }
        return complete;
    }
}

