/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.appassembler.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.plexus.util.IOUtil;

public class FormattedProperties {
    private static final Pattern LIST_KEY_PATTERN = Pattern.compile("^(.*)\\.[0-9]+$");
    private final Properties properties = new Properties();
    private Map propertyLines;
    private List fileLines;
    private Map listProperties = new HashMap();
    private Map afterProperties = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(String key, String value) {
        Properties properties = this.properties;
        synchronized (properties) {
            this.properties.setProperty(key, value);
            Matcher m = LIST_KEY_PATTERN.matcher(key);
            if (m.matches()) {
                String listKey = m.group(1);
                ArrayList<String> p = (ArrayList<String>)this.listProperties.get(listKey);
                if (p == null) {
                    p = new ArrayList<String>();
                    this.listProperties.put(listKey, p);
                }
                p.add(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getProperty(String key) {
        Properties properties = this.properties;
        synchronized (properties) {
            return this.properties.getProperty(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getProperty(String key, String defaultValue) {
        Properties properties = this.properties;
        synchronized (properties) {
            return this.properties.getProperty(key, defaultValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProperty(String key) {
        Properties properties = this.properties;
        synchronized (properties) {
            ((Hashtable)this.properties).remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(InputStream inputStream) throws IOException {
        Properties properties = this.properties;
        synchronized (properties) {
            this.fileLines = new ArrayList();
            this.propertyLines = new HashMap();
            BufferedReader r = new BufferedReader(new InputStreamReader(inputStream));
            try {
                int lineNo = 1;
                String line = r.readLine();
                while (line != null) {
                    String[] pair = line.split("=", 2);
                    String key = pair[0];
                    if (pair.length > 1) {
                        Matcher m;
                        String value = pair[1].trim();
                        boolean commented = false;
                        if (key.startsWith("#")) {
                            commented = true;
                            key = key.substring(1);
                        }
                        key = key.trim();
                        if (!commented) {
                            this.setProperty(key, value);
                        }
                        if ((m = LIST_KEY_PATTERN.matcher(key)).matches()) {
                            key = m.group(1);
                        }
                        this.propertyLines.put(key, new Integer(lineNo));
                    }
                    this.fileLines.add(line);
                    line = r.readLine();
                    ++lineNo;
                }
            }
            finally {
                IOUtil.close((Reader)r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(OutputStream outputStream) {
        Properties properties = this.properties;
        synchronized (properties) {
            PrintWriter writer = new PrintWriter(new OutputStreamWriter(outputStream));
            try {
                HashSet<String> writtenProperties = new HashSet<String>();
                for (int i = 0; i < this.fileLines.size(); ++i) {
                    String line = (String)this.fileLines.get(i);
                    if (line.trim().length() > 0) {
                        List p;
                        Matcher m;
                        String value;
                        String[] pair = line.split("=", 2);
                        String key = pair[0];
                        if (key.startsWith("#")) {
                            key = key.substring(1);
                            writer.println(line);
                        }
                        if (new Integer(i + 1).equals(this.propertyLines.get(key = key.trim())) && (value = this.properties.getProperty(key)) != null) {
                            writer.println(key + "=" + value);
                            writtenProperties.add(key);
                        }
                        if (this.afterProperties.containsKey(key)) {
                            List p2 = (List)this.afterProperties.get(key);
                            Iterator j = p2.iterator();
                            while (j.hasNext()) {
                                String pKey = (String)j.next();
                                String value2 = this.properties.getProperty(pKey);
                                if (value2 == null || writtenProperties.contains(pKey)) continue;
                                writer.println(pKey + "=" + value2);
                                writtenProperties.add(pKey);
                            }
                        }
                        if (!(m = LIST_KEY_PATTERN.matcher(key)).matches() || !new Integer(i + 1).equals(this.propertyLines.get(key = m.group(1))) || (p = (List)this.listProperties.get(key)) == null) continue;
                        Iterator j = p.iterator();
                        while (j.hasNext()) {
                            String value3;
                            String itemKey = (String)j.next();
                            if (writtenProperties.contains(itemKey) || (value3 = this.properties.getProperty(itemKey)) == null) continue;
                            writer.println(itemKey + "=" + value3);
                            writtenProperties.add(itemKey);
                        }
                        continue;
                    }
                    writer.println(line);
                }
                Iterator i = ((Hashtable)this.properties).keySet().iterator();
                while (i.hasNext()) {
                    String value;
                    String key = (String)i.next();
                    if (writtenProperties.contains(key) || (value = this.properties.getProperty(key)) == null) continue;
                    writer.println(key + "=" + value);
                }
            }
            finally {
                IOUtil.close((Writer)writer);
            }
        }
    }

    public void setPropertyAfter(String key, String value, String afterProperty) {
        ArrayList<String> p = (ArrayList<String>)this.afterProperties.get(afterProperty);
        if (p == null) {
            p = new ArrayList<String>();
            this.afterProperties.put(afterProperty, p);
        }
        p.add(key);
        this.setProperty(key, value);
    }
}

