/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.appassembler;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.installer.ArtifactInstallationException;
import org.apache.maven.artifact.installer.ArtifactInstaller;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.appassembler.Program;
import org.codehaus.mojo.appassembler.daemon.DaemonGenerationRequest;
import org.codehaus.mojo.appassembler.daemon.DaemonGeneratorException;
import org.codehaus.mojo.appassembler.daemon.DaemonGeneratorService;
import org.codehaus.mojo.appassembler.model.Classpath;
import org.codehaus.mojo.appassembler.model.Daemon;
import org.codehaus.mojo.appassembler.model.Dependency;
import org.codehaus.mojo.appassembler.model.Directory;
import org.codehaus.mojo.appassembler.model.JvmSettings;
import org.codehaus.plexus.util.StringUtils;

public class AssembleMojo
extends AbstractMojo {
    private File assembleDirectory;
    private Set programs;
    private String configurationDirectory;
    private boolean includeConfigurationDirectoryInClasspath;
    private String repositoryLayout;
    private String extraJvmArguments;
    private Set platforms;
    private String environmentSetupFileName;
    private boolean generateRepository;
    private String repositoryName;
    private MavenProject mavenProject;
    private List artifacts;
    private Artifact projectArtifact;
    private ArtifactRepository localRepository;
    private boolean showConsoleWindow;
    private ArtifactRepositoryFactory artifactRepositoryFactory;
    private ArtifactInstaller artifactInstaller;
    private DaemonGeneratorService daemonGeneratorService;
    private Map availableRepositoryLayouts;
    private static final Set VALID_PLATFORMS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("unix", "windows")));

    public void validate(Set defaultPlatforms) throws MojoFailureException, MojoExecutionException {
        Iterator i = this.programs.iterator();
        while (i.hasNext()) {
            Program program = (Program)i.next();
            if (program.getMainClass() == null || program.getMainClass().trim().equals("")) {
                throw new MojoFailureException("Missing main class in Program configuration");
            }
            program.setPlatforms(this.validatePlatforms(program.getPlatforms(), defaultPlatforms));
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        Set defaultPlatforms = this.validatePlatforms(this.platforms, VALID_PLATFORMS);
        this.validate(defaultPlatforms);
        ArtifactRepositoryLayout artifactRepositoryLayout = (ArtifactRepositoryLayout)this.availableRepositoryLayouts.get(this.repositoryLayout);
        if (artifactRepositoryLayout == null) {
            throw new MojoFailureException("Unknown repository layout '" + this.repositoryLayout + "'.");
        }
        if (this.generateRepository) {
            ArtifactRepository artifactRepository = this.artifactRepositoryFactory.createDeploymentArtifactRepository("appassembler", "file://" + this.assembleDirectory.getAbsolutePath() + "/" + this.repositoryName, artifactRepositoryLayout, false);
            Iterator it = this.artifacts.iterator();
            while (it.hasNext()) {
                Artifact artifact = (Artifact)it.next();
                this.installArtifact(artifactRepository, artifact);
            }
            this.installArtifact(artifactRepository, this.projectArtifact);
        }
        this.setUpWorkingArea();
        Iterator it = this.programs.iterator();
        while (it.hasNext()) {
            Program program = (Program)it.next();
            Set platforms = this.validatePlatforms(program.getPlatforms(), defaultPlatforms);
            Iterator platformIt = platforms.iterator();
            while (platformIt.hasNext()) {
                String platform = (String)platformIt.next();
                Daemon daemon = this.programToDaemon(program, artifactRepositoryLayout);
                DaemonGenerationRequest request = new DaemonGenerationRequest(daemon, this.mavenProject, this.localRepository, this.assembleDirectory);
                request.setStubDaemon(request.getDaemon());
                request.setPlatform(platform);
                try {
                    this.daemonGeneratorService.generateDaemon(request);
                }
                catch (DaemonGeneratorException e) {
                    throw new MojoExecutionException("Error while generating script for the program '" + program.getName() + "' for the platform '" + platform + "': " + e.getMessage(), (Exception)e);
                }
            }
        }
    }

    private Daemon programToDaemon(Program program, ArtifactRepositoryLayout artifactRepositoryLayout) {
        Daemon daemon = new Daemon();
        daemon.setId(program.getName());
        daemon.setMainClass(program.getMainClass());
        daemon.setShowConsoleWindow(this.showConsoleWindow);
        ArrayList<Directory> directories = new ArrayList<Directory>();
        if (this.includeConfigurationDirectoryInClasspath) {
            Directory directory = new Directory();
            directory.setRelativePath(this.configurationDirectory);
            directories.add(directory);
        }
        if (daemon.getClasspath() == null) {
            daemon.setClasspath(new Classpath());
        }
        daemon.getClasspath().setDirectories(directories);
        daemon.setRepositoryName(this.repositoryName);
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        ArrayList<Artifact> classPathArtifacts = new ArrayList<Artifact>(this.artifacts);
        classPathArtifacts.add(this.projectArtifact);
        Iterator it = classPathArtifacts.iterator();
        while (it.hasNext()) {
            Artifact artifact = (Artifact)it.next();
            Dependency dependency = new Dependency();
            dependency.setGroupId(artifact.getGroupId());
            dependency.setArtifactId(artifact.getArtifactId());
            dependency.setVersion(artifact.getVersion());
            dependency.setRelativePath(artifactRepositoryLayout.pathOf(artifact));
            dependencies.add(dependency);
        }
        daemon.getClasspath().setDependencies(dependencies);
        JvmSettings jvmSettings = new JvmSettings();
        jvmSettings.setExtraArguments(AssembleMojo.parseTokens(this.extraJvmArguments));
        daemon.setJvmSettings(jvmSettings);
        daemon.setEnvironmentSetupFileName(this.environmentSetupFileName);
        return daemon;
    }

    private void installArtifact(ArtifactRepository artifactRepository, Artifact artifact) throws MojoExecutionException {
        try {
            artifact.isSnapshot();
            if (artifact.getFile() != null) {
                this.artifactInstaller.install(artifact.getFile(), artifact, artifactRepository);
            }
        }
        catch (ArtifactInstallationException e) {
            throw new MojoExecutionException("Failed to copy artifact.", (Exception)((Object)e));
        }
    }

    private void setUpWorkingArea() throws MojoFailureException {
        boolean success;
        File binDir = new File(this.assembleDirectory.getAbsolutePath(), "bin");
        if (!binDir.exists() && !(success = binDir.mkdirs())) {
            throw new MojoFailureException("Failed to create directory for bin files.");
        }
    }

    private Set validatePlatforms(Set platforms, Set defaultPlatforms) throws MojoFailureException {
        if (platforms == null) {
            return defaultPlatforms;
        }
        if (platforms.size() == 1 && platforms.iterator().next().equals("all")) {
            return VALID_PLATFORMS;
        }
        if (!VALID_PLATFORMS.containsAll(platforms)) {
            throw new MojoFailureException("Non-valid default platform declared, supported types are: " + VALID_PLATFORMS);
        }
        return platforms;
    }

    public static List parseTokens(String arg) {
        ArrayList<String> extraJvmArguments = new ArrayList<String>();
        if (StringUtils.isEmpty((String)arg)) {
            return extraJvmArguments;
        }
        StringTokenizer tokenizer = new StringTokenizer(arg);
        String argument = null;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (argument != null) {
                if (token.length() == 0) continue;
                int length = token.length();
                if (token.charAt(length - 1) == '\"') {
                    extraJvmArguments.add(argument + " " + token.substring(0, length - 1));
                    argument = null;
                    continue;
                }
                argument = argument + " " + token;
                continue;
            }
            if (token.charAt(0) == '\"') {
                argument = token.substring(1);
                continue;
            }
            extraJvmArguments.add(token);
        }
        return extraJvmArguments;
    }

    public void setAvailableRepositoryLayouts(Map availableRepositoryLayouts) {
        this.availableRepositoryLayouts = availableRepositoryLayouts;
    }
}

