package org.codehaus.mojo.appassembler;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/**
 * Display help information on appassembler-maven-plugin.<br/> Call <pre>  mvn appassembler:help -Ddetail=true -Dgoal=&lt;goal-name&gt;</pre> to display parameter details.
 *
 * @version generated on Mon Jan 24 23:12:48 PST 2011
 * @author org.apache.maven.tools.plugin.generator.PluginHelpGenerator (version 2.6)
 * @goal help
 * @requiresProject false
 */
public class HelpMojo
    extends AbstractMojo
{
    /**
     * If <code>true</code>, display all settable properties for each goal.
     * 
     * @parameter expression="${detail}" default-value="false"
     */
    private boolean detail;

    /**
     * The name of the goal for which to show help. If unspecified, all goals will be displayed.
     * 
     * @parameter expression="${goal}"
     */
    private java.lang.String goal;

    /**
     * The maximum length of a display line, should be positive.
     * 
     * @parameter expression="${lineLength}" default-value="80"
     */
    private int lineLength;

    /**
     * The number of spaces per indentation level, should be positive.
     * 
     * @parameter expression="${indentSize}" default-value="2"
     */
    private int indentSize;


    /** {@inheritDoc} */
    public void execute()
        throws MojoExecutionException
    {
        if ( lineLength <= 0 )
        {
            getLog().warn( "The parameter 'lineLength' should be positive, using '80' as default." );
            lineLength = 80;
        }
        if ( indentSize <= 0 )
        {
            getLog().warn( "The parameter 'indentSize' should be positive, using '2' as default." );
            indentSize = 2;
        }

        StringBuffer sb = new StringBuffer();

        append( sb, "org.codehaus.mojo:appassembler-maven-plugin:1.1.1", 0 );
        append( sb, "", 0 );

        append( sb, "Appassembler :: Maven Plug-In", 0 );
        append( sb, "A Mojo for generating bin scripts for Java applications.", 1 );
        append( sb, "", 0 );

        if ( goal == null || goal.length() <= 0 )
        {
            append( sb, "This plugin has 4 goals:", 0 );
            append( sb, "", 0 );
        }

        if ( goal == null || goal.length() <= 0 || "assemble".equals( goal ) )
        {
            append( sb, "appassembler:assemble", 0 );
            append( sb, "Assembles the artifacts and generates bin scripts for the configured applications", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "assembleDirectory (Default: ${project.build.directory}/appassembler)", 2 );
                append( sb, "The directory that will be used to assemble the artifacts in and place the bin scripts.", 3 );
                append( sb, "", 0 );

                append( sb, "binFileExtensions", 2 );
                append( sb, "The file extensions to use for bin files. The file extensions are stored in a Map that uses the platform name as key. To change the file extension for Unix bin files to \'.sh\' use this configuration:\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<binFileExtensions>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<unix>.sh</unix>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0</binFileExtensions>\n", 3 );
                append( sb, "", 0 );

                append( sb, "configurationDirectory (Default: etc)", 2 );
                append( sb, "The name of the target directory for configuration files.", 3 );
                append( sb, "", 0 );

                append( sb, "configurationSourceDirectory (Default: src/main/config)", 2 );
                append( sb, "The name of the source directory for configuration files.", 3 );
                append( sb, "", 0 );

                append( sb, "copyConfigurationDirectory (Default: false)", 2 );
                append( sb, "If the source configuration directory should be copied to the configured configurationDirectory.", 3 );
                append( sb, "", 0 );

                append( sb, "environmentSetupFileName", 2 );
                append( sb, "Setup file in $BASEDIR/bin to be called prior to execution.", 3 );
                append( sb, "", 0 );

                append( sb, "extraJvmArguments", 2 );
                append( sb, "Extra arguments that will be given to the JVM verbatim.", 3 );
                append( sb, "", 0 );

                append( sb, "generateRepository (Default: true)", 2 );
                append( sb, "Set to false to skip repository generation.", 3 );
                append( sb, "", 0 );

                append( sb, "includeConfigurationDirectoryInClasspath (Default: true)", 2 );
                append( sb, "If the configurationDirectory (etc by default) should be included in the beginning of the classpath in the generated bin files.", 3 );
                append( sb, "", 0 );

                append( sb, "platforms", 2 );
                append( sb, "The default platforms the plugin will generate bin files for. Configure with string values - \'all\'(default/empty) | \'windows\' | \'unix\'.", 3 );
                append( sb, "", 0 );

                append( sb, "programs", 2 );
                append( sb, "The set of Programs that bin files will be generated for.", 3 );
                append( sb, "", 0 );

                append( sb, "repositoryLayout (Default: default)", 2 );
                append( sb, "The layout of the generated Maven repository. Supported types - \'default\' (Maven2) | \'legacy\' (Maven1) | \'flat\' (flat lib/ style).", 3 );
                append( sb, "", 0 );

                append( sb, "repositoryName (Default: repo)", 2 );
                append( sb, "Path (relative to assembleDirectory) of the desired output repository.", 3 );
                append( sb, "", 0 );

                append( sb, "showConsoleWindow (Default: true)", 2 );
                append( sb, "Show console window when execute this application.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "create-repository".equals( goal ) )
        {
            append( sb, "appassembler:create-repository", 0 );
            append( sb, "Creates an appassembler repository. Note that this is deliberately a bit more specific than the assembly plugin version - if it can generate a flat layout and exclude JARs, it may be a suitable replacement.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "assembleDirectory", 2 );
                append( sb, "The directory that will be used to assemble the artifacts in and place the bin scripts.", 3 );
                append( sb, "", 0 );

                append( sb, "installBooterArtifacts (Default: false)", 2 );
                append( sb, "Whether to install the booter artifacts into the repository. This may be needed if you are using the Shell script generators.", 3 );
                append( sb, "", 0 );

                append( sb, "repoPath (Default: repo)", 2 );
                append( sb, "The directory that will be used for the dependencies, relative to assembleDirectory.", 3 );
                append( sb, "", 0 );

                append( sb, "repositoryLayout (Default: default)", 2 );
                append( sb, "The layout of the generated Maven repository. Supported types - \'default\' (Maven2) | \'legacy\' (Maven1) | \'flat\' (flat lib/ style).", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "generate-daemons".equals( goal ) )
        {
            append( sb, "appassembler:generate-daemons", 0 );
            append( sb, "Generates JSW based daemon wrappers.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "basedir", 2 );
                append( sb, "The base directory of the project.", 3 );
                append( sb, "", 0 );

                append( sb, "daemons", 2 );
                append( sb, "Set of Daemons to generate.", 3 );
                append( sb, "", 0 );

                append( sb, "defaultJvmSettings", 2 );
                append( sb, "JvmSettings describing min/max memory and stack size, system properties and extra arguments.", 3 );
                append( sb, "", 0 );

                append( sb, "repositoryLayout (Default: default)", 2 );
                append( sb, "The layout of the generated Maven repository. Supported types - \'default\' (Maven2) | \'legacy\' (Maven1) | \'flat\' (flat lib/ style).", 3 );
                append( sb, "", 0 );

                append( sb, "target", 2 );
                append( sb, "Target directory for generated daemons.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "help".equals( goal ) )
        {
            append( sb, "appassembler:help", 0 );
            append( sb, "Display help information on appassembler-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0appassembler:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "detail (Default: false)", 2 );
                append( sb, "If true, display all settable properties for each goal.", 3 );
                append( sb, "", 0 );

                append( sb, "goal", 2 );
                append( sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3 );
                append( sb, "", 0 );

                append( sb, "indentSize (Default: 2)", 2 );
                append( sb, "The number of spaces per indentation level, should be positive.", 3 );
                append( sb, "", 0 );

                append( sb, "lineLength (Default: 80)", 2 );
                append( sb, "The maximum length of a display line, should be positive.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( getLog().isInfoEnabled() )
        {
            getLog().info( sb.toString() );
        }
    }

    /**
     * <p>Repeat a String <code>n</code> times to form a new string.</p>
     *
     * @param str String to repeat
     * @param repeat number of times to repeat str
     * @return String with repeated String
     * @throws NegativeArraySizeException if <code>repeat < 0</code>
     * @throws NullPointerException if str is <code>null</code>
     */
    private static String repeat( String str, int repeat )
    {
        StringBuffer buffer = new StringBuffer( repeat * str.length() );

        for ( int i = 0; i < repeat; i++ )
        {
            buffer.append( str );
        }

        return buffer.toString();
    }

    /** 
     * Append a description to the buffer by respecting the indentSize and lineLength parameters.
     * <b>Note</b>: The last character is always a new line.
     * 
     * @param sb The buffer to append the description, not <code>null</code>.
     * @param description The description, not <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     */
    private void append( StringBuffer sb, String description, int indent )
    {
        for ( Iterator it = toLines( description, indent, indentSize, lineLength ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( '\n' );
        }
    }

    /** 
     * Splits the specified text into lines of convenient display length.
     * 
     * @param text The text to split into lines, must not be <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     * @return The sequence of display lines, never <code>null</code>.
     * @throws NegativeArraySizeException if <code>indent < 0</code>
     */
    private static List toLines( String text, int indent, int indentSize, int lineLength )
    {
        List lines = new ArrayList();

        String ind = repeat( "\t", indent );
        String[] plainLines = text.split( "(\r\n)|(\r)|(\n)" );
        for ( int i = 0; i < plainLines.length; i++ )
        {
            toLines( lines, ind + plainLines[i], indentSize, lineLength );
        }

        return lines;
    }

    /** 
     * Adds the specified line to the output sequence, performing line wrapping if necessary.
     * 
     * @param lines The sequence of display lines, must not be <code>null</code>.
     * @param line The line to add, must not be <code>null</code>.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     */
    private static void toLines( List lines, String line, int indentSize, int lineLength )
    {
        int lineIndent = getIndentLevel( line );
        StringBuffer buf = new StringBuffer( 256 );
        String[] tokens = line.split( " +" );
        for ( int i = 0; i < tokens.length; i++ )
        {
            String token = tokens[i];
            if ( i > 0 )
            {
                if ( buf.length() + token.length() >= lineLength )
                {
                    lines.add( buf.toString() );
                    buf.setLength( 0 );
                    buf.append( repeat( " ", lineIndent * indentSize ) );
                }
                else
                {
                    buf.append( ' ' );
                }
            }
            for ( int j = 0; j < token.length(); j++ )
            {
                char c = token.charAt( j );
                if ( c == '\t' )
                {
                    buf.append( repeat( " ", indentSize - buf.length() % indentSize ) );
                }
                else if ( c == '\u00A0' )
                {
                    buf.append( ' ' );
                }
                else
                {
                    buf.append( c );
                }
            }
        }
        lines.add( buf.toString() );
    }

    /** 
     * Gets the indentation level of the specified line.
     * 
     * @param line The line whose indentation level should be retrieved, must not be <code>null</code>.
     * @return The indentation level of the line.
     */
    private static int getIndentLevel( String line )
    {
        int level = 0;
        for ( int i = 0; i < line.length() && line.charAt( i ) == '\t'; i++ )
        {
            level++;
        }
        for ( int i = level + 1; i <= level + 4 && i < line.length(); i++ )
        {
            if ( line.charAt( i ) == '\t' )
            {
                level++;
                break;
            }
        }
        return level;
    }
}
